package com.avaya.customer.example.servlet.api;

public class TranscriptContext {

    /**
     * The ID of Customer Contact
     */
    protected int contactId;

    /**
     * The ID of Customer
     */
    protected int customerId;

    /**
     * The ID of Chat Request
     */
    protected String workRequestId;

    /**
     * unique Id for a given conversation; unique and immutable
     */
    protected String conversationId;

    /**
     * identifier for the channel from which a message originated. May include one of "web", "ios", "android",
     * "messenger", "whatsapp", "wechat", "line" or any number of other channels.
     */
    protected String channelSrc;

    /**
     * unique Id of external end-user for Oceana to correlate internal user for various features such as customer
     * journey, history, etc.
     */
    protected String endUserId;

    /**
     * Tenant Id from messaging provider (aggregator appId); unique and immutable
     */
    protected String tenantId;

    public TranscriptContext() {

    }

    /**
     * 
     * @param contactId
     * @param customerId
     * @param workRequestId
     * @param conversationId
     * @param channelSrc
     * @param endUserId
     * @param tenantId
     */
    public TranscriptContext(int contactId, int customerId, String workRequestId, String conversationId,
            String channelSrc, String endUserId, String tenantId) {
        this.contactId = contactId;
        this.customerId = customerId;
        this.workRequestId = workRequestId;
        this.conversationId = conversationId;
        this.channelSrc = channelSrc;
        this.endUserId = endUserId;
        this.tenantId = tenantId;
    }

    public int getContactId() {
        return contactId;
    }

    public void setContactId(int contactId) {
        this.contactId = contactId;
    }

    public int getCustomerId() {
        return customerId;
    }

    public void setCustomerId(int customerId) {
        this.customerId = customerId;
    }

    public String getWorkRequestId() {
        return workRequestId;
    }

    public void setWorkRequestId(String workRequestId) {
        this.workRequestId = workRequestId;
    }

    public String getConversationId() {
        return conversationId;
    }

    public void setConversationId(String conversationId) {
        this.conversationId = conversationId;
    }

    public String getChannelSrc() {
        return channelSrc;
    }

    public void setChannelSrc(String channelSrc) {
        this.channelSrc = channelSrc;
    }

    public String getEndUserId() {
        return endUserId;
    }

    public void setEndUserId(String endUserId) {
        this.endUserId = endUserId;
    }

    public String getTenantId() {
        return tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public String toString() {
        return "TranscriptContext{" + "contactId=" + contactId + ", customerId=" + customerId + ", workRequestId='"
                + workRequestId + '\'' + ", conversationId='" + conversationId + '\'' + ", channelSrc='" + channelSrc
                + '\'' + ", endUserId='" + endUserId + '\'' + ", tenantId='" + tenantId + '\'' + '}';
    }
}
