package com.avaya.customer.example.servlet.api;

/**
 * Common enum for message types.
 */


public enum MessageType {
    /** A message visible to both agents and customers */
        NORMAL,
        /** A message configured to send when the first agent joins the room */
        WELCOMEMESSAGE,
        /** A message only visible to agents in the room */
        WHISPER,
        /** A comfort message automatically sent due to agent inactivity */
        COMFORTMESSAGE,
        /** A page push URL. The 'message' field will contain the URL. Only applies to URLs sent to the customer. */
        PAGEPUSH,
        /** A file transfer message. The 'message' field will contain the file name */
        FILETRANSFER,
        /** An async message visible to both agents and customers. The 'message' field will contain the text fallback */
        RICHMEDIAMESSAGE,
        /** An async rich media message, only visible to agent in the room. The 'message' field will contain the text fallback */
        RICHMEDIAMESSAGE_WHISPER,
        /** An async rich media page push URL. The 'message' field will contain the text fallback. Only applies to URLs sent to the customer. **/
        RICHMEDIAMESSAGE_PAGEPUSH,
        /** An error message. The 'message' field will contain the error message **/
        ERROR;

}
