package com.avaya.customer.example.servlet.api;

import java.io.IOException;

import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.junit.Assert;
import org.junit.Test;

public class MessageTranscriptV2Test {
    private final static ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private final static String TEST_CUSTOM_DATA = "{\n" +
            "                  \"{k1}\": \"{v1}\",\n" +
            "                  \"asyncMessageInfo\": {\n" +
            "                        \"message\": {\n" +
            "                              \"text\": \"Hi! text message with emoji U+1F601 happy face.\",\n" +
            "                              \"received\": 1590092015.427,\n" +
            "                              \"channelSrc\": \"whatsapp\",\n" +
            "                              \"quotedMessage\": {\n" +
            "                                   \"messageId\": \"5ea90a61407430000de411d7\",\n" +
            "                                   \"messageType\": \"text\",\n" +
            "                                   \"text\": \"Hello, I am quoted message.\",\n" +
            "                                   \"received\": 1590092013.065,\n" +
            "                                   \"displayName\": \"Tyler Durden\",\n" +
            "                                   \"role\": \"appUser\",\n" +
            "                                   \"authorId\": \"659dc2f3d774b91e6b6fb100\",\n" +
            "                                   \"source\": {\n" +
            "                                         \"originalMessageId\": \"ABGGYUNWUgMPAgo-sNEyAarsxHOV\",\n" +
            "                                         \"originalMessageTimestamp\": 1590092000.065,\n" +
            "                                         \"type\": \"whatsapp\",\n" +
            "                                         \"integrationId\": \"5d5d0f3b28aa25001062b89c\"\n" +
            "                                   }\n" +
            "                              }\n" +
            "                        }\n" +
            "                  }\n" +
            "            }";

    @Test
    public void textOfMessageIsFilteredInCustomData() throws IOException {
        MessageTranscriptV2 transcriptV2 = new MessageTranscriptV2();
        transcriptV2.setCustomData(TEST_CUSTOM_DATA);
        MessageTranscriptV2 filteredMessage = transcriptV2.getFilteredMessage();
        JsonNode parsedCustomData = OBJECT_MAPPER.readTree(filteredMessage.getCustomData());
        JsonNode text =  parsedCustomData.path("asyncMessageInfo").path("message").path("text");
        Assert.assertEquals("Hi! text message with emoji U+1F601 happy face. been filtered", text.getTextValue());
    }

    @Test
    public void textOfQuotedMessageIsFilteredInCustomData() throws IOException {
        MessageTranscriptV2 transcriptV2 = new MessageTranscriptV2();
        transcriptV2.setCustomData(TEST_CUSTOM_DATA);
        MessageTranscriptV2 filteredMessage = transcriptV2.getFilteredMessage();
        JsonNode parsedCustomData = OBJECT_MAPPER.readTree(filteredMessage.getCustomData());
        JsonNode text =  parsedCustomData.path("asyncMessageInfo").path("message").path("quotedMessage").path("text");
        Assert.assertEquals("Hello, I am quoted message. been filtered", text.getTextValue());
    }
}