/*
 * /////////////////////////////////////////////////////////////////////////////////
 * //
 * // Copyright <2015>-<2016> Avaya Inc. All Rights Reserved.
 * //
 * // Usage of this source is bound to the terms described
 * // in assets/Licence.txt
 * //
 * // Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 * // or Avaya Policy
 * //
 * /////////////////////////////////////////////////////////////////////////////
 */

package com.avaya.odonnell3.AndroidChatTemplate_2_3.UtilClasses;

import android.app.Activity;
import android.content.Context;
import android.telephony.TelephonyManager;
import android.util.Log;
import com.avaya.odonnell3.AndroidChatTemplate_2_3.classes.MessageParser;
import com.avaya.odonnell3.AndroidChatTemplate_2_3.classes.PhoneInformation;
import com.avaya.odonnell3.AndroidChatTemplate_2_3.model.CustomFields;
import com.avaya.odonnell3.AndroidChatTemplate_2_3.model.CustomerJsonWrapper;
import com.avaya.odonnell3.AndroidChatTemplate_2_3.model.Intrinsics;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BuildRequestUtils extends Activity {


public BuildRequestUtils(){

}

    public static Intrinsics setIntrinsics(String name, String phoneNo, String email, Context context,String channelType,List<String> attributesList) {
        // customer info from device

        TelephonyManager tMgr = (TelephonyManager) context.getSystemService(Context.TELEPHONY_SERVICE);
       // String devicePhoneNumber = tMgr.getLine1Number();
        //phone number and dial code from phone
        String countryCode = tMgr.getNetworkCountryIso();
        //get the international dial code from the country-code
        PhoneInformation pInfo = new PhoneInformation();
//        String dialCode = "111";
        //get the country name from the device
        String country = pInfo.getInternationalDialCode(countryCode);

       // Log.v("USER", "phone No: " + devicePhoneNumber);
        Log.v("USER", "country: " + country);
        Log.v("USER", "networkOperator country code " + countryCode);
//        Log.v("USER", dialCode);

        // Custom fields with device type and OS
        String os = android.os.Build.VERSION.INCREMENTAL;
        String device = android.os.Build.PRODUCT;
        CustomFields field1 = new CustomFields("Operating System", os);
        CustomFields field2 = new CustomFields("Device Type", device);
        List<CustomFields> fieldsList = new ArrayList<>();
        fieldsList.add(field1);
        fieldsList.add(field2);
        // SkillSetIntrinsics
        Intrinsics intrinsics = new Intrinsics();
        intrinsics.setCustomFields(fieldsList);
        intrinsics.setName(name);
        intrinsics.setEmail(email);
        intrinsics.setPhoneNumber(phoneNo);
//        intrinsics.setArea(dialCode);
        intrinsics.setCountry(country);
        intrinsics.setChannelAttribute(channelType);
        intrinsics.setAttributes(attributesList);

        return intrinsics;
    }

    public static boolean isValidEmail(String email) {
        final String EMAIL_PATTERN = "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
        Pattern pattern = Pattern.compile(EMAIL_PATTERN);
        Matcher matcher = pattern.matcher(email);

        return matcher.matches();
    }

    public static CustomerJsonWrapper getMessageAsJava(String inMessage) {
        CustomerJsonWrapper wrapper;
        wrapper = MessageParser.jsonStringToJava(inMessage);
        return wrapper;
    }



}
