/*
 * /////////////////////////////////////////////////////////////////////////////////
 * //
 * // Copyright <2015>-<2016> Avaya Inc. All Rights Reserved.
 * //
 * // Usage of this source is bound to the terms described
 * // in assets/Licence.txt
 * //
 * // Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 * // or Avaya Policy
 * //
 * /////////////////////////////////////////////////////////////////////////////
 */

package com.avaya.odonnell3.AndroidChatTemplate_2_3.model;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.ArrayList;
import java.util.List;

public class ParticipantLeave {

    @JsonProperty("agentId")
    private String agentId;
    @JsonProperty("endChatFlag")
    private Boolean endChatFlag;
    @JsonProperty("numberOfParticipants")
    private Integer numberOfParticipants;
    @JsonProperty("participants")
    private List<CustomerParticipant> participants = new ArrayList<>();
    @JsonProperty("method")
    private String method;

    public String getLeaveReason() {
        return leaveReason;
    }

    public void setLeaveReason(String leaveReason) {
        this.leaveReason = leaveReason;
    }

    @JsonProperty("leaveReason")
    private String leaveReason;

    public ParticipantLeave() {

    }

    public ParticipantLeave(String agentId, Boolean endChatFlag,
                            Integer numberOfParticipants,
                            List<CustomerParticipant> participants, String method) {
        super();
        this.agentId = agentId;
        this.endChatFlag = endChatFlag;
        this.numberOfParticipants = numberOfParticipants;
        this.participants = participants;
        this.method = method;
    }


    public String getAgentId() {
        return agentId;
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public Boolean getEndChatFlag() {
        return endChatFlag;
    }

    public void setEndChatFlag(Boolean endChatFlag) {
        this.endChatFlag = endChatFlag;
    }

    public Integer getNumberOfParticipants() {
        return numberOfParticipants;
    }

    public void setNumberOfParticipants(Integer numberOfParticipants) {
        this.numberOfParticipants = numberOfParticipants;
    }

    public List<CustomerParticipant> getParticipants() {
        return participants;
    }

    public void setParticipants(List<CustomerParticipant> participants) {
        this.participants = participants;
    }

    public String getMethod() {
        return method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    @Override
    public String toString() {
        return "ParticipantLeave{" +
                "agentId='" + agentId + '\'' +
                ", endChatFlag=" + endChatFlag +
                ", numberOfParticipants=" + numberOfParticipants +
                ", participants=" + participants +
                ", method='" + method + '\'' +
                '}';
    }
}
