/*
 * /////////////////////////////////////////////////////////////////////////////////
 * //
 * // Copyright <2015>-<2016> Avaya Inc. All Rights Reserved.
 * //
 * // Usage of this source is bound to the terms described
 * // in assets/Licence.txt
 * //
 * // Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 * // or Avaya Policy
 * //
 * /////////////////////////////////////////////////////////////////////////////
 */

package com.avaya.odonnell3.AndroidChatTemplate_2_3.application;

import android.app.Application;
import android.content.Intent;
import android.util.Log;

import com.avaya.odonnell3.AndroidChatTemplate_2_3.services.WebSocketService;


//this class creates a default exception handler to close the WebSocket service if there is an unexpected error
public class ChatTemplateApplication extends Application {

    private Thread.UncaughtExceptionHandler defaultHandler;

    private Thread.UncaughtExceptionHandler handler = new Thread.UncaughtExceptionHandler() {
        @Override
        public void uncaughtException(Thread thread, Throwable ex) {
            Log.e("Error","Uncaught Exception: "+ex);
            defaultHandler.uncaughtException(thread,ex);
            Intent intent = new Intent(getApplicationContext(), WebSocketService.class);
            getApplicationContext().stopService(intent);

        }
    };

    @Override
    public void onCreate() {
        super.onCreate();
        defaultHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(handler);
    }
}
