/*
 * /////////////////////////////////////////////////////////////////////////////////
 * //
 * // Copyright <2015>-<2016> Avaya Inc. All Rights Reserved.
 * //
 * // Usage of this source is bound to the terms described
 * // in assets/Licence.txt
 * //
 * // Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 * // or Avaya Policy
 * //
 * /////////////////////////////////////////////////////////////////////////////
 */

package com.avaya.odonnell3.AndroidChatTemplate_2_3.model;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.ArrayList;
import java.util.List;

public class NewParticipant {

    @JsonProperty("agentId")
    private String agentId;
    @JsonProperty("numberOfParticipants")
    private Integer numberOfParticipants;
    @JsonProperty("displayName")
    private String displayName;
    @JsonProperty("role")
    private String role;
    @JsonProperty("participants")
    private List<CustomerParticipant> participants = new ArrayList<>();
    @JsonProperty("method")
    private String method;

    public List<WebOnHoldComfortGroup> getWebOnHoldComfortGroup() {
        return webOnHoldComfortGroup;
    }

    public void setWebOnHoldComfortGroup(List<WebOnHoldComfortGroup> webOnHoldComfortGroup) {
        this.webOnHoldComfortGroup = webOnHoldComfortGroup;
    }

    @JsonProperty("webOnHoldComfortGroup")
    private List<WebOnHoldComfortGroup> webOnHoldComfortGroup = new ArrayList<>();


    public NewParticipant(){

    }

    public NewParticipant(String agentId, Integer numberOfParticipants, String displayName, String role, List<CustomerParticipant> participants, String method, List<WebOnHoldComfortGroup> webOnHoldComfortGroup) {
        this.agentId = agentId;
        this.numberOfParticipants = numberOfParticipants;
        this.displayName = displayName;
        this.role = role;
        this.participants = participants;
        this.method = method;
        this.webOnHoldComfortGroup = webOnHoldComfortGroup;
    }

    public String getAgentId() {
        return agentId;
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public Integer getNumberOfParticipants() {
        return numberOfParticipants;
    }

    public void setNumberOfParticipants(Integer numberOfParticipants) {
        this.numberOfParticipants = numberOfParticipants;
    }

    public String getDisplayName() {
        return displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getRole() {
        return role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public List<CustomerParticipant> getParticipants() {
        return participants;
    }

    public void setParticipants(List<CustomerParticipant> participants) {
        this.participants = participants;
    }

    public String getMethod() {
        return method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    @Override
    public String toString() {
        return "NewParticipant{" +
                "agentId='" + agentId + '\'' +
                ", numberOfParticipants=" + numberOfParticipants +
                ", displayName='" + displayName + '\'' +
                ", role='" + role + '\'' +
                ", participants=" + participants +
                ", method='" + method + '\'' +
                '}';
    }
}
