/*
 * /////////////////////////////////////////////////////////////////////////////////
 * //
 * // Copyright <2015>-<2016> Avaya Inc. All Rights Reserved.
 * //
 * // Usage of this source is bound to the terms described
 * // in assets/Licence.txt
 * //
 * // Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 * // or Avaya Policy
 * //
 * /////////////////////////////////////////////////////////////////////////////
 */

package com.avaya.odonnell3.AndroidChatTemplate_2_3.classes;

import android.animation.Animator;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.util.Log;
import android.view.View;
import android.view.ViewAnimationUtils;
import android.webkit.JavascriptInterface;
import android.widget.Toast;

import com.avaya.odonnell3.AndroidChatTemplate_2_3.R;
import com.avaya.odonnell3.AndroidChatTemplate_2_3.UtilClasses.ChatActivityUtils;
import com.avaya.odonnell3.AndroidChatTemplate_2_3.activities.ChatActivity;

public class CoBrowseJSInterface {
    private ChatActivity ca;
    private ChatActivityUtils chatUtils;

    public CoBrowseJSInterface(Activity activity) {

        ca = (ChatActivity) activity;
        chatUtils = new ChatActivityUtils(ca);
    }

    @JavascriptInterface
    public void closeCoBrowse() {

        ca.rootLayout.setBackgroundResource(0);
        ca.coBrowseWrapper.setVisibility(View.GONE);
        ca.coBrowseWrapper.startAnimation(ca.slideDownBody);
        Toast.makeText(ca.getApplicationContext(), R.string.stop_cobrowse_success, Toast.LENGTH_LONG).show();

    }

    @JavascriptInterface
    public void onJoinSuccess() {
        Log.v("JS", "onJoinSuccess()");
        showCoBrowseStart();
    }

    @JavascriptInterface
    public void onJoinFailure() {
        Log.v("JS", "onJoinFailure()");
        Log.e("JS", "Failed to join Co-Browse session");
    }

    @JavascriptInterface
    public void onPauseSuccess() {
        Log.v("JS", "onPauseSuccess()");
        ca.isPaused = true;
    }

    @JavascriptInterface
    public void onPauseFailure() {
        Log.v("JS", "onPauseFailure()");
        ca.isPaused = false;
    }

    @JavascriptInterface
    public void onResumeSuccess() {
        Log.v("JS", "onResumeSuccess()");
    }

    @JavascriptInterface
    public void onResumeFailure() {
        Log.v("JS", "onResumeFailure()");
    }

    @JavascriptInterface
    public void onGrantControlSuccess() {
        Log.v("JS", "onGrantControlSuccess()");
        ca.runOnUiThread(new Runnable() {
            @Override
            public void run() {

                ca.revokeCoBrowseBtn.setVisibility(View.VISIBLE);
                ca.pauseCoBrowseBtn.setVisibility(View.GONE);
                ca.stopCoBrowseBtn.setVisibility(View.GONE);
            }
        });
    }

    @JavascriptInterface
    public void onGrantControlFailure() {
        Log.v("JS", "onGrantControlFailure()");
    }

    @JavascriptInterface
    public void onDenyControlSuccess() {
        Log.v("JS", "onDenyControlSuccess()");
        ca.revokeCoBrowseBtn.setVisibility(View.GONE);
    }

    @JavascriptInterface
    public void onDenyControlFailure() {
        Log.v("JS", "onDenyControlFailure()");
    }

    @JavascriptInterface
    public void onRevokeControlSuccess() {
        Log.v("JS", "onRevokeControlSuccess()");

        ca.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                hideOnRevoke();
            }
        });

    }

    private void hideOnRevoke() {
        ca.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                ca.revokeCoBrowseBtn.setVisibility(View.GONE);
                ca.pauseCoBrowseBtn.setVisibility(View.VISIBLE);
                ca.stopCoBrowseBtn.setVisibility(View.VISIBLE);
                chatUtils.hideCoBrowseButtons();
            }
        });

    }

    @JavascriptInterface
    public void onRevokeControlFailure() {
        Log.v("JS", "onRevokeControlFailure()");
    }

    @JavascriptInterface
    public void onStopSuccess() {
        Log.v("JS", "onStopSuccess()");
        ca.isStopped = true;
        ca.runOnUiThread(new Runnable() {
            @Override
            public void run() {

                closeCoBrowse();
            }
        });
    }

    @JavascriptInterface
    public void onStopFailure() {
        Log.v("JS", "onStopFailure()");
        ca.isStopped = false;
        Toast.makeText(ca.getApplicationContext(), R.string.stop_cobrowse_failure, Toast.LENGTH_LONG).show();
    }

    @JavascriptInterface
    public void onConnection() {
        Log.v("JS", "onConnection()");
        ca.isStopped = false;
        ca.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                chatUtils.switchFragment();

            }
        });
    }

    @JavascriptInterface
    public void onSessionClose(String title, String text) {
        Log.v("JS", "onSessionClose(" + title + "," + text + ")");

        ca.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                closeCoBrowse();
            }
        });
    }

    @JavascriptInterface
    public void onControlRequest() {
        Log.v("JS", "onControlRequest()");
        ca.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                coBrowseControlDialog();

            }
        });
    }

    @JavascriptInterface
    public void onControlRelease() {
        Log.v("JS", "onControlRelease()");
        Toast.makeText(ca, R.string.release_toast, Toast.LENGTH_SHORT).show();
    }


    private void animateView(View v) {
        int cx = v.getWidth() / 2;
        int cy = v.getHeight() / 2;

        float finalRadius = (float) Math.hypot(cx, cy);
        Animator anim = null;
        if (android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.LOLLIPOP) {
            anim = ViewAnimationUtils.createCircularReveal(v, cx, cy, 0, finalRadius);
        }
        if (anim != null) {
            anim.start();
        }
    }

    public void showCoBrowseStart() {
        ca.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                Log.v("JS", "showCoBrowseStart()");
                ca.rootLayout.setBackgroundResource(R.drawable.background_cobrowse_go);
                ca.coBrowseViewButton.setVisibility(View.VISIBLE);
                ca.coBrowseWrapper.setVisibility(View.VISIBLE);
                animateView(ca.coBrowseViewButton);
                Toast.makeText(ca, "A Co-Browse Session Has Started", Toast.LENGTH_SHORT).show();

            }
        });
    }

    private void coBrowseControlDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder(ca);

        final String name = ca.currentAgent;

        builder.setTitle("An Agent Has Requested Control");
        builder.setPositiveButton(R.string.grant, new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                ca.runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        Log.v("JS", "executing grantControl()");
                        String jsString = "javaScript:coBrowse.grantControl(" + "'" + name + "'" + ");";
                        ca.browseFragment.webView.loadUrl(jsString);
                        Toast.makeText(ca, R.string.control_toast, Toast.LENGTH_SHORT).show();


                    }
                });
            }
        });
        builder.setNegativeButton(R.string.deny, new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialog, int which) {
                ca.runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        Log.v("JS", "executing denyControl()");

                        String jsString = "javaScript:coBrowse.denyControl(" + "'" + name + "'" + ");";
                        ca.browseFragment.webView.loadUrl(jsString);


                    }
                });

            }
        });

        AlertDialog dialog = builder.create();
        dialog.show();
    }
}
