/*
 * /////////////////////////////////////////////////////////////////////////////////
 * //
 * // Copyright <2015>-<2016> Avaya Inc. All Rights Reserved.
 * //
 * // Usage of this source is bound to the terms described
 * // in assets/Licence.txt
 * //
 * // Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 * // or Avaya Policy
 * //
 * /////////////////////////////////////////////////////////////////////////////
 */

package com.avaya.odonnell3.AndroidChatTemplate_2_3.model;


import java.text.SimpleDateFormat;
import java.util.Calendar;


public class ChatMessage {

    private String name;
    private String time;
    private String message;
    private int senderType;
    /*
     * senderType 0 = customer;
     *        1 = agent 1
     *        2 = wait message
     *        3 = page-push
     *        4 = date header
     *        5 = onHoldUrl
     * */

    public ChatMessage() {
    }

    public ChatMessage(String message, int senderType) {
        this.time = getTheTime();
        this.message = message;
        this.senderType = senderType;
    }

    public ChatMessage(String name, String message, int senderType) {
        this.name = name;
        this.time = getTheTime();
        this.message = message;
        this.senderType = senderType;
    }

    public String getTime() {
        return time;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public int getSenderType() {
        return senderType;
    }

    public void setSenderType(int senderType) {
        this.senderType = senderType;
    }

    @Override
    public String toString() {
        return "ChatMessage{" +
                "name='" + name + '\'' +
                ", time='" + time + '\'' +
                ", message='" + message + '\'' +
                ", senderType=" + senderType +
                '}';
    }

    public String getTheTime() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("h:mm a");
        return sdf.format(cal.getTime());
    }
}
