/*
 * /////////////////////////////////////////////////////////////////////////////////
 * //
 * // Copyright <2015>-<2016> Avaya Inc. All Rights Reserved.
 * //
 * // Usage of this source is bound to the terms described
 * // in assets/Licence.txt
 * //
 * // Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 * // or Avaya Policy
 * //
 * /////////////////////////////////////////////////////////////////////////////
 */

package com.avaya.odonnell3.AndroidChatTemplate_2_3.model;

import java.util.HashMap;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonProperty;

public class RequestContextId {

    @JsonProperty("DataCenter")
    private String dataCenter;
    @JsonProperty("CustomerId")
    private String customerId;
    @JsonProperty("AgentId")
    private String agentId;
    @JsonProperty("Strategy")
    private String strategy;
    @JsonProperty("ResourceMap")
    private Map<?, ?> resourceMap;
    @JsonProperty("ServiceMap")
    private Map<String, ServiceMap> serviceMap;

    public RequestContextId() {
    }

    public RequestContextId(String dataCenter, String customerId,
                            String agentId, String strategy, Map<?, ?> resourceMap, Map<String, ServiceMap> serviceMap) {
        super();
        this.dataCenter = dataCenter;
        this.customerId = customerId;
        this.agentId = agentId;
        this.strategy = strategy;
        this.resourceMap = resourceMap;
        this.serviceMap = serviceMap;
    }

    public RequestContextId(Map<String, ServiceMap> serviceMap) {
        super();
        this.dataCenter = "Primary";
        this.customerId = "1";
        this.agentId = "";
        this.strategy = "Most Idle";
        this.resourceMap = new HashMap<>();
        this.serviceMap = serviceMap;
    }

    public String getDataCenter() {
        return dataCenter;
    }

    public void setDataCenter(String dataCenter) {
        this.dataCenter = dataCenter;
    }

    public String getCustomerId() {
        return customerId;
    }

    public void setCustomerId(String customerId) {
        this.customerId = customerId;
    }

    public String getAgentId() {
        return agentId;
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public String getStrategy() {
        return strategy;
    }

    public void setStrategy(String strategy) {
        this.strategy = strategy;
    }

    public Map<?, ?> getResourceMap() {
        return resourceMap;
    }

    public void setResourceMap(Map<?, ?> resourceMap) {
        this.resourceMap = resourceMap;
    }

    public Map<String, ServiceMap> getServiceMap() {
        return serviceMap;
    }

    public void setServiceMap(Map<String, ServiceMap> serviceMap) {
        this.serviceMap = serviceMap;
    }


    @Override
    public String toString() {
        return "RequestContextId{" +
                "dataCenter='" + dataCenter + '\'' +
                ", customerId='" + customerId + '\'' +
                ", agentId='" + agentId + '\'' +
                ", strategy='" + strategy + '\'' +
                ", resourceMap=" + resourceMap +
                ", serviceMap=" + serviceMap +
                '}';
    }
}
