/*
 * /////////////////////////////////////////////////////////////////////////////////
 * //
 * // Copyright <2015>-<2016> Avaya Inc. All Rights Reserved.
 * //
 * // Usage of this source is bound to the terms described
 * // in assets/Licence.txt
 * //
 * // Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 * // or Avaya Policy
 * //
 * /////////////////////////////////////////////////////////////////////////////
 */

package com.avaya.odonnell3.AndroidChatTemplate_2_3.UtilClasses;

import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import android.util.Log;

import com.avaya.odonnell3.AndroidChatTemplate_2_3.R;
import com.avaya.odonnell3.AndroidChatTemplate_2_3.activities.WaitMessageActivity;
import com.avaya.odonnell3.AndroidChatTemplate_2_3.model.ChatMessage;
import com.avaya.odonnell3.AndroidChatTemplate_2_3.classes.MessageParser;
import com.avaya.odonnell3.AndroidChatTemplate_2_3.model.CloseConversationRequest;
import com.avaya.odonnell3.AndroidChatTemplate_2_3.model.CustomerJsonWrapper;
import com.avaya.odonnell3.AndroidChatTemplate_2_3.model.OnHoldMessage;
import com.avaya.odonnell3.AndroidChatTemplate_2_3.model.OnHoldURLs;
import com.avaya.odonnell3.AndroidChatTemplate_2_3.model.WebOnHoldComfortGroup;
import com.avaya.odonnell3.AndroidChatTemplate_2_3.model.WebOnHoldURL;
import com.avaya.odonnell3.AndroidChatTemplate_2_3.services.Global;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class WaitActivityUtils extends Activity {

    private WaitMessageActivity activity;

    public WaitActivityUtils(WaitMessageActivity activity) {
        this.activity = activity;
    }

    //launch on-hold url in android browser
    public void showOnHoldInBrowser(String pagePush) {
        Uri uri = Uri.parse(pagePush);
        Intent intent = new Intent(Intent.ACTION_VIEW, uri);
        activity.startActivity(intent);
    }

    //build and send the Close-Chat messages
    public void sendCloseChatRequest() {
        Log.v("Info", activity.activityName + " sendCloseChatRequest");
        CustomerJsonWrapper wrapper = new CustomerJsonWrapper("request");
        CloseConversationRequest request = new CloseConversationRequest();
        wrapper.setBody(request);
        String message = MessageParser.javaObjectToJson(wrapper);
        Log.v("Info", "connection on close: " + activity.wsClient.getConnection());
        try {
            activity.wsClient.send(message);
        } catch (Exception e) {

        }
    }

    //get the on-hold URLs from the requestChatNotification
    public List<String> getOnHoldURLs() {
        List<WebOnHoldURL> urlGroups = Global.notification.getWebOnHoldURLs();
        List<String> mixedMessages = new ArrayList<>();
        for (WebOnHoldURL group : urlGroups) {
            for (OnHoldURLs urls : group.getUrls()) {
                mixedMessages.add(urls.getUrl());
            }
        }
        return mixedMessages;
    }

    //extract the on-hold messages from the requestChatNotification
    public List<String> getComfortMessages() {

        List<WebOnHoldComfortGroup> comfortGroups = Global.notification.getWebOnHoldComfortGroups();
        List<String> mixedMessages = new ArrayList<>();

        for (WebOnHoldComfortGroup group : comfortGroups) {

            for (OnHoldMessage message : group.getMessages()) {
                mixedMessages.add(message.getMessage());
            }
        }
        return mixedMessages;
    }

    //placeholder OnHold messages if no messages in RequestChatNotification
    public void getMockWaitMessages() {

        String[] messageList = activity.getResources().getStringArray(R.array.place_holder_on_hold_methods);

        List<ChatMessage> temp = new ArrayList<>();
        ChatMessage chatMessage1 = new ChatMessage("Auto", messageList[0], 2);
        temp.add(chatMessage1);
        ChatMessage chatMessage1_1 = new ChatMessage( messageList[1], 5);
        temp.add(chatMessage1_1);
        ChatMessage chatMessage2 = new ChatMessage("Auto", messageList[2], 2);
        temp.add(chatMessage2);
        ChatMessage chatMessage1_2 = new ChatMessage( messageList[3], 5);
        temp.add(chatMessage1_2);
        ChatMessage chatMessage3 = new ChatMessage("Auto",  messageList[4], 2);
        temp.add(chatMessage3);
        ChatMessage chatMessage1_3 = new ChatMessage( messageList[5], 5);
        temp.add(chatMessage1_3);
        ChatMessage chatMessage4 = new ChatMessage("Auto", messageList[6], 2);
        temp.add(chatMessage4);

        activity.chatMessageList.addAll(temp);

    }
//display the on-hold urls and messages to screen
    public void getWaitMessages() {
        Log.v("Info", "Global Notification: " + Global.notification.toString());
        WebOnHoldComfortGroup group = Global.notification.getWebOnHoldComfortGroups().get(0);
        List<String> blendedList = getBlendedMessages();

        if (blendedList.size() > 0) {
            activity.setDelay(group.getDelay());

            for (int i = 0; i < blendedList.size(); i++) {
                String message = blendedList.get(i);
                ChatMessage cm;

                if (isURL(message)) {
                    cm = new ChatMessage("Auto:", message, 5);
                } else {
                    cm = new ChatMessage(message, 2);
                }
                activity.chatMessageList.add(cm);
            }
        } else {
            getMockWaitMessages();
        }
    }

    //get a mixed list of on-hold urls and messages
    public List<String> getBlendedMessages() {

        List<String> comfortMessages = getComfortMessages();
        List<String> urlMessages = getOnHoldURLs();
        return mixArrayLists(comfortMessages, urlMessages);
    }

    //creates a mixed list of strings from two lists
    public List<String> mixArrayLists(List<String> list1, List<String> list2) {

        int list1Size = list1.size();
        int list2Size = list2.size();
        List<String> list3 = new ArrayList<>();
        int max = getMax(list1Size, list2Size);

        for (int i = 0; i < max; i++) {
            if (i < list1Size && i < list2Size) {

                list3.add(list1.get(i));
                list3.add(list2.get(i));

            } else if (i < list1Size) {

                list3.add(list1.get(i));
            } else {

                list3.add(list2.get(i));
            }
        }
        return list3;
    }

    public int getMax(int a, int b) {
        int max;

        if (a >= b) {
            max = a;
        } else {
            max = b;
        }
        return max;
    }

//determine if a string is a url using an exception
    public boolean isURL(String message) {

        try {
            URL url = new URL(message);
        } catch (MalformedURLException e) {
            return false;
        }
        return true;
    }

}