/*
 * /////////////////////////////////////////////////////////////////////////////////
 * //
 * // Copyright <2015>-<2016> Avaya Inc. All Rights Reserved.
 * //
 * // Usage of this source is bound to the terms described
 * // in assets/Licence.txt
 * //
 * // Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 * // or Avaya Policy
 * //
 * /////////////////////////////////////////////////////////////////////////////
 */

package com.avaya.odonnell3.AndroidChatTemplate_2_3.model;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.ArrayList;
import java.util.List;

public class Intrinsics {

    @JsonProperty("channelAttribute")
    private String channelAttribute;
    @JsonProperty("attributes")
    private List<String> attributes = new ArrayList<>();
    @JsonProperty("name")
    private String name;
    @JsonProperty("email")
    private String email;
    @JsonProperty("country")
    private String country;
    @JsonProperty("area")
    private String area;
    @JsonProperty("phoneNumber")
    private String phoneNumber;
    @JsonProperty("customFields")
    private List<CustomFields> customFields = new ArrayList<>();

    public Intrinsics(){

    }

    public Intrinsics(String email, String name, String channelAttribute,List<String> attributes, String country, String area, String phoneNumber, List<CustomFields> customFields) {
        this.email = email;
        this.name = name;
        this.channelAttribute = channelAttribute;
        this.attributes = attributes;
        this.country = country;
        this.area = area;
        this.phoneNumber = phoneNumber;
        this.customFields = customFields;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getChannelAttribute() {
        return channelAttribute;
    }

    public void setChannelAttribute(String channelAttribute) {
        this.channelAttribute = channelAttribute;
    }

    public void setAttributes(List<String> attributes) {
        this.attributes = attributes;
    }

    public String getCountry() {
        return country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }

    public String getPhoneNumber() {
        return phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public List<CustomFields> getCustomFields() {
        return customFields;
    }

    public void setCustomFields(List<CustomFields> customFields) {
        this.customFields = customFields;
    }

    @Override
    public String toString() {
        return "SkillSetIntrinsics{" +
                "email='" + email + '\'' +
                ", name='" + name + '\'' +
                ", channelAttribute='" + channelAttribute + '\'' +
                ", attributes=" + attributes +
                ", country='" + country + '\'' +
                ", area='" + area + '\'' +
                ", phoneNumber='" + phoneNumber + '\'' +
                ", customFields=" + customFields +
                '}';
    }
}
