/*
 * /////////////////////////////////////////////////////////////////////////////////
 * //
 * // Copyright <2015>-<2016> Avaya Inc. All Rights Reserved.
 * //
 * // Usage of this source is bound to the terms described
 * // in assets/Licence.txt
 * //
 * // Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 * // or Avaya Policy
 * //
 * /////////////////////////////////////////////////////////////////////////////
 */

package com.avaya.odonnell3.AndroidChatTemplate_2_3.model;

import java.util.Map;

import com.fasterxml.jackson.annotation.JsonProperty;

public class ServiceMap {

    @JsonProperty("attributes")
    private Map<String,String[]> attributes;
    @JsonProperty("priority")
    private int priority;
    @JsonProperty("rank")
    private String rank;
    @JsonProperty("resourceCount")
    private String resourceCount;

    public ServiceMap() {

    }

    public ServiceMap(Map<String, String[]> attributes, int priority) {
        super();
        this.attributes = attributes;
        this.priority = priority;
        this.rank = null;
        this.resourceCount = null;
    }


    public ServiceMap(Map<String, String[]> attributes) {
        super();
        this.attributes = attributes;
        this.priority = 5;
        this.rank = null;
        this.resourceCount = null;
    }

    public Map<String, String[]> getAttributes() {
        return attributes;
    }

    public void setAttributes(Map<String, String[]> attributes) {
        this.attributes = attributes;
    }

    public int getPriority() {
        return priority;
    }

    public void setPriority(int priority) {
        this.priority = priority;
    }

    public String getRank() {
        return rank;
    }

    public void setRank(String rank) {
        this.rank = rank;
    }

    public String getResourceCount() {
        return resourceCount;
    }

    public void setResourceCount(String resourceCount) {
        this.resourceCount = resourceCount;
    }


    @Override
    public String toString() {
        return "ServiceMap{" +
                "attributes=" + attributes +
                ", priority=" + priority +
                ", rank='" + rank + '\'' +
                ", resourceCount='" + resourceCount + '\'' +
                '}';
    }
}
