/*
 * /////////////////////////////////////////////////////////////////////////////////
 * //
 * // Copyright <2015>-<2016> Avaya Inc. All Rights Reserved.
 * //
 * // Usage of this source is bound to the terms described
 * // in assets/Licence.txt
 * //
 * // Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 * // or Avaya Policy
 * //
 * /////////////////////////////////////////////////////////////////////////////
 */

package com.avaya.odonnell3.AndroidChatTemplate_2_3.UtilClasses;

import android.app.Activity;
import android.content.Intent;
import android.support.design.widget.FloatingActionButton;
import android.support.design.widget.Snackbar;
import android.util.Log;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListView;

import com.avaya.odonnell3.AndroidChatTemplate_2_3.R;
import com.avaya.odonnell3.AndroidChatTemplate_2_3.activities.AboutActivity;
import com.avaya.odonnell3.AndroidChatTemplate_2_3.activities.CoverageActivity;
import com.avaya.odonnell3.AndroidChatTemplate_2_3.activities.MainActivity;
import com.avaya.odonnell3.AndroidChatTemplate_2_3.activities.MobilePlanActivity;
import com.avaya.odonnell3.AndroidChatTemplate_2_3.activities.PhonesActivity;
import com.avaya.odonnell3.AndroidChatTemplate_2_3.activities.StoreLocatorActivity;
import com.avaya.odonnell3.AndroidChatTemplate_2_3.adapters.ProductListAdapter;
import com.avaya.odonnell3.AndroidChatTemplate_2_3.model.ProductItems;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class MainActivityUtils extends Activity {

    private MainActivity activity;


    public MainActivityUtils(MainActivity activity) {
        this.activity = activity;
    }


    //handles display and clicking of home-screen items
    public void setHomeScreenItems() {
        Log.v("Info", activity.activityName + "setHomeScreenItems()");
        activity.homeList = (ListView) activity.findViewById(R.id.home_lv);
        activity.adapter = new ProductListAdapter(activity, R.layout.list_item_menu, populateMenuItems());
        activity.homeList.setAdapter(activity.adapter);
        activity.homeList.setOnItemClickListener(new AdapterView.OnItemClickListener() {
            @Override
            public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                Intent intent = null;
                switch (position) {
                    case 0:
                        intent = new Intent(activity, MobilePlanActivity.class);
                        break;
                    case 1:
                        intent = new Intent(activity, PhonesActivity.class);
                        break;
                    case 2:
                        intent = new Intent(activity, StoreLocatorActivity.class);
                        break;
                    case 3:
                        intent = new Intent(activity, CoverageActivity.class);
                        break;
                    case 4:
                        intent = new Intent(activity, AboutActivity.class);
                        break;
                    default:
                        break;
                }
                activity.startActivity(intent);
            }
        });
    }

    //menu items for the home-screen
    public ArrayList<ProductItems> populateMenuItems() {
        Log.v("Info", activity.activityName + "populateMenuItems()");
        activity.homeList.setFooterDividersEnabled(true);
        activity.homeList.setHeaderDividersEnabled(true);
        ArrayList<ProductItems> productList = new ArrayList<>();

        ProductItems item1 = new ProductItems();
        item1.setResourceId(R.drawable.smartphone_price_large);
        item1.setTitle(activity.getString(R.string.plan_label));
        item1.setKey(0);

        ProductItems item2 = new ProductItems();
        item2.setResourceId(R.drawable.smartphone_large);
        item2.setTitle(activity.getString(R.string.phone_label));
        item2.setKey(1);


        ProductItems item3 = new ProductItems();
        item3.setResourceId(R.drawable.location_large);
        item3.setTitle(activity.getString(R.string.store_locator_label));
        item3.setKey(2);

        ProductItems item4 = new ProductItems();
        item4.setResourceId(R.drawable.cell_tower_large);
        item4.setTitle(activity.getString(R.string.network_label));
        item4.setKey(3);

        ProductItems item5 = new ProductItems();
        item5.setResourceId(R.drawable.information_large);
        item5.setTitle(activity.getString(R.string.about_us_label));
        item5.setKey(4);

        productList.add(item1);
        productList.add(item2);
        productList.add(item3);
        productList.add(item4);
        productList.add(item5);

        return productList;

    }

    //gathers and prepare Attributes for Chat Request and EWT
    public void addAttributes(String input) {
        String temp = input.trim();
        Log.v("Info", temp);
//avoid adding duplicates to Request chat attributes
        Set<String> set = new HashSet<>();
        set.addAll(activity.attributesList);
        set.add(temp);
        activity.attributesList.clear();
        activity.attributesList.addAll(set);


        String[] splitter = temp.split(Pattern.quote("."));
        String category = splitter[0];
        String attribute = splitter[1];
//if the category is in the set, update the existing category
        if (activity.categorySet.contains(category)) {
            Log.v("Info", "Category exists: " + category);
            //add the attribute if it is not in the attribute-set
            if (!activity.attributeSet.contains(attribute)) {
                Log.v("Info", "adding attribute, " + attribute + " to existing category");
                activity.attributeSet.add(attribute);
                activity.attributesMap.get(category).add(attribute);
            }
        } else { //create a new category
            Log.v("Info", "New Category : " + category + " With attribute: " + attribute);
            activity.categorySet.add(category);
            //create new category
            List<String> tempList = new ArrayList<>();
            tempList.add(attribute);
            activity.attributesMap.put(category, tempList);
            activity.attributeSet.add(attribute);
        }
        activity.attributesMap.put("Channel", new ArrayList<String>(Arrays.asList("Chat")));
        activity.serviceMapWithPriority.setAttributes(activity.attributesMap);

    }

    //show and hide the request chat button
    public void setFabVisible(boolean visible) {
        //check for agent availability before displaying floating action button
        AnimationUtils.fadeInAgentButton(visible, activity.fab);
        if (activity.fab != null) {
            AgentChatFab(activity.fab);
        }
    }

    //the Floating Action Button to offer a Chat
    public void AgentChatFab(FloatingActionButton fab) {
        fab.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
//handling the pop-up request chat message.
                String prompt = "Would you like to Chat?";
                int ewt = activity.ewtTime;
                int maxWaitTime = 6000;
                Snackbar snackbar = null;
                Log.v("Info", "EWT: " + ewt);
                if (ewt > 0 && ewt <= maxWaitTime) {
                    //gets "minute" for 1 or "minutes" for many
                 //  String plurals = activity.getResources().getQuantityString(R.plurals.ewt_prompt, ewt);
                    prompt = "An Agent will be available in " + ewt / 60+ "mins\n" + prompt;
                    snackbar = Snackbar.make(view, prompt, Snackbar.LENGTH_LONG).setActionTextColor(activity.getResources().getColor(R.color.colorAccent))
                            .setAction(activity.getString(R.string.ok), new View.OnClickListener() {

                                @Override
                                public void onClick(View v) {
                                    activity.dialogUtils.requestChatDialog();
                                }
                            });
                } else if (ewt < 0 || ewt > maxWaitTime) {
                    prompt = "There are currently no available agents\nPlease try again later";
                    snackbar = Snackbar.make(view, prompt, Snackbar.LENGTH_LONG).setActionTextColor(activity.getResources().getColor(R.color.colorAccent))
                            .setAction(activity.getString(R.string.ok), new View.OnClickListener() {

                                @Override
                                public void onClick(View v) {
                                    setFabVisible(false);
                                }
                            });
                } else {
                    snackbar = Snackbar.make(view, prompt, Snackbar.LENGTH_LONG).setActionTextColor(activity.getResources().getColor(R.color.colorAccent))
                            .setAction(activity.getString(R.string.ok), new View.OnClickListener() {

                                @Override
                                public void onClick(View v) {
                                    activity.dialogUtils.requestChatDialog();
                                }
                            });
                }

                snackbar.show();
            }
        });
    }

}
