/*
 * /////////////////////////////////////////////////////////////////////////////////
 * //
 * // Copyright <2015>-<2016> Avaya Inc. All Rights Reserved.
 * //
 * // Usage of this source is bound to the terms described
 * // in assets/Licence.txt
 * //
 * // Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 * // or Avaya Policy
 * //
 * /////////////////////////////////////////////////////////////////////////////
 */

package com.avaya.odonnell3.AndroidChatTemplate_2_3.adapters;

import android.content.Context;
import android.text.Html;
import android.text.util.Linkify;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.TextView;

import com.avaya.odonnell3.AndroidChatTemplate_2_3.R;
import com.avaya.odonnell3.AndroidChatTemplate_2_3.model.ChatMessage;

import java.util.List;

public class MessageListAdapter extends ArrayAdapter<ChatMessage> {

    public final String className = this.getClass().getSimpleName();
    private List<ChatMessage> messages;


    public MessageListAdapter(Context context, int resource, List<ChatMessage> objects) {
        super(context, resource, objects);
        messages = objects;
    }


    @Override
    public View getView(int position, View convertView, ViewGroup parent) {
        Log.v("Info", className + " getView()");
        ChatMessage chatMessage = messages.get(position);
        int layout = R.layout.list_item_agent;

        int name = 0;
        int time = 0;
        int message = 0;


        return setMessageLayoutType(parent, chatMessage, layout, name, time, message);
    }

//determine message layouts
    private View setMessageLayoutType(ViewGroup parent, ChatMessage chatMessage, int layout, int name, int time, int message) {
        Log.v("Info", className + " setMessageLayoutType()");
        Log.v("Info",chatMessage.getMessage());
        View convertView;
        switch (chatMessage.getSenderType()) {

            case 0: //customer messages
                layout = R.layout.list_item_customer;
                name = R.id.customer_label_tv;
                time = R.id.customer_time_tv;
                message = R.id.customer_output_tv;
                break;
            case 1: //agent 1 messages
                layout = R.layout.list_item_agent;
                name = R.id.agent_label_tv;
                time = R.id.agent_time_tv;
                message = R.id.agent_output_tv;
                break;
            case 2: // wait messages
                layout = R.layout.list_item_wait;
                name = R.id.wait_label_tv;
                time = R.id.wait_time_tv;
                message = R.id.wait_output_tv;
                break;
            case 3: //page-push messages
                layout = R.layout.list_item_page_push;
                name = R.id.agent_pp_label_tv;
                time = R.id.agent_pp_time_tv;
                message = R.id.agent_pp_output_tv;
                break;
            case 4:
                layout = R.layout.header;
                message = R.id.header_tv;
                break;
            case 5:
                layout = R.layout.list_item_on_hold_url;
                name = 0;
                time = R.id.hold_time_tv;
                message = R.id.hold_output_tv;
                break;
            default:
                Log.e("Error", "Not a recognised agent message type:\n" + chatMessage.toString());
                break;
        }

        convertView = LayoutInflater.from(getContext()).inflate(layout, parent, false);


        TextView labelTv = (TextView) convertView.findViewById(name);

        if (chatMessage.getName() != null && name != 0) {
            Log.v("*",chatMessage.getName());
            labelTv.setText(chatMessage.getName());
        }
        String messageText =  chatMessage.getMessage();
        TextView messageTv = (TextView) convertView.findViewById(message);
        if(messageText.contains("http")) {
            messageTv.setAutoLinkMask(Linkify.ALL);
            messageTv.setText("Url: " + messageText);
        } else {
            messageTv.setText(messageText);
        }
        TextView timeTv = (TextView) convertView.findViewById(time);
        if (chatMessage.getTime() != null)
            timeTv.setText(chatMessage.getTime());


        return convertView;
    }

}
