/*
 * /////////////////////////////////////////////////////////////////////////////////
 * //
 * // Copyright <2015>-<2016> Avaya Inc. All Rights Reserved.
 * //
 * // Usage of this source is bound to the terms described
 * // in assets/Licence.txt
 * //
 * // Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 * // or Avaya Policy
 * //
 * /////////////////////////////////////////////////////////////////////////////
 */

package com.avaya.odonnell3.AndroidChatTemplate_2_3.adapters;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.ImageView;
import android.widget.TextView;

import com.avaya.odonnell3.AndroidChatTemplate_2_3.R;
import com.avaya.odonnell3.AndroidChatTemplate_2_3.model.ProductItems;

import java.util.ArrayList;
import java.util.List;

public class ProductListAdapter extends ArrayAdapter<ProductItems> {

    List<ProductItems> items;

    public ProductListAdapter(Context context, int resource, ArrayList<ProductItems> objects) {
        super(context, resource, objects);

        items = objects;
    }

    @Override
    public View getView(int position, View convertView, ViewGroup parent) {

        if (convertView == null) {
            convertView = LayoutInflater.from(getContext()).inflate(R.layout.list_item_menu, parent, false);
        }
        setItems(position, convertView);
        return convertView;
    }

    private void setItems(int position, View convertView) {

        ProductItems product = items.get(position);
        TextView label = (TextView) convertView.findViewById(R.id.menu_tv);
        label.setText(product.getTitle());
        ImageView iv = (ImageView) convertView.findViewById(R.id.menu_iv);
        iv.setImageResource(product.getResourceId());
    }
}
