/*
 * /////////////////////////////////////////////////////////////////////////////////
 * //
 * // Copyright <2015>-<2016> Avaya Inc. All Rights Reserved.
 * //
 * // Usage of this source is bound to the terms described
 * // in assets/Licence.txt
 * //
 * // Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 * // or Avaya Policy
 * //
 * /////////////////////////////////////////////////////////////////////////////
 */

package com.avaya.odonnell3.AndroidChatTemplate_2_3.classes;

import android.util.Log;

import java.util.HashMap;
import java.util.Map;

public class PhoneInformation {

    public PhoneInformation() {
        setMap();
    }

    private static Map<String, String> countyrCodeMap = new HashMap<>();

    public String getInternationalDialCode(String country) {

        // default to English country code
        String code = "+44";

        if (countyrCodeMap.containsKey(country.toUpperCase())) {
            code = countyrCodeMap.get(country.toUpperCase());
        } else {
            Log.e("ERROR", " Not a country code: " + country);
        }

        return code;
    }

    public void setMap() {
        countyrCodeMap.put("AC", "+247");
        countyrCodeMap.put("AD", "+376");
        countyrCodeMap.put("AE", "+971");
        countyrCodeMap.put("AF", "+93");
        countyrCodeMap.put("AG", "+1-268");
        countyrCodeMap.put("AI", "+1-264");
        countyrCodeMap.put("AL", "+355");
        countyrCodeMap.put("AM", "+374");
        countyrCodeMap.put("AN", "+599");
        countyrCodeMap.put("AO", "+244");
        countyrCodeMap.put("AR", "+54");
        countyrCodeMap.put("AS", "+1-684");
        countyrCodeMap.put("AT", "+43");
        countyrCodeMap.put("AU", "+61");
        countyrCodeMap.put("AW", "+297");
        countyrCodeMap.put("AX", "+358-18");
        countyrCodeMap.put("AZ", "+374-97");
        countyrCodeMap.put("AZ", "+994");
        countyrCodeMap.put("BA", "+387");
        countyrCodeMap.put("BB", "+1-246");
        countyrCodeMap.put("BD", "+880");
        countyrCodeMap.put("BE", "+32");
        countyrCodeMap.put("BF", "+226");
        countyrCodeMap.put("BG", "+359");
        countyrCodeMap.put("BH", "+973");
        countyrCodeMap.put("BI", "+257");
        countyrCodeMap.put("BJ", "+229");
        countyrCodeMap.put("BM", "+1-441");
        countyrCodeMap.put("BN", "+673");
        countyrCodeMap.put("BO", "+591");
        countyrCodeMap.put("BR", "+55");
        countyrCodeMap.put("BS", "+1-242");
        countyrCodeMap.put("BT", "+975");
        countyrCodeMap.put("BW", "+267");
        countyrCodeMap.put("BY", "+375");
        countyrCodeMap.put("BZ", "+501");
        countyrCodeMap.put("CA", "+1");
        countyrCodeMap.put("CC", "+61");
        countyrCodeMap.put("CD", "+243");
        countyrCodeMap.put("CF", "+236");
        countyrCodeMap.put("CG", "+242");
        countyrCodeMap.put("CH", "+41");
        countyrCodeMap.put("CI", "+225");
        countyrCodeMap.put("CK", "+682");
        countyrCodeMap.put("CL", "+56");
        countyrCodeMap.put("CM", "+237");
        countyrCodeMap.put("CN", "+86");
        countyrCodeMap.put("CO", "+57");
        countyrCodeMap.put("CR", "+506");
        countyrCodeMap.put("CS", "+381");
        countyrCodeMap.put("CU", "+53");
        countyrCodeMap.put("CV", "+238");
        countyrCodeMap.put("CX", "+61");
        countyrCodeMap.put("CY", "+90-392");
        countyrCodeMap.put("CY", "+357");
        countyrCodeMap.put("CZ", "+420");
        countyrCodeMap.put("DE", "+49");
        countyrCodeMap.put("DJ", "+253");
        countyrCodeMap.put("DK", "+45");
        countyrCodeMap.put("DM", "+1-767");
        countyrCodeMap.put("DO", "+1-809"); // and 1-829?
        countyrCodeMap.put("DZ", "+213");
        countyrCodeMap.put("EC", "+593");
        countyrCodeMap.put("EE", "+372");
        countyrCodeMap.put("EG", "+20");
        countyrCodeMap.put("EH", "+212");
        countyrCodeMap.put("ER", "+291");
        countyrCodeMap.put("ES", "+34");
        countyrCodeMap.put("ET", "+251");
        countyrCodeMap.put("FI", "+358");
        countyrCodeMap.put("FJ", "+679");
        countyrCodeMap.put("FK", "+500");
        countyrCodeMap.put("FM", "+691");
        countyrCodeMap.put("FO", "+298");
        countyrCodeMap.put("FR", "+33");
        countyrCodeMap.put("GA", "+241");
        countyrCodeMap.put("GB", "+44");
        countyrCodeMap.put("GD", "+1-473");
        countyrCodeMap.put("GE", "+995");
        countyrCodeMap.put("GF", "+594");
        countyrCodeMap.put("GG", "+44");
        countyrCodeMap.put("GH", "+233");
        countyrCodeMap.put("GI", "+350");
        countyrCodeMap.put("GL", "+299");
        countyrCodeMap.put("GM", "+220");
        countyrCodeMap.put("GN", "+224");
        countyrCodeMap.put("GP", "+590");
        countyrCodeMap.put("GQ", "+240");
        countyrCodeMap.put("GR", "+30");
        countyrCodeMap.put("GT", "+502");
        countyrCodeMap.put("GU", "+1-671");
        countyrCodeMap.put("GW", "+245");
        countyrCodeMap.put("GY", "+592");
        countyrCodeMap.put("HK", "+852");
        countyrCodeMap.put("HN", "+504");
        countyrCodeMap.put("HR", "+385");
        countyrCodeMap.put("HT", "+509");
        countyrCodeMap.put("HU", "+36");
        countyrCodeMap.put("ID", "+62");
        countyrCodeMap.put("IE", "+353");
        countyrCodeMap.put("IL", "+972");
        countyrCodeMap.put("IM", "+44");
        countyrCodeMap.put("IN", "+91");
        countyrCodeMap.put("IO", "+246");
        countyrCodeMap.put("IQ", "+964");
        countyrCodeMap.put("IR", "+98");
        countyrCodeMap.put("IS", "+354");
        countyrCodeMap.put("IT", "+39");
        countyrCodeMap.put("JE", "+44");
        countyrCodeMap.put("JM", "+1-876");
        countyrCodeMap.put("JO", "+962");
        countyrCodeMap.put("JP", "+81");
        countyrCodeMap.put("KE", "+254");
        countyrCodeMap.put("KG", "+996");
        countyrCodeMap.put("KH", "+855");
        countyrCodeMap.put("KI", "+686");
        countyrCodeMap.put("KM", "+269");
        countyrCodeMap.put("KN", "+1-869");
        countyrCodeMap.put("KP", "+850");
        countyrCodeMap.put("KR", "+82");
        countyrCodeMap.put("KW", "+965");
        countyrCodeMap.put("KY", "+1-345");
        countyrCodeMap.put("KZ", "+7");
        countyrCodeMap.put("LA", "+856");
        countyrCodeMap.put("LB", "+961");
        countyrCodeMap.put("LC", "+1-758");
        countyrCodeMap.put("LI", "+423");
        countyrCodeMap.put("LK", "+94");
        countyrCodeMap.put("LR", "+231");
        countyrCodeMap.put("LS", "+266");
        countyrCodeMap.put("LT", "+370");
        countyrCodeMap.put("LU", "+352");
        countyrCodeMap.put("LV", "+371");
        countyrCodeMap.put("LY", "+218");
        countyrCodeMap.put("MA", "+212");
        countyrCodeMap.put("MC", "+377");
        countyrCodeMap.put("MD", "+373-533");
        countyrCodeMap.put("MD", "+373");
        countyrCodeMap.put("ME", "+382");
        countyrCodeMap.put("MG", "+261");
        countyrCodeMap.put("MH", "+692");
        countyrCodeMap.put("MK", "+389");
        countyrCodeMap.put("ML", "+223");
        countyrCodeMap.put("MM", "+95");
        countyrCodeMap.put("MN", "+976");
        countyrCodeMap.put("MO", "+853");
        countyrCodeMap.put("MP", "+1-670");
        countyrCodeMap.put("MQ", "+596");
        countyrCodeMap.put("MR", "+222");
        countyrCodeMap.put("MS", "+1-664");
        countyrCodeMap.put("MT", "+356");
        countyrCodeMap.put("MU", "+230");
        countyrCodeMap.put("MV", "+960");
        countyrCodeMap.put("MW", "+265");
        countyrCodeMap.put("MX", "+52");
        countyrCodeMap.put("MY", "+60");
        countyrCodeMap.put("MZ", "+258");
        countyrCodeMap.put("NA", "+264");
        countyrCodeMap.put("NC", "+687");
        countyrCodeMap.put("NE", "+227");
        countyrCodeMap.put("NF", "+672");
        countyrCodeMap.put("NG", "+234");
        countyrCodeMap.put("NI", "+505");
        countyrCodeMap.put("NL", "+31");
        countyrCodeMap.put("NO", "+47");
        countyrCodeMap.put("NP", "+977");
        countyrCodeMap.put("NR", "+674");
        countyrCodeMap.put("NU", "+683");
        countyrCodeMap.put("NZ", "+64");
        countyrCodeMap.put("OM", "+968");
        countyrCodeMap.put("PA", "+507");
        countyrCodeMap.put("PE", "+51");
        countyrCodeMap.put("PF", "+689");
        countyrCodeMap.put("PG", "+675");
        countyrCodeMap.put("PH", "+63");
        countyrCodeMap.put("PK", "+92");
        countyrCodeMap.put("PL", "+48");
        countyrCodeMap.put("PM", "+508");
        countyrCodeMap.put("PR", "+1-787"); // and 1-939 ?
        countyrCodeMap.put("PS", "+970");
        countyrCodeMap.put("PT", "+351");
        countyrCodeMap.put("PW", "+680");
        countyrCodeMap.put("PY", "+595");
        countyrCodeMap.put("QA", "+974");
        countyrCodeMap.put("RE", "+262");
        countyrCodeMap.put("RO", "+40");
        countyrCodeMap.put("RS", "+381");
        countyrCodeMap.put("RU", "+7");
        countyrCodeMap.put("RW", "+250");
        countyrCodeMap.put("SA", "+966");
        countyrCodeMap.put("SB", "+677");
        countyrCodeMap.put("SC", "+248");
        countyrCodeMap.put("SD", "+249");
        countyrCodeMap.put("SE", "+46");
        countyrCodeMap.put("SG", "+65");
        countyrCodeMap.put("SH", "+290");
        countyrCodeMap.put("SI", "+386");
        countyrCodeMap.put("SJ", "+47");
        countyrCodeMap.put("SK", "+421");
        countyrCodeMap.put("SL", "+232");
        countyrCodeMap.put("SM", "+378");
        countyrCodeMap.put("SN", "+221");
        countyrCodeMap.put("SO", "+252");
        countyrCodeMap.put("SO", "+252");
        countyrCodeMap.put("SR", "+597");
        countyrCodeMap.put("ST", "+239");
        countyrCodeMap.put("SV", "+503");
        countyrCodeMap.put("SY", "+963");
        countyrCodeMap.put("SZ", "+268");
        countyrCodeMap.put("TA", "+290");
        countyrCodeMap.put("TC", "+1-649");
        countyrCodeMap.put("TD", "+235");
        countyrCodeMap.put("TG", "+228");
        countyrCodeMap.put("TH", "+66");
        countyrCodeMap.put("TJ", "+992");
        countyrCodeMap.put("TK", "+690");
        countyrCodeMap.put("TL", "+670");
        countyrCodeMap.put("TM", "+993");
        countyrCodeMap.put("TN", "+216");
        countyrCodeMap.put("TO", "+676");
        countyrCodeMap.put("TR", "+90");
        countyrCodeMap.put("TT", "+1-868");
        countyrCodeMap.put("TV", "+688");
        countyrCodeMap.put("TW", "+886");
        countyrCodeMap.put("TZ", "+255");
        countyrCodeMap.put("UA", "+380");
        countyrCodeMap.put("UG", "+256");
        countyrCodeMap.put("US", "+1");
        countyrCodeMap.put("UY", "+598");
        countyrCodeMap.put("UZ", "+998");
        countyrCodeMap.put("VA", "+379");
        countyrCodeMap.put("VC", "+1-784");
        countyrCodeMap.put("VE", "+58");
        countyrCodeMap.put("VG", "+1-284");
        countyrCodeMap.put("VI", "+1-340");
        countyrCodeMap.put("VN", "+84");
        countyrCodeMap.put("VU", "+678");
        countyrCodeMap.put("WF", "+681");
        countyrCodeMap.put("WS", "+685");
        countyrCodeMap.put("YE", "+967");
        countyrCodeMap.put("YT", "+262");
        countyrCodeMap.put("ZA", "+27");
        countyrCodeMap.put("ZM", "+260");
        countyrCodeMap.put("ZW", "+263");
    }
}
