/*
 * /////////////////////////////////////////////////////////////////////////////////
 * //
 * // Copyright <2015>-<2016> Avaya Inc. All Rights Reserved.
 * //
 * // Usage of this source is bound to the terms described
 * // in assets/Licence.txt
 * //
 * // Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 * // or Avaya Policy
 * //
 * /////////////////////////////////////////////////////////////////////////////
 */

package com.avaya.odonnell3.AndroidChatTemplate_2_3.model;

import com.fasterxml.jackson.annotation.JsonProperty;

public class CustomerJsonWrapper {
    @JsonProperty("apiVersion")
    private String apiVersion = "1.0";
    @JsonProperty("type")
    private String type;
    @JsonProperty("body")
    private Object body;
    @JsonProperty("authToken")
    private String authToken = "";



    public CustomerJsonWrapper(){

    }

    public CustomerJsonWrapper(String apiVersion, String type, Object body, String authToken) {
        this.apiVersion = apiVersion;
        this.type = type;
        this.body = body;
        this.authToken = authToken;
    }


    public CustomerJsonWrapper(String type){
        this.type = type;
    }

    public String getApiVersion() {
        return apiVersion;
    }

    public void setApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Object getBody() {
        return body;
    }

    public void setBody(Object body) {
        this.body = body;
    }

    public String getAuthToken() {
        return authToken;
    }

    public void setAuthToken(String authToken) {
        this.authToken = authToken;
    }

    @Override
    public String toString() {
        return "CustomerJsonWrapper{" +
                "apiVersion='" + apiVersion + '\'' +
                ", type='" + type + '\'' +
                ", body=" + body +
                ", authToken='" + authToken + '\'' +
                '}';
    }
}
