/*
 * /////////////////////////////////////////////////////////////////////////////////
 * //
 * // Copyright <2015>-<2016> Avaya Inc. All Rights Reserved.
 * //
 * // Usage of this source is bound to the terms described
 * // in assets/Licence.txt
 * //
 * // Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 * // or Avaya Policy
 * //
 * /////////////////////////////////////////////////////////////////////////////
 */

package com.avaya.odonnell3.AndroidChatTemplate_2_3.model;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.ArrayList;
import java.util.List;

public class RequestChatNotification {

    @JsonProperty("guid")
    private Integer guid;
    @JsonProperty("authenticationKey")
    private String authenticationKey;
    @JsonProperty("workRequestId")
    private String workRequestId;
    @JsonProperty("intrinsics")
    private NotificationIntrinsics intrinsics;
    @JsonProperty("method")
    private String method;
    @JsonProperty("webOnHoldComfortGroups")
    private List<WebOnHoldComfortGroup> webOnHoldComfortGroups = new ArrayList<>();
    @JsonProperty("webOnHoldURLs")
    private List<WebOnHoldURL> webOnHoldURLs = new ArrayList<>();
    @JsonProperty("isEmailValid")
    private boolean isEmailValid;

    public RequestChatNotification(){
        
    }

    public RequestChatNotification(Integer guid, String authenticationKey, String workRequestId, NotificationIntrinsics intrinsics, String method, boolean isEmailValid) {
        this.guid = guid;
        this.authenticationKey = authenticationKey;
        this.workRequestId = workRequestId;
        this.intrinsics = intrinsics;
        this.method = method;
        this.isEmailValid = isEmailValid;
    }

    public Integer getGuid() {
        return guid;
    }

    public void setGuid(Integer guid) {
        this.guid = guid;
    }

    public String getAuthenticationKey() {
        return authenticationKey;
    }

    public void setAuthenticationKey(String authenticationKey) {
        this.authenticationKey = authenticationKey;
    }

    public String getWorkRequestId() {
        return workRequestId;
    }

    public void setWorkRequestId(String workRequestId) {
        this.workRequestId = workRequestId;
    }

    public NotificationIntrinsics getIntrinsics() {
        return intrinsics;
    }

    public void setIntrinsics(NotificationIntrinsics intrinsics) {
        this.intrinsics = intrinsics;
    }

    public String getMethod() {
        return method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public List<WebOnHoldComfortGroup> getWebOnHoldComfortGroups() {
        return webOnHoldComfortGroups;
    }

    public void setWebOnHoldComfortGroups(List<WebOnHoldComfortGroup> webOnHoldComfortGroups) {
        this.webOnHoldComfortGroups = webOnHoldComfortGroups;
    }

    public List<WebOnHoldURL> getWebOnHoldURLs() {
        return webOnHoldURLs;
    }

    public void setWebOnHoldURLs(List<WebOnHoldURL> webOnHoldURLs) {
        this.webOnHoldURLs = webOnHoldURLs;
    }

    public boolean isEmailValid() {
        return isEmailValid;
    }

    public void setEmailValid(boolean emailValid) {
        isEmailValid = emailValid;
    }

    @Override
    public String toString() {
        return "RequestChatNotification{" +
                "guid=" + guid +
                ", authenticationKey='" + authenticationKey + '\'' +
                ", workRequestId='" + workRequestId + '\'' +
                ", intrinsics=" + intrinsics +
                ", method='" + method + '\'' +
                ", webOnHoldComfortGroups=" + webOnHoldComfortGroups +
                ", webOnHoldURLs=" + webOnHoldURLs +
                ", isEmailValid=" + isEmailValid +
                '}';
    }
}
