/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ui.builder;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.text.TextUtils;
import com.avaya.core.Coordinates;
import com.avaya.core.Message;
import com.avaya.core.MessageAction;
import com.avaya.core.MessageItem;
import com.avaya.core.MessageType;
import com.avaya.ui.R;
import com.avaya.ui.widget.MessageView;
import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class MessageViewModel {
    private ViewType viewType;
    private ViewStyle viewStyle;
    private ViewStatus viewStatus;
    private ImageStyle imageStyle;
    private File file;
    private Bitmap image;
    private long mediaSize;
    private String fileUrl;
    private String mainText;
    private String imageUrl;
    private String avatarUrl;
    private String messageId;
    private String subText;
    private String mapsApiKey;
    private Coordinates coordinates;
    private List<MessageItem> messageItems;
    private List<MessageAction> messageActions;
    private Map<MessageView.ViewCorner, Boolean> messageRoundedCorners;
    private boolean isRemote;
    private boolean isFirstInList;
    private boolean isLastInList;
    private boolean shouldShowAvatar;

    public MessageViewModel(Message message, Resources resources, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, String object, String string2) {
        HashMap hashMap;
        LinkedList<MessageAction> linkedList;
        Cloneable cloneable = linkedList;
        linkedList = new LinkedList<MessageAction>();
        this.messageActions = cloneable;
        cloneable = hashMap;
        hashMap = new HashMap();
        this.messageRoundedCorners = cloneable;
        boolean bl7 = true;
        this.isRemote = bl;
        this.avatarUrl = object;
        this.isLastInList = bl3;
        this.isFirstInList = bl2;
        this.shouldShowAvatar = bl4;
        this.mapsApiKey = string2;
        if (message != null) {
            bl = MessageType.FILE.getValue().equals(message.getType());
            bl2 = MessageType.IMAGE.getValue().equals(message.getType());
            bl3 = MessageType.LOCATION.getValue().equals(message.getType());
            bl4 = message.isCarousel();
            object = MessageType.values();
            int n2 = ((MessageType[])object).length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!object[i2].getValue().equals(message.getType())) continue;
                bl7 = false;
                break;
            }
            MessageViewModel messageViewModel = this;
            messageViewModel.messageId = message.getId();
            messageViewModel.viewType = ViewType.COMPOUND;
            messageViewModel.viewStyle = ViewStyle.MESSAGE;
            object = message.getDisplaySettings().getImageAspectRatio().equals("square") ? ImageStyle.SQUARE : ImageStyle.HORIZONTAL;
            this.imageStyle = object;
            if (bl3 && !TextUtils.isEmpty((CharSequence)string2)) {
                this.viewType = ViewType.LOCATION;
            } else if (bl4) {
                this.viewType = ViewType.CAROUSEL;
            }
            if (message.getText() != null && !message.getText().trim().isEmpty() || bl3 && bl5 || bl7) {
                this.mainText = message.getText();
                if (bl3 && bl5) {
                    this.mainText = resources.getString(R.string.AvMessagingSdk_locationSendingFailed);
                } else if (bl7) {
                    this.mainText = message.getTextFallback() != null && !message.getTextFallback().trim().isEmpty() ? message.getTextFallback().trim() : resources.getString(R.string.AvMessagingSdk_unsupportedMessageType);
                }
            }
            if (message.getMessageActions() != null && !message.hasReplies() && !message.hasLocationRequest()) {
                this.messageActions = message.getMessageActions();
            }
            if (bl2) {
                this.image = message.getImage();
                this.imageUrl = message.getMediaUrl();
                this.mediaSize = message.getMediaSize();
            }
            if (bl) {
                this.file = message.getFile();
                this.fileUrl = message.getMediaUrl();
                this.mediaSize = message.getMediaSize();
            }
            if (bl3 && message.hasValidCoordinates()) {
                this.coordinates = message.getCoordinates();
            }
            this.messageItems = message.getMessageItems();
            this.viewStatus = bl6 ? ViewStatus.SENDING : (bl5 ? ViewStatus.FAILED : ViewStatus.SENT);
        } else {
            this.viewType = ViewType.TYPING_INDICATOR;
        }
        this.setMessageCorners();
    }

    MessageViewModel(MessageItem messageItem, ImageStyle imageStyle) {
        this(messageItem, null, imageStyle, false, false);
    }

    public MessageViewModel(MessageItem messageItem, String string2, ImageStyle imageStyle, boolean bl, boolean bl2) {
        MessageViewModel messageViewModel = this;
        this.messageActions = new LinkedList<MessageAction>();
        this.messageRoundedCorners = new HashMap<MessageView.ViewCorner, Boolean>();
        this.isRemote = true;
        this.messageId = string2;
        this.imageStyle = imageStyle;
        this.isFirstInList = bl;
        messageViewModel.isLastInList = bl2;
        messageViewModel.viewStyle = ViewStyle.ITEM;
        messageViewModel.viewType = ViewType.COMPOUND;
        messageViewModel.viewStatus = ViewStatus.SENT;
        this.mainText = messageItem.getTitle();
        this.imageUrl = messageItem.getMediaUrl();
        this.subText = messageItem.getDescription();
        this.messageActions = messageItem.getMessageActions();
        this.setMessageCorners();
    }

    private void setMessageCorners() {
        Object object;
        Object object2 = ((MessageViewModel)object).viewStyle;
        Enum enum_ = ViewStyle.ITEM;
        if (object2 == enum_ && !((MessageViewModel)object).isFirstInList && !((MessageViewModel)object).isLastInList) {
            MessageViewModel messageViewModel = object;
            object = Boolean.FALSE;
            messageViewModel.messageRoundedCorners.put(MessageView.ViewCorner.TOP_LEFT, (Boolean)object);
            messageViewModel.messageRoundedCorners.put(MessageView.ViewCorner.TOP_RIGHT, (Boolean)object);
            messageViewModel.messageRoundedCorners.put(MessageView.ViewCorner.BOTTOM_LEFT, (Boolean)object);
            messageViewModel.messageRoundedCorners.put(MessageView.ViewCorner.BOTTOM_RIGHT, (Boolean)object);
        } else if (object2 == enum_) {
            MessageViewModel messageViewModel = object;
            messageViewModel.messageRoundedCorners.put(MessageView.ViewCorner.TOP_LEFT, ((MessageViewModel)object).isFirstInList);
            messageViewModel.messageRoundedCorners.put(MessageView.ViewCorner.TOP_RIGHT, ((MessageViewModel)object).isLastInList);
            messageViewModel.messageRoundedCorners.put(MessageView.ViewCorner.BOTTOM_LEFT, ((MessageViewModel)object).isFirstInList);
            messageViewModel.messageRoundedCorners.put(MessageView.ViewCorner.BOTTOM_RIGHT, ((MessageViewModel)object).isLastInList);
        } else {
            MessageViewModel messageViewModel = object;
            object2 = messageViewModel.messageRoundedCorners;
            enum_ = MessageView.ViewCorner.TOP_LEFT;
            Boolean bl = !messageViewModel.isRemote || ((MessageViewModel)object).isFirstInList;
            Object object3 = object;
            object2.put(enum_, bl);
            object2 = ((MessageViewModel)object3).messageRoundedCorners;
            enum_ = MessageView.ViewCorner.TOP_RIGHT;
            bl = ((MessageViewModel)object3).isRemote || ((MessageViewModel)object).isFirstInList;
            Object object4 = object;
            object2.put(enum_, bl);
            object2 = ((MessageViewModel)object4).messageRoundedCorners;
            enum_ = MessageView.ViewCorner.BOTTOM_LEFT;
            bl = !((MessageViewModel)object4).isRemote || ((MessageViewModel)object).isLastInList;
            Object object5 = object;
            object2.put(enum_, bl);
            object2 = ((MessageViewModel)object5).messageRoundedCorners;
            enum_ = MessageView.ViewCorner.BOTTOM_RIGHT;
            object = ((MessageViewModel)object5).isRemote || ((MessageViewModel)object).isLastInList;
            object2.put(enum_, object);
        }
    }

    ViewType getViewType() {
        return this.viewType;
    }

    ViewStatus getViewStatus() {
        return this.viewStatus;
    }

    ViewStyle getViewStyle() {
        return this.viewStyle;
    }

    ImageStyle getImageStyle() {
        return this.imageStyle;
    }

    String getMainText() {
        return this.mainText;
    }

    String getSubText() {
        return this.subText;
    }

    List<MessageItem> getMessageItems() {
        return this.messageItems;
    }

    List<MessageAction> getMessageActions() {
        return this.messageActions;
    }

    String getImageUrl() {
        return this.imageUrl;
    }

    String getFileUrl() {
        return this.fileUrl;
    }

    public long getMediaSize() {
        return this.mediaSize;
    }

    Coordinates getCoordinates() {
        return this.coordinates;
    }

    Bitmap getImage() {
        return this.image;
    }

    File getFile() {
        return this.file;
    }

    String getMessageId() {
        return this.messageId;
    }

    String getAvatarUrl() {
        return this.avatarUrl;
    }

    void setImage(Bitmap bitmap) {
        this.image = bitmap;
    }

    boolean hasImage() {
        return this.image != null || this.imageUrl != null;
    }

    boolean hasFile() {
        return this.file != null || this.fileUrl != null;
    }

    boolean hasCoordinates() {
        return this.coordinates != null;
    }

    boolean hasMainText() {
        String string2 = ((MessageViewModel)((Object)string2)).mainText;
        return string2 != null && !string2.trim().isEmpty();
    }

    boolean hasSubText() {
        String string2 = ((MessageViewModel)((Object)string2)).subText;
        return string2 != null && !string2.trim().isEmpty();
    }

    boolean isRemote() {
        return this.isRemote;
    }

    public boolean shouldShowAvatar() {
        return this.shouldShowAvatar;
    }

    public String getMapsApiKey() {
        return this.mapsApiKey;
    }

    Map<MessageView.ViewCorner, Boolean> getMessageRoundedCorners() {
        return this.messageRoundedCorners;
    }

    public static final class ViewStatus
    extends Enum<ViewStatus> {
        public static final /* enum */ ViewStatus SENT;
        public static final /* enum */ ViewStatus SENDING;
        public static final /* enum */ ViewStatus FAILED;
        private static final /* synthetic */ ViewStatus[] $VALUES;

        public static ViewStatus[] values() {
            return (ViewStatus[])$VALUES.clone();
        }

        public static ViewStatus valueOf(String string2) {
            return Enum.valueOf(ViewStatus.class, string2);
        }

        static {
            ViewStatus viewStatus;
            ViewStatus viewStatus2;
            ViewStatus viewStatus3;
            ViewStatus viewStatus4 = viewStatus3;
            SENT = new ViewStatus();
            ViewStatus viewStatus5 = viewStatus2;
            SENDING = new ViewStatus();
            ViewStatus viewStatus6 = viewStatus;
            FAILED = new ViewStatus();
            $VALUES = new ViewStatus[]{viewStatus4, viewStatus5, viewStatus6};
        }
    }

    public static final class ViewStyle
    extends Enum<ViewStyle> {
        public static final /* enum */ ViewStyle MESSAGE;
        public static final /* enum */ ViewStyle ITEM;
        private static final /* synthetic */ ViewStyle[] $VALUES;

        public static ViewStyle[] values() {
            return (ViewStyle[])$VALUES.clone();
        }

        public static ViewStyle valueOf(String string2) {
            return Enum.valueOf(ViewStyle.class, string2);
        }

        static {
            ViewStyle viewStyle;
            ViewStyle viewStyle2;
            ViewStyle viewStyle3 = viewStyle2;
            MESSAGE = new ViewStyle();
            ViewStyle viewStyle4 = viewStyle;
            ITEM = new ViewStyle();
            $VALUES = new ViewStyle[]{viewStyle3, viewStyle4};
        }
    }

    public static final class ImageStyle
    extends Enum<ImageStyle> {
        public static final /* enum */ ImageStyle HORIZONTAL;
        public static final /* enum */ ImageStyle SQUARE;
        private static final /* synthetic */ ImageStyle[] $VALUES;

        public static ImageStyle[] values() {
            return (ImageStyle[])$VALUES.clone();
        }

        public static ImageStyle valueOf(String string2) {
            return Enum.valueOf(ImageStyle.class, string2);
        }

        static {
            ImageStyle imageStyle;
            ImageStyle imageStyle2;
            ImageStyle imageStyle3 = imageStyle2;
            HORIZONTAL = new ImageStyle();
            ImageStyle imageStyle4 = imageStyle;
            SQUARE = new ImageStyle();
            $VALUES = new ImageStyle[]{imageStyle3, imageStyle4};
        }
    }

    public static final class ViewType
    extends Enum<ViewType> {
        public static final /* enum */ ViewType COMPOUND;
        public static final /* enum */ ViewType CAROUSEL;
        public static final /* enum */ ViewType LOCATION;
        public static final /* enum */ ViewType TYPING_INDICATOR;
        private static final /* synthetic */ ViewType[] $VALUES;

        public static ViewType[] values() {
            return (ViewType[])$VALUES.clone();
        }

        public static ViewType valueOf(String string2) {
            return Enum.valueOf(ViewType.class, string2);
        }

        static {
            ViewType viewType;
            ViewType viewType2;
            ViewType viewType3;
            ViewType viewType4;
            ViewType viewType5 = viewType4;
            COMPOUND = new ViewType();
            ViewType viewType6 = viewType3;
            CAROUSEL = new ViewType();
            ViewType viewType7 = viewType2;
            LOCATION = new ViewType();
            ViewType viewType8 = viewType;
            TYPING_INDICATOR = new ViewType();
            $VALUES = new ViewType[]{viewType5, viewType6, viewType7, viewType8};
        }
    }
}

