/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ui.widget;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import com.avaya.core.MessageAction;
import com.avaya.ui.R;
import com.bumptech.glide.Glide;
import java.util.List;

public class RepliesView
extends LinearLayout {
    private Delegate delegate;

    public RepliesView(Context context) {
        RepliesView repliesView = this;
        super(context);
        repliesView.init();
    }

    public RepliesView(Context context, AttributeSet attributeSet) {
        RepliesView repliesView = this;
        super(context, attributeSet);
        repliesView.init();
    }

    public RepliesView(Context context, AttributeSet attributeSet, int n2) {
        RepliesView repliesView = this;
        super(context, attributeSet, n2);
        repliesView.init();
    }

    private void init() {
        this.setOrientation(1);
    }

    private ImageView createReplyImageView() {
        int n2;
        ImageView imageView = new ImageView(this.getContext());
        int n3 = n2 = (int)this.getResources().getDimension(R.dimen.AvMessagingSdk_btnIconSize);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(n3, n3);
        layoutParams.setMargins(this.getResources().getDimensionPixelSize(R.dimen.AvMessagingSdk_btnIconMargin), 0, 0, 0);
        layoutParams.gravity = 16;
        imageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        return imageView;
    }

    private ImageView createReplyImageView(String string2) {
        ImageView imageView = this.createReplyImageView();
        Glide.with((View)this).load(string2).into(imageView);
        return imageView;
    }

    private ImageView createReplyImageView(Drawable drawable2) {
        ImageView imageView = this.createReplyImageView();
        imageView.setImageDrawable(drawable2);
        return imageView;
    }

    private Drawable createReplyDrawable() {
        GradientDrawable gradientDrawable;
        RepliesView repliesView = this;
        int n2 = repliesView.getSaturatedColor(repliesView.getResources().getColor(R.color.AvMessagingSdk_accent));
        GradientDrawable gradientDrawable2 = gradientDrawable;
        gradientDrawable2();
        gradientDrawable2.setColor(n2);
        gradientDrawable2.setCornerRadius(this.getResources().getDimension(R.dimen.AvMessagingSdk_messageRadius));
        gradientDrawable.setStroke(this.getResources().getDimensionPixelSize(R.dimen.AvMessagingSdk_replyActionBorder), this.getResources().getColor(R.color.AvMessagingSdk_accent));
        if (Build.VERSION.SDK_INT < 21) {
            return this.createStateListDrawable((Drawable)gradientDrawable2);
        }
        return this.createRippleDrawable(gradientDrawable2);
    }

    @TargetApi(value=21)
    private Drawable createRippleDrawable(GradientDrawable gradientDrawable) {
        ColorStateList colorStateList;
        int[] nArray = new int[2];
        int[] nArray2 = nArray;
        nArray[0] = -16842908;
        nArray[1] = 16842919;
        int[] nArray3 = new int[2];
        int[] nArray4 = nArray3;
        nArray3[0] = 16842908;
        nArray3[1] = 16842919;
        ColorStateList colorStateList2 = colorStateList;
        int[][] nArrayArray = new int[][]{nArray2, nArray4};
        int[] nArray5 = new int[2];
        nArray2 = nArray5;
        nArray2[0] = this.getResources().getColor(R.color.AvMessagingSdk_accentDark);
        nArray5[1] = this.getResources().getColor(R.color.AvMessagingSdk_accentDark);
        colorStateList = new ColorStateList((int[][])nArrayArray, nArray2);
        return new RippleDrawable(colorStateList2, (Drawable)gradientDrawable, null);
    }

    private Drawable createStateListDrawable(Drawable drawable2) {
        StateListDrawable stateListDrawable;
        GradientDrawable gradientDrawable;
        int[] nArray = new int[2];
        int[] nArray2 = nArray;
        nArray[0] = -16842908;
        nArray[1] = 16842919;
        int[] nArray3 = new int[2];
        int[] nArray4 = nArray3;
        nArray3[0] = 16842908;
        nArray3[1] = 16842919;
        int[] nArray5 = new int[]{};
        GradientDrawable gradientDrawable2 = gradientDrawable;
        gradientDrawable2();
        gradientDrawable2.setColor(repliesView.getResources().getColor(R.color.AvMessagingSdk_accentDark));
        gradientDrawable.setCornerRadius(repliesView.getResources().getDimension(R.dimen.AvMessagingSdk_messageRadius));
        RepliesView repliesView = stateListDrawable;
        repliesView();
        repliesView.addState(nArray2, (Drawable)gradientDrawable2);
        repliesView.addState(nArray4, (Drawable)gradientDrawable2);
        stateListDrawable.addState(nArray5, drawable2);
        return stateListDrawable;
    }

    private TextView createReplyTextView() {
        TextView textView;
        TextView textView2;
        TextView textView3 = textView2 = textView;
        TextView textView4 = textView2;
        textView4(this.getContext());
        textView4.setMaxLines(1);
        textView4.setEllipsize(TextUtils.TruncateAt.END);
        textView2.setTextSize(0, this.getResources().getDimension(R.dimen.AvMessagingSdk_btnActionText));
        textView3.setTextColor(this.getResources().getColor(R.color.AvMessagingSdk_accent));
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2);
        RepliesView repliesView = this;
        int n2 = repliesView.getResources().getDimensionPixelSize(R.dimen.AvMessagingSdk_messagePaddingTop);
        int n3 = repliesView.getResources().getDimensionPixelSize(R.dimen.AvMessagingSdk_messagePaddingHorizontal);
        int n4 = repliesView.getResources().getDimensionPixelSize(R.dimen.AvMessagingSdk_messagePaddingTop);
        layoutParams.setMargins(this.getResources().getDimensionPixelSize(R.dimen.AvMessagingSdk_messagePaddingHorizontal), n2, n3, n4);
        textView3.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        textView.setTextSize(0, this.getResources().getDimension(R.dimen.AvMessagingSdk_messageText));
        return textView;
    }

    private LinearLayout createButtonRow() {
        LinearLayout.LayoutParams layoutParams;
        LinearLayout linearLayout;
        LinearLayout linearLayout2 = linearLayout;
        RepliesView repliesView = repliesView2;
        linearLayout2(repliesView2.getContext());
        RepliesView repliesView2 = layoutParams;
        new LinearLayout.LayoutParams((int)-2, (int)-2).gravity = 5;
        int n2 = repliesView.getResources().getDimensionPixelSize(R.dimen.AvMessagingSdk_messagePaddingHorizontal);
        int n3 = repliesView.getResources().getDimensionPixelSize(R.dimen.AvMessagingSdk_messagePaddingTop);
        linearLayout.setPadding(0, 0, n2, n3);
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)repliesView2);
        return linearLayout;
    }

    private int getSaturatedColor(@ColorInt int n2) {
        RepliesView repliesView = object;
        int n3 = n2;
        float[] fArray = new float[3];
        Object object = fArray;
        Color.colorToHSV((int)n3, (float[])fArray);
        n2 = 1;
        float f2 = repliesView.isDarkColor(n3) ? 0.04f : 0.1f;
        Object object2 = object;
        object2[n2] = (RepliesView)f2;
        object2[2] = (RepliesView)1.0f;
        return Color.HSVToColor((float[])object2);
    }

    private boolean isDarkColor(int n2) {
        int n3;
        int n4 = n2;
        return (float)((Color.red((int)n2) * 299 + (n3 = Color.green((int)n4)) * 587 + (n2 = Color.blue((int)n4)) * 114) / 1000) <= 128.0f;
    }

    public void setDelegate(Delegate delegate) {
        this.delegate = delegate;
    }

    public void setReplies(List<MessageAction> linearLayout) {
        LinearLayout linearLayout2 = linearLayout;
        RepliesView repliesView = this;
        repliesView.removeAllViews();
        linearLayout = repliesView.createButtonRow();
        for (final MessageAction messageAction : linearLayout2) {
            LinearLayout linearLayout3;
            LinearLayout linearLayout4 = linearLayout3;
            new LinearLayout(this.getContext()).setOrientation(0);
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2);
            layoutParams.setMargins(this.getResources().getDimensionPixelSize(R.dimen.AvMessagingSdk_messagePaddingHorizontal), 0, 0, 0);
            linearLayout4.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            int n2 = messageAction.getIconUrl() != null && !messageAction.getIconUrl().trim().isEmpty() ? 1 : 0;
            if (messageAction.getType().equals("locationRequest")) {
                RepliesView repliesView2 = this;
                ImageView imageView = repliesView2.createReplyImageView(repliesView2.getResources().getDrawable(R.drawable.location));
                imageView.getDrawable().setColorFilter(this.getContext().getResources().getColor(R.color.AvMessagingSdk_accent), PorterDuff.Mode.SRC_IN);
                linearLayout4.addView((View)imageView);
            } else if (n2 != 0) {
                linearLayout4.addView((View)this.createReplyImageView(messageAction.getIconUrl()));
            }
            TextView textView = this.createReplyTextView();
            textView.setText((CharSequence)messageAction.getText());
            linearLayout4.addView((View)textView);
            Drawable drawable2 = this.createReplyDrawable();
            if (Build.VERSION.SDK_INT >= 16) {
                linearLayout4.setBackground(drawable2);
            } else {
                linearLayout4.setBackgroundDrawable(drawable2);
            }
            int n3 = n2;
            LinearLayout linearLayout5 = linearLayout4;
            linearLayout.measure(-2, -2);
            linearLayout5.measure(-2, -2);
            linearLayout5.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    if (RepliesView.this.delegate != null) {
                        RepliesView.this.delegate.onReplySelected(messageAction);
                    }
                }
            });
            int n4 = this.getResources().getDimensionPixelSize(R.dimen.AvMessagingSdk_messagePaddingHorizontal);
            n2 = linearLayout4.getMeasuredWidth();
            if (n3 != 0) {
                n2 += this.getImageSize();
            }
            if (n4 + linearLayout.getMeasuredWidth() + n2 > this.getResources().getDisplayMetrics().widthPixels) {
                RepliesView repliesView3 = this;
                repliesView3.addView((View)linearLayout);
                linearLayout = repliesView3.createButtonRow();
            }
            linearLayout.addView((View)linearLayout4);
        }
        this.addView((View)linearLayout);
    }

    public int getImageSize() {
        return this.getResources().getDimensionPixelSize(R.dimen.AvMessagingSdk_btnIconMargin) + (int)this.getResources().getDimension(R.dimen.AvMessagingSdk_btnIconSize);
    }

    public static interface Delegate {
        public void onReplySelected(MessageAction var1);
    }
}

