/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ui.fragment;

import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.webkit.JavascriptInterface;
import android.webkit.URLUtil;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceRequest;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import androidx.annotation.RequiresApi;
import androidx.appcompat.widget.Toolbar;
import androidx.fragment.app.Fragment;
import com.avaya.ui.R;

public class WebviewFragment
extends Fragment {
    public static final String FRAGMENT_NAME = "WebviewFragment";
    private static final String SIZE_FULL = "full";
    private static final String SIZE_TALL = "tall";
    private static final String SIZE_COMPACT = "compact";
    private Handler handler;
    private WebviewFragmentListener fragmentListener;
    private WebView webview;
    private FrameLayout fader;
    private Toolbar webviewToolbar;
    private FrameLayout webviewSpinner;
    private LinearLayout webviewContainer;
    private String url;
    private String size;
    private int previousOrientation;
    private int previousAvailableHeight;

    public WebviewFragment() {
        Handler handler;
        WebviewFragment webviewFragment = handler;
        handler = new Handler();
        v1.handler = webviewFragment;
    }

    private void doLayout() {
        FrameLayout.LayoutParams layoutParams;
        Rect rect;
        if (!this.isAdded()) {
            return;
        }
        int n2 = 0;
        int n3 = this.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (n3 > 0) {
            n2 = this.getResources().getDimensionPixelSize(n3);
        }
        WebviewFragment webviewFragment = this;
        Rect rect2 = rect;
        rect2();
        this.webviewContainer.getRootView().getWindowVisibleDisplayFrame(rect2);
        n2 = rect.bottom - n2;
        int n4 = webviewFragment.getResources().getConfiguration().orientation;
        if (webviewFragment.previousOrientation == n4 && this.previousAvailableHeight == n2) {
            return;
        }
        int n5 = this.previousOrientation = n4;
        this.previousAvailableHeight = n2;
        n4 = this.getResources().getBoolean(R.bool.AvMessagingSdk_isTablet) ? 1 : 0;
        int n6 = n5 == 2 ? 1 : 0;
        FrameLayout.LayoutParams layoutParams2 = layoutParams;
        layoutParams = new FrameLayout.LayoutParams(-1, -1);
        if (n4 != 0) {
            layoutParams2.gravity = 17;
            layoutParams2.width = n6 != 0 ? this.getResources().getDimensionPixelSize(R.dimen.AvMessagingSdk_webviewTabletWidthPortrait) : this.getResources().getDimensionPixelSize(R.dimen.AvMessagingSdk_webviewTabletWidthLandscape);
        } else {
            layoutParams2.gravity = 80;
        }
        if (n4 != 0 || n6 == 0 && !this.size.equals(SIZE_FULL)) {
            String string2 = this.size;
            string2.hashCode();
            n6 = -1;
            switch (string2.hashCode()) {
                default: {
                    break;
                }
                case 950483747: {
                    if (!string2.equals(SIZE_COMPACT)) break;
                    n6 = 2;
                    break;
                }
                case 3552429: {
                    if (!string2.equals(SIZE_TALL)) break;
                    n6 = 1;
                    break;
                }
                case 3154575: {
                    if (!string2.equals(SIZE_FULL)) break;
                    n6 = 0;
                }
            }
            switch (n6) {
                default: {
                    break;
                }
                case 2: {
                    layoutParams2.height = this.getResources().getDimensionPixelSize(R.dimen.AvMessagingSdk_webviewHeightCompact);
                    break;
                }
                case 1: {
                    layoutParams2.height = this.getResources().getDimensionPixelSize(R.dimen.AvMessagingSdk_webviewHeightTall);
                    break;
                }
                case 0: {
                    layoutParams2.height = this.getResources().getDimensionPixelSize(R.dimen.AvMessagingSdk_webviewTabletHeightFull);
                }
            }
            if (layoutParams2.height > n2) {
                layoutParams2.height = -1;
            }
        }
        WebviewFragment webviewFragment2 = this;
        webviewFragment2.webviewContainer.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
        webviewFragment2.fragmentListener.onWebviewShown();
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        try {
            this.fragmentListener = (WebviewFragmentListener)context;
            return;
        }
        catch (ClassCastException classCastException) {
            throw new ClassCastException(context.toString() + " must implement WebviewFragmentListener");
        }
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup object, Bundle bundle) {
        layoutInflater = layoutInflater.inflate(R.layout.avmessagingsdk_fragment_webview, object, false);
        WebviewFragment webviewFragment = this;
        super.onCreate(bundle);
        webviewFragment.setRetainInstance(true);
        this.fader = (FrameLayout)layoutInflater.findViewById(R.id.fader);
        this.webview = (WebView)layoutInflater.findViewById(R.id.webview);
        this.webviewSpinner = (FrameLayout)layoutInflater.findViewById(R.id.webviewProgress);
        this.webviewToolbar = (Toolbar)layoutInflater.findViewById(R.id.webviewToolbar);
        this.webviewContainer = (LinearLayout)layoutInflater.findViewById(R.id.webviewContainer);
        object = layoutInflater.getViewTreeObserver();
        if (object.isAlive()) {
            ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener;
            ViewGroup viewGroup = object;
            object = onGlobalLayoutListener;
            onGlobalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

                public void onGlobalLayout() {
                    WebviewFragment.this.doLayout();
                }
            };
            viewGroup.addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)object);
        }
        WebviewFragment webviewFragment2 = this;
        webviewFragment2.webviewToolbar.setTitle(R.string.AvMessagingSdk_webviewLoading);
        webviewFragment2.webviewToolbar.setNavigationIcon(R.drawable.ic_clear_black_24dp);
        webviewFragment2.webviewToolbar.setNavigationOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                b b2 = this;
                b2.WebviewFragment.this.getActivity().getSupportFragmentManager().popBackStack(WebviewFragment.FRAGMENT_NAME, 1);
                b2.WebviewFragment.this.fragmentListener.onWebviewHidden();
            }
        });
        webviewFragment2.webview.getSettings().setUserAgentString(this.webview.getSettings().getUserAgentString() + " AndroidWebview/" + "3.1.0");
        return layoutInflater;
    }

    public void onConfigurationChanged(Configuration configuration) {
        WebviewFragment webviewFragment = this;
        super.onConfigurationChanged(configuration);
        webviewFragment.doLayout();
    }

    public Animation onCreateAnimation(int n2, boolean bl, int n3) {
        if (bl) {
            WebviewFragment webviewFragment = this;
            Animation animation = AnimationUtils.loadAnimation((Context)webviewFragment.getActivity(), (int)R.anim.stripe_slide_in);
            animation.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                    WebviewFragment.this.webviewSpinner.setVisibility(0);
                }

                public void onAnimationEnd(Animation animation) {
                    c c2 = this;
                    c2.WebviewFragment.this.webview.setWebViewClient(new WebViewClient(){

                        public void onPageFinished(WebView webView, String string2) {
                            a a2 = this;
                            super.onPageFinished(webView, string2);
                            a2.WebviewFragment.this.webviewToolbar.setTitle((CharSequence)webView.getTitle());
                        }

                        public void onPageStarted(WebView webView, String string2, Bitmap bitmap) {
                            a a2 = this;
                            super.onPageStarted(webView, string2, bitmap);
                            a2.WebviewFragment.this.webviewSpinner.setVisibility(0);
                        }

                        public boolean shouldOverrideUrlLoading(WebView webView, String string2) {
                            Intent intent;
                            if (URLUtil.isNetworkUrl((String)string2)) {
                                return false;
                            }
                            a a2 = a3;
                            a a3 = intent;
                            intent = new Intent("android.intent.action.VIEW", Uri.parse((String)string2));
                            a2.WebviewFragment.this.startActivity((Intent)a3);
                            return true;
                        }

                        @RequiresApi(api=21)
                        public boolean shouldOverrideUrlLoading(WebView webView, WebResourceRequest webResourceRequest) {
                            Intent intent;
                            if (URLUtil.isNetworkUrl((String)webResourceRequest.getUrl().toString())) {
                                return false;
                            }
                            a a2 = a3;
                            a a3 = intent;
                            intent = new Intent("android.intent.action.VIEW", Uri.parse((String)webResourceRequest.getUrl().toString()));
                            a2.WebviewFragment.this.startActivity((Intent)a3);
                            return true;
                        }
                    });
                    c2.WebviewFragment.this.webview.setWebChromeClient(new WebChromeClient(){

                        public void onProgressChanged(WebView webView, int n2) {
                            if (n2 == 100) {
                                WebviewFragment.this.webviewSpinner.setVisibility(8);
                            }
                        }
                    });
                    c2.WebviewFragment.this.webview.getSettings().setJavaScriptEnabled(true);
                    c2.WebviewFragment.this.webview.addJavascriptInterface((Object)new WebViewJavaScriptApi(), "AndroidWebviewInterface");
                    c2.WebviewFragment.this.webview.loadUrl(WebviewFragment.this.url);
                }

                public void onAnimationRepeat(Animation animation) {
                }
            });
            webviewFragment.webviewContainer.setAnimation(animation);
            webviewFragment.fader.setAnimation(AnimationUtils.loadAnimation((Context)this.getActivity(), (int)0x10A0000));
            webviewFragment.webviewContainer.animate();
            webviewFragment.fader.animate();
            return null;
        }
        WebviewFragment webviewFragment = this;
        webviewFragment.webviewContainer.setAnimation(AnimationUtils.loadAnimation((Context)this.getActivity(), (int)R.anim.stripe_slide_out));
        webviewFragment.webviewContainer.animate();
        return AnimationUtils.loadAnimation((Context)webviewFragment.getActivity(), (int)0x10A0001);
    }

    public void setUrl(String string2) {
        this.url = string2;
    }

    public void setSize(String string2) {
        this.size = string2;
    }

    public boolean goBack() {
        WebView webView = this.webview;
        if (webView != null && webView.canGoBack()) {
            this.webview.goBack();
            return true;
        }
        return false;
    }

    public class WebViewJavaScriptApi {
        @JavascriptInterface
        public void setTitle(final String string2) {
            WebviewFragment.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    WebviewFragment.this.webviewToolbar.setTitle((CharSequence)string2);
                }
            });
        }

        @JavascriptInterface
        public void close() {
            WebviewFragment.this.handler.post(new Runnable(){

                @Override
                public void run() {
                    b b2 = this;
                    b2.WebviewFragment.this.getActivity().getSupportFragmentManager().popBackStack(WebviewFragment.FRAGMENT_NAME, 1);
                    b2.WebviewFragment.this.fragmentListener.onWebviewHidden();
                }
            });
        }
    }

    public static interface WebviewFragmentListener {
        public void onWebviewShown();

        public void onWebviewHidden();
    }
}

