/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ui.utils;

import android.os.Bundle;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.LinearSnapHelper;
import androidx.recyclerview.widget.OrientationHelper;
import androidx.recyclerview.widget.RecyclerView;
import com.avaya.ui.R;
import com.avaya.ui.adapter.CarouselAdapter;
import java.util.HashMap;
import java.util.Map;

public class CarouselSnapHelper
extends LinearSnapHelper {
    private static Map<String, Bundle> recyclerViewInstanceStateMap = new HashMap<String, Bundle>();
    private RecyclerView recyclerView;
    private OrientationHelper horizontalHelper;

    private View getTargetSnapView(RecyclerView.LayoutManager layoutManager, OrientationHelper orientationHelper) {
        LinearLayoutManager linearLayoutManager = (LinearLayoutManager)layoutManager;
        int n2 = linearLayoutManager.findFirstVisibleItemPosition();
        int n3 = linearLayoutManager.findLastCompletelyVisibleItemPosition();
        int n4 = n3 == layoutManager.getItemCount() - 1 ? 1 : 0;
        if (n2 == -1) {
            return null;
        }
        if (n4 != 0) {
            return layoutManager.findViewByPosition(n3);
        }
        View view = layoutManager.findViewByPosition(n2);
        n4 = orientationHelper.getDecoratedEnd(view);
        int n5 = orientationHelper.getDecoratedMeasurement(view);
        if (n4 > 0 && n4 >= n5 / 2 + this.getAvatarWidth()) {
            return view;
        }
        return layoutManager.findViewByPosition(n2 + 1);
    }

    private int findScrollDistance(View view, RecyclerView.LayoutManager layoutManager, OrientationHelper orientationHelper) {
        Bundle bundle;
        CarouselAdapter.MessageItemViewHolder messageItemViewHolder;
        int n2 = orientationHelper.getDecoratedStart(view) - orientationHelper.getStartAfterPadding() - this.getAvatarWidth();
        int n3 = layoutManager.getPosition(view);
        if (n3 != 1 && n3 != layoutManager.getItemCount() - 1) {
            n2 += this.getMessageItemMargin();
        }
        try {
            messageItemViewHolder = (CarouselAdapter.MessageItemViewHolder)this.recyclerView.getChildViewHolder(view);
        }
        catch (Exception exception) {}
        view = bundle;
        view();
        bundle.putParcelable("recycler_state", this.recyclerView.getLayoutManager().onSaveInstanceState());
        recyclerViewInstanceStateMap.put(messageItemViewHolder.item.messageId, (Bundle)view);
        return n2;
    }

    private OrientationHelper getHorizontalHelper(RecyclerView.LayoutManager layoutManager) {
        if (this.horizontalHelper == null) {
            this.horizontalHelper = OrientationHelper.createHorizontalHelper((RecyclerView.LayoutManager)layoutManager);
        }
        return this.horizontalHelper;
    }

    private int getAvatarWidth() {
        CarouselSnapHelper carouselSnapHelper = carouselSnapHelper.recyclerView.getResources();
        return carouselSnapHelper.getDimensionPixelSize(R.dimen.AvMessagingSdk_messageAvatar) + carouselSnapHelper.getDimensionPixelSize(R.dimen.AvMessagingSdk_messageAvatarMargin) + carouselSnapHelper.getDimensionPixelSize(R.dimen.AvMessagingSdk_conversationMargin);
    }

    private int getMessageItemMargin() {
        return this.recyclerView.getResources().getDimensionPixelSize(R.dimen.AvMessagingSdk_messageItemMargin);
    }

    private int getCarouselItemWidth() {
        return this.recyclerView.getResources().getDimensionPixelSize(R.dimen.AvMessagingSdk_imageDisplayWidth);
    }

    public static Bundle getRecyclerViewInstanceState(String string2) {
        return recyclerViewInstanceStateMap.get(string2);
    }

    public void attachToRecyclerView(@Nullable RecyclerView recyclerView) throws IllegalStateException {
        super.attachToRecyclerView(recyclerView);
        this.recyclerView = recyclerView;
    }

    public int[] calculateDistanceToFinalSnap(@NonNull RecyclerView.LayoutManager layoutManager, @NonNull View view) {
        int[] nArray = new int[2];
        CarouselSnapHelper carouselSnapHelper = carouselSnapHelper2;
        CarouselSnapHelper carouselSnapHelper2 = carouselSnapHelper.getHorizontalHelper(layoutManager);
        nArray[0] = carouselSnapHelper.findScrollDistance(view, layoutManager, (OrientationHelper)carouselSnapHelper2);
        nArray[1] = 0;
        return nArray;
    }

    public View findSnapView(RecyclerView.LayoutManager layoutManager) {
        return this.getTargetSnapView(layoutManager, this.getHorizontalHelper(layoutManager));
    }
}

