/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ui;

import android.os.Bundle;
import android.os.Handler;
import android.view.Menu;
import android.view.MenuItem;
import android.view.inputmethod.InputMethodManager;
import androidx.annotation.NonNull;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import com.avaya.core.ActionState;
import com.avaya.core.AvMessagingSdk;
import com.avaya.core.AvMessagingSdkCallback;
import com.avaya.core.AvMessagingSdkConnectionStatus;
import com.avaya.core.CardSummary;
import com.avaya.core.Config;
import com.avaya.core.Conversation;
import com.avaya.core.ConversationDelegate;
import com.avaya.core.ConversationEvent;
import com.avaya.core.InitializationStatus;
import com.avaya.core.LoginResult;
import com.avaya.core.LogoutResult;
import com.avaya.core.Message;
import com.avaya.core.MessageAction;
import com.avaya.core.MessageUploadStatus;
import com.avaya.core.PaymentStatus;
import com.avaya.ui.ConversationActivityBuilder;
import com.avaya.ui.R;
import com.avaya.ui.fragment.ConversationFragment;
import com.avaya.ui.fragment.ShaderFragment;
import com.avaya.ui.fragment.StripeFragment;
import com.avaya.ui.fragment.WebviewFragment;
import java.io.Serializable;
import java.util.List;

public class ConversationActivity
extends AppCompatActivity
implements ConversationDelegate,
StripeFragment.StripeFragmentListener,
ShaderFragment.ShaderFragmentListener,
WebviewFragment.WebviewFragmentListener {
    private static final String CONVERSATION_FRAGMENT = "ConversationFragment";
    private static final String STRIPE_FRAGMENT = "StripeFragment";
    private static final String SHADER_FRAGMENT = "ShaderFragment";
    private static final int CONVERSATION_ACTIVITY_DELEGATE = 10;
    private static ConversationActivity runningActivity;
    private FragmentManager manager;
    private Handler handler;
    private boolean stripeShouldBePopped;
    private boolean webviewShown;
    private StripeFragment stripeFragment;
    private ConversationFragment conversationFragment;
    private ShaderFragment shaderFragment;
    private Conversation conversation;

    public ConversationActivity() {
        ConversationActivity conversationActivity = this;
        conversationActivity.manager = conversationActivity.getSupportFragmentManager();
        conversationActivity.handler = new Handler();
    }

    public static ConversationActivityBuilder builder() {
        return new ConversationActivityBuilder();
    }

    public static void close() {
        ConversationActivity conversationActivity = runningActivity;
        if (conversationActivity != null) {
            conversationActivity.finish();
            runningActivity = null;
        }
    }

    private void showConversationFragment() {
        if (this.conversationFragment == null) {
            ConversationActivity conversationActivity = this;
            final FragmentTransaction fragmentTransaction = conversationActivity.manager.beginTransaction();
            conversationActivity.conversationFragment = new ConversationFragment();
            Object object = conversationActivity.getIntent();
            String string2 = object.getStringExtra("INTENT_STARTING_TEXT");
            object = object.getStringExtra("INTENT_CONVERSATION_ID");
            if (string2 != null) {
                this.conversationFragment.setStartingText(string2);
            }
            int n2 = R.id.avmessagingsdk_activity_fragment_container;
            fragmentTransaction.add(n2, (Fragment)this.conversationFragment, CONVERSATION_FRAGMENT);
            if (object != null) {
                AvMessagingSdkCallback<Conversation> avMessagingSdkCallback;
                Object object2 = object;
                object = avMessagingSdkCallback;
                avMessagingSdkCallback = new AvMessagingSdkCallback<Conversation>(){

                    public void run(@NonNull AvMessagingSdkCallback.Response<Conversation> conversation) {
                        if ((conversation = (Conversation)conversation.getData()) != null) {
                            a a2 = this;
                            ConversationActivity.access$002(a2.ConversationActivity.this, conversation);
                            a2.fragmentTransaction.commit();
                            a2.ConversationActivity.this.addShaderFragment();
                        }
                    }
                };
                AvMessagingSdk.loadConversation((String)object2, (AvMessagingSdkCallback)object);
            } else {
                object = AvMessagingSdk.getConversation();
                this.conversation = object;
                if (object != null) {
                    object.avMessagingSdkShown();
                    fragmentTransaction.commit();
                    this.addShaderFragment();
                }
            }
        }
    }

    private void showStripeFragment(MessageAction messageAction) {
        if (this.stripeFragment == null) {
            Bundle bundle;
            FragmentTransaction fragmentTransaction = this.manager.beginTransaction();
            ConversationActivity conversationActivity = this;
            Bundle bundle2 = bundle;
            bundle2();
            this.stripeFragment = new StripeFragment();
            bundle.putSerializable("action", (Serializable)messageAction);
            conversationActivity.stripeFragment.setArguments(bundle2);
            int n2 = R.id.avmessagingsdk_activity_fragment_container;
            fragmentTransaction.add(n2, (Fragment)conversationActivity.stripeFragment, STRIPE_FRAGMENT);
            fragmentTransaction.addToBackStack(null);
            fragmentTransaction.commit();
        }
    }

    private void addShaderFragment() {
        if (object.shaderFragment == null) {
            ShaderFragment shaderFragment;
            FragmentTransaction fragmentTransaction = object.manager.beginTransaction();
            ConversationActivity conversationActivity = object;
            Object object = shaderFragment;
            conversationActivity.shaderFragment = new ShaderFragment();
            fragmentTransaction.add(R.id.avmessagingsdk_activity_fragment_container, (Fragment)object, SHADER_FRAGMENT);
            fragmentTransaction.commit();
        }
    }

    private void setup() {
        ActionBar actionBar = this.getSupportActionBar();
        this.setContentView(R.layout.avmessagingsdk_activity_conversation);
        if (actionBar != null) {
            ActionBar actionBar2 = actionBar;
            actionBar2.show();
            actionBar2.setDisplayHomeAsUpEnabled(true);
            actionBar2.setDisplayShowHomeEnabled(true);
        }
    }

    private boolean stripeFragmentShown() {
        return this.manager.findFragmentByTag(STRIPE_FRAGMENT) != null;
    }

    private void popStripeAfterSeconds(int n2) {
        Runnable runnable;
        Runnable runnable2 = runnable;
        runnable = new Runnable(){

            @Override
            public void run() {
                ConversationActivity.this.popStripeFragment();
            }
        };
        this.runAfter(runnable2, n2 * 1000);
    }

    private void onStripeFragmentPopped() {
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            actionBar.show();
        }
        ConversationActivity conversationActivity = this;
        conversationActivity.removeShade();
        conversationActivity.addActionBarSpacingAndRestoreScrollPosition();
        conversationActivity.runAfter(new Runnable(){

            @Override
            public void run() {
                ConversationActivity.this.hideKeyboard();
            }
        }, this.getResources().getInteger(0x10E0001));
    }

    private void hideKeyboard() {
        ConversationActivity conversationActivity = this;
        InputMethodManager inputMethodManager = (InputMethodManager)conversationActivity.getSystemService("input_method");
        if (conversationActivity.getCurrentFocus() != null && inputMethodManager != null) {
            inputMethodManager.hideSoftInputFromWindow(this.getCurrentFocus().getWindowToken(), 0);
        }
    }

    private void runAfter(Runnable runnable, int n2) {
        this.handler.postDelayed(runnable, (long)n2);
    }

    private void preserveScrollPositionAndRemoveActionBarSpacing() {
        ConversationFragment conversationFragment = this.conversationFragment;
        if (conversationFragment != null && conversationFragment.getView() != null) {
            ConversationActivity conversationActivity = this;
            conversationActivity.conversationFragment.preserveScroll();
            conversationActivity.conversationFragment.getView().findViewById(R.id.AvMessagingSdk_actionBarSpace).setVisibility(8);
        }
    }

    private void addActionBarSpacingAndRestoreScrollPosition() {
        ConversationFragment conversationFragment = this.conversationFragment;
        if (conversationFragment != null && conversationFragment.getView() != null) {
            ConversationActivity conversationActivity = this;
            conversationActivity.conversationFragment.getView().findViewById(R.id.AvMessagingSdk_actionBarSpace).setVisibility(0);
            conversationActivity.conversationFragment.restoreScroll();
        }
    }

    private void addShade() {
        Object object = object.shaderFragment;
        if (object != null) {
            ((ShaderFragment)((Object)object)).show();
        }
    }

    private void removeShade() {
        Object object = object.shaderFragment;
        if (object != null) {
            ((ShaderFragment)((Object)object)).hide();
        }
    }

    private void popStripeFragment() {
        StripeFragment stripeFragment = this.stripeFragment;
        if (stripeFragment != null && stripeFragment.isResumed()) {
            ConversationActivity conversationActivity = this;
            conversationActivity.stripeFragment = null;
            conversationActivity.stripeShouldBePopped = false;
            conversationActivity.manager.popBackStack();
            conversationActivity.onStripeFragmentPopped();
        } else {
            this.stripeShouldBePopped = true;
        }
    }

    private void stripeComplete() {
        this.popStripeAfterSeconds(2);
    }

    static /* synthetic */ Conversation access$002(ConversationActivity conversationActivity, Conversation conversation) {
        conversationActivity.conversation = conversation;
        return conversation;
    }

    protected void onCreate(Bundle bundle) {
        ConversationActivity conversationActivity = this;
        super.onCreate(bundle);
        bundle = conversationActivity.getSupportActionBar();
        if (bundle != null) {
            bundle.setTitle(null);
        }
        runningActivity = this;
        ConversationActivity.runningActivity.conversationFragment = (ConversationFragment)ConversationActivity.runningActivity.manager.findFragmentByTag(CONVERSATION_FRAGMENT);
        ConversationActivity.runningActivity.stripeFragment = (StripeFragment)ConversationActivity.runningActivity.manager.findFragmentByTag(STRIPE_FRAGMENT);
        ConversationActivity.runningActivity.shaderFragment = (ShaderFragment)ConversationActivity.runningActivity.manager.findFragmentByTag(SHADER_FRAGMENT);
        bundle = AvMessagingSdk.getConversationViewDelegate();
        if (bundle != null) {
            bundle.onStartActivityCalled(this.getIntent());
        }
        this.setup();
    }

    protected void onDestroy() {
        ConversationActivity conversationActivity = this;
        super.onDestroy();
        if (conversationActivity == runningActivity) {
            runningActivity = null;
        }
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        return false;
    }

    public boolean onOptionsItemSelected(MenuItem menuItem) {
        boolean bl = false;
        if (menuItem.getItemId() == 16908332) {
            this.finish();
            bl = true;
        }
        return bl || super.onOptionsItemSelected(menuItem);
    }

    public void onBackPressed() {
        WebviewFragment webviewFragment = (WebviewFragment)this.manager.findFragmentByTag("WebviewFragment");
        if (webviewFragment != null && webviewFragment.goBack()) {
            return;
        }
        ConversationActivity conversationActivity = this;
        super.onBackPressed();
        if (conversationActivity.stripeFragmentShown()) {
            this.stripeFragment = null;
            this.onStripeFragmentPopped();
        }
        if (this.webviewShown) {
            this.onWebviewHidden();
        }
    }

    public void onResume() {
        ConversationActivity conversationActivity = this;
        super.onResume();
        AvMessagingSdk.addConversationUiDelegate((int)10, (ConversationDelegate)this);
        if (conversationActivity.stripeShouldBePopped) {
            this.popStripeAfterSeconds(3);
        }
    }

    public void onPause() {
        super.onPause();
        AvMessagingSdk.addConversationUiDelegate((int)10, null);
    }

    public void onStart() {
        ConversationActivity conversationActivity = this;
        super.onStart();
        conversationActivity.showConversationFragment();
    }

    public void onStop() {
        Conversation conversation;
        super.onStop();
        this.conversation = conversation = AvMessagingSdk.getConversation();
        if (conversation != null) {
            conversation.avMessagingSdkHidden();
        }
    }

    public void onMessagesReceived(@NonNull Conversation conversation, @NonNull List<Message> list) {
        ConversationFragment conversationFragment = this.conversationFragment;
        if (conversationFragment != null && conversationFragment.isResumed()) {
            this.conversationFragment.onMessagesReceived(conversation, list);
        }
    }

    public void onMessagesReset(@NonNull Conversation conversation, @NonNull List<Message> list) {
        ConversationFragment conversationFragment = this.conversationFragment;
        if (conversationFragment != null && conversationFragment.isResumed()) {
            this.conversationFragment.onMessagesReset(conversation, list);
        }
    }

    public void onUnreadCountChanged(@NonNull Conversation conversation, int n2) {
    }

    public void onMessageSent(@NonNull Message message, @NonNull MessageUploadStatus messageUploadStatus) {
        ConversationFragment conversationFragment = this.conversationFragment;
        if (conversationFragment != null && conversationFragment.isResumed()) {
            this.conversationFragment.onMessageSent(message, messageUploadStatus);
        }
    }

    public void onConversationEventReceived(@NonNull ConversationEvent conversationEvent) {
        ConversationFragment conversationFragment = this.conversationFragment;
        if (conversationFragment != null && conversationFragment.isResumed()) {
            this.conversationFragment.onConversationEventReceived(conversationEvent);
        }
    }

    public void onInitializationStatusChanged(@NonNull InitializationStatus initializationStatus) {
        ConversationFragment conversationFragment = this.conversationFragment;
        if (conversationFragment != null && conversationFragment.isResumed()) {
            this.conversationFragment.onInitializationStatusChanged(initializationStatus);
        }
    }

    public void onLoginComplete(@NonNull LoginResult loginResult) {
    }

    public void onLogoutComplete(@NonNull LogoutResult logoutResult) {
    }

    public void onPaymentProcessed(@NonNull MessageAction object, @NonNull PaymentStatus paymentStatus) {
        object = ((ConversationActivity)this).stripeFragment;
        if (object != null) {
            ((StripeFragment)object).onPaymentProcessed(paymentStatus);
        }
        if ((this = ((ConversationActivity)this).conversationFragment) != null) {
            ((ConversationFragment)this).onPaymentProcessed();
        }
    }

    public boolean shouldTriggerAction(@NonNull MessageAction messageAction) {
        Config config = AvMessagingSdk.getConfig();
        MessageAction messageAction2 = messageAction;
        String string2 = messageAction2.getType();
        String string3 = messageAction2.getState();
        boolean bl = false;
        if (config != null) {
            bl = config.isStripeEnabled();
        }
        if (string2 != null && string2.equals("buy")) {
            if (string3 == null || !string3.equals(ActionState.PAID.getValue())) {
                if (!bl) {
                    ((ConversationActivity)((Object)conversationFragment)).conversationFragment.triggerAction(messageAction);
                } else {
                    super.showStripeFragment(messageAction);
                }
            }
        } else {
            ConversationFragment conversationFragment = ((ConversationActivity)((Object)conversationFragment)).conversationFragment;
            if (conversationFragment != null) {
                conversationFragment.triggerAction(messageAction);
            }
        }
        return true;
    }

    public void onCardSummaryLoaded(@NonNull CardSummary cardSummary) {
        StripeFragment stripeFragment = ((ConversationActivity)((Object)stripeFragment)).stripeFragment;
        if (stripeFragment != null) {
            stripeFragment.onCardSummaryLoaded(cardSummary);
        }
    }

    public void onAvMessagingSdkConnectionStatusChanged(@NonNull AvMessagingSdkConnectionStatus avMessagingSdkConnectionStatus) {
        ConversationFragment conversationFragment = ((ConversationActivity)((Object)conversationFragment)).conversationFragment;
        if (conversationFragment != null) {
            conversationFragment.onAvMessagingSdkConnectionStatusChanged(avMessagingSdkConnectionStatus);
        }
    }

    public void onAvMessagingSdkShown() {
    }

    public void onAvMessagingSdkHidden() {
    }

    public void onConversationsListUpdated(@NonNull List<Conversation> list) {
    }

    @Override
    public void onStripeFragmentShown() {
        ActionBar actionBar = this.getSupportActionBar();
        ConversationActivity conversationActivity = this;
        conversationActivity.hideKeyboard();
        conversationActivity.preserveScrollPositionAndRemoveActionBarSpacing();
        conversationActivity.addShade();
        if (actionBar != null) {
            actionBar.hide();
        }
    }

    @Override
    public void onStripeFragmentClose() {
        this.popStripeFragment();
    }

    @Override
    public void onPurchaseComplete() {
        this.stripeComplete();
    }

    @Override
    public void onShadedAreaClick() {
        this.popStripeFragment();
    }

    @Override
    public void onWebviewShown() {
        ActionBar actionBar = this.getSupportActionBar();
        this.webviewShown = true;
        this.preserveScrollPositionAndRemoveActionBarSpacing();
        if (actionBar != null) {
            actionBar.hide();
        }
    }

    @Override
    public void onWebviewHidden() {
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            actionBar.show();
        }
        this.webviewShown = false;
        this.addActionBarSpacingAndRestoreScrollPosition();
    }
}

