/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.core;

import android.graphics.Bitmap;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.avaya.core.AvMessagingSdk;
import com.avaya.core.Coordinates;
import com.avaya.core.DisplaySettings;
import com.avaya.core.MessageAction;
import com.avaya.core.MessageItem;
import com.avaya.core.MessageType;
import com.avaya.core.MessageUploadStatus;
import com.avaya.core.model.CoordinatesDto;
import com.avaya.core.model.MessageActionDto;
import com.avaya.core.model.MessageDto;
import com.avaya.core.model.MessageItemDto;
import com.avaya.core.utils.f;
import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class Message
implements Serializable,
Comparable<Message> {
    private static String f = "Message";
    private MessageDto a;
    private List<MessageAction> b;
    private List<MessageItem> c;
    private Bitmap d;
    private File e;

    Message(@NonNull MessageDto messageDto) {
        com.avaya.core.a a2;
        ((Message)((Object)a2)).b = new LinkedList<MessageAction>();
        ((Message)((Object)a2)).c = new LinkedList<MessageItem>();
        ((Message)((Object)a2)).a = messageDto;
        for (MessageActionDto serializable : messageDto.j()) {
            ((Message)((Object)a2)).b.add(new MessageAction(serializable));
        }
        for (MessageItemDto messageItemDto : messageDto.k()) {
            ((Message)((Object)a2)).c.add(new MessageItem(messageItemDto));
        }
        if (messageDto.c() == null) {
            messageDto.a((double)System.currentTimeMillis() / 1000.0);
        }
        a2 = AvMessagingSdk.a();
        if (messageDto.u() != null && a2 != null) {
            MessageDto messageDto2 = messageDto;
            messageDto2.a(messageDto2.u().equals(a2.p()));
        }
    }

    Message() {
        MessageDto messageDto;
        Object object = messageDto;
        messageDto = new MessageDto();
        this((MessageDto)object);
        object = AvMessagingSdk.a();
        if (object != null) {
            this.a.k(((com.avaya.core.a)object).p());
        }
        Message message = this;
        message.a.g("appUser");
        message.a.a(MessageDto.Status.UNSENT);
        message.a.a((double)System.currentTimeMillis() / 1000.0);
    }

    public Message(String string2) {
        Message message = this;
        message();
        message.a.j("text");
        message.a.h(string2);
    }

    public Message(String string2, String string3, Map<String, Object> map) {
        Message message = this;
        message(string2);
        message.a.f(string3);
        message.a.a(map);
    }

    public Message(Coordinates coordinates, Map<String, Object> map) {
        Message message = this;
        message();
        message.a.j(MessageType.LOCATION.getValue());
        message.a.a(coordinates.a());
        message.a.a(map);
    }

    public Message(Bitmap bitmap) {
        Message message = this;
        message();
        message.a.j(MessageType.IMAGE.getValue());
        this.setImage(bitmap);
    }

    public Message(File file) {
        Message message = this;
        message();
        message.a.a(file.length());
        message.a.j(MessageType.FILE.getValue());
        this.setFile(file);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public Message copy() {
        return new Message(new MessageDto(this.a));
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public boolean isCarousel() {
        return MessageType.CAROUSEL.getValue().equals(this.getType()) || MessageType.LIST.getValue().equals(this.getType());
    }

    public String getAvatarUrl() {
        if (!this.isFromCurrentUser()) {
            return this.a.a();
        }
        return null;
    }

    @Nullable
    public String getUserId() {
        if (!this.isFromCurrentUser()) {
            return this.a.u();
        }
        return null;
    }

    @Nullable
    public String getUserRole() {
        if (!this.isFromCurrentUser()) {
            return this.a.o();
        }
        return null;
    }

    public void setAvatarUrl(String string2) {
        if (!this.isFromCurrentUser()) {
            this.a.a(string2);
        }
    }

    @Nullable
    public Date getDate() {
        Date date = com.avaya.core.utils.f.a(this.a.n());
        if (date == null) {
            date = com.avaya.core.utils.f.a(this.a.c());
        }
        return date;
    }

    public boolean isFromCurrentUser() {
        return this.a.v();
    }

    public List<MessageAction> getMessageActions() {
        return Collections.unmodifiableList(this.b);
    }

    public void addMessageAction(MessageAction messageAction) {
        Message message = this;
        message.a.j().add(messageAction.a());
        message.b.add(messageAction);
    }

    public void removeMessageAction(MessageAction messageAction) {
        Message message = this;
        message.a.j().remove(messageAction.a());
        message.b.remove(messageAction);
    }

    public List<MessageItem> getMessageItems() {
        return Collections.unmodifiableList(this.c);
    }

    public void addMessageItem(MessageItem messageItem) {
        Message message = this;
        message.a.k().add(messageItem.a());
        message.c.add(messageItem);
    }

    public void removeMessageItem(MessageItem messageItem) {
        Message message = this;
        message.a.k().remove(messageItem.a());
        message.c.remove(messageItem);
    }

    public String getName() {
        return this.a.d();
    }

    public void setName(String string2) {
        this.a.b(string2);
    }

    public String getText() {
        String string2 = ((Message)((Object)string3)).a.i() == null ? "" : ((Message)((Object)string3)).a.i().trim();
        String string3 = ((Message)((Object)string3)).a.r() == null ? "" : ((Message)((Object)string3)).a.r().trim();
        if (!TextUtils.isEmpty((CharSequence)string2) && string2.equals(string3)) {
            return "";
        }
        return string3;
    }

    public void setText(String string2) {
        this.a.h(string2);
    }

    @NonNull
    public MessageUploadStatus getUploadStatus() {
        int n2 = com.avaya.core.Message$a.a[this.a.q().ordinal()];
        if (n2 != 1) {
            if (n2 != 2) {
                return this.isFromCurrentUser() ? MessageUploadStatus.SENT : MessageUploadStatus.NOT_USER_MESSAGE;
            }
            return MessageUploadStatus.UNSENT;
        }
        return MessageUploadStatus.FAILED;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setUploadStatus(MessageUploadStatus messageUploadStatus) {
        int n2 = com.avaya.core.Message$a.b[messageUploadStatus.ordinal()];
        if (n2 != 1) {
            if (n2 != 2) {
                if (n2 != 3) {
                    Log.w((String)f, (String)"Invalid message status");
                } else {
                    this.a.a(MessageDto.Status.SENT);
                }
            } else {
                this.a.a(MessageDto.Status.SENDING_FAILED);
            }
        } else {
            this.a.a(MessageDto.Status.UNSENT);
        }
    }

    public boolean isRead() {
        Object object = object.a.q();
        return object != MessageDto.Status.UNREAD && object != MessageDto.Status.NOTIFICATION_SHOWN;
    }

    public Map<String, Object> getMetadata() {
        return this.a.l();
    }

    public void setMetadata(Map<String, Object> map) {
        this.a.a(map);
    }

    public String getPayload() {
        return this.a.m();
    }

    public void setPayload(String string2) {
        this.a.f(string2);
    }

    public String getMediaUrl() {
        return this.a.i();
    }

    public void setMediaUrl(String string2) {
        this.a.e(string2);
    }

    public String getMediaType() {
        return this.a.h();
    }

    public void setMediaType(String string2) {
        this.a.d(string2);
    }

    public long getMediaSize() {
        return this.a.g();
    }

    public void setMediaSize(long l2) {
        this.a.a(l2);
    }

    public String getId() {
        return this.a.f();
    }

    public void setImage(Bitmap bitmap) {
        this.d = bitmap;
    }

    public void setFile(File file) {
        this.e = file;
    }

    public Bitmap getImage() {
        return this.d;
    }

    public File getFile() {
        return this.e;
    }

    public String getTextFallback() {
        return this.a.s();
    }

    public void setTextFallback(String string2) {
        this.a.i(string2);
    }

    public boolean equals(Object object) {
        if (comparable == object) {
            return true;
        }
        if (object != null && Message.class == object.getClass()) {
            Message message = comparable;
            Comparable<Message> comparable = (Message)object;
            object = message.a;
            comparable = comparable.a;
            return object == comparable || ((MessageDto)object).equals(comparable);
        }
        return false;
    }

    public int hashCode() {
        Comparable<Message> comparable = ((Message)comparable).a;
        return comparable != null ? ((MessageDto)comparable).hashCode() : 0;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public MessageDto getEntity() {
        return this.a;
    }

    public String getType() {
        if (this.a.t() == null) {
            if (this.d != null) {
                return MessageType.IMAGE.getValue();
            }
            if (this.e != null) {
                return MessageType.FILE.getValue();
            }
            if (this.a.i() != null && !this.a.i().isEmpty()) {
                if (this.a.h() != null && this.a.h().startsWith("image")) {
                    return MessageType.IMAGE.getValue();
                }
                return MessageType.FILE.getValue();
            }
            return MessageType.TEXT.getValue();
        }
        return this.a.t();
    }

    public void setType(String string2) {
        this.a.j(string2);
    }

    public boolean hasReplies() {
        if (!((Message)((Object)iterator)).b.isEmpty()) {
            Iterator<MessageAction> iterator = ((Message)((Object)iterator)).b.iterator();
            while (iterator.hasNext()) {
                if (!((MessageAction)iterator.next()).getType().equals("reply")) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasLocationRequest() {
        if (!((Message)((Object)iterator)).b.isEmpty()) {
            Iterator<MessageAction> iterator = ((Message)((Object)iterator)).b.iterator();
            while (iterator.hasNext()) {
                if (!((MessageAction)iterator.next()).getType().equals("locationRequest")) continue;
                return true;
            }
        }
        return false;
    }

    public Coordinates getCoordinates() {
        return new Coordinates(this.a.b());
    }

    public void setCoordinates(Coordinates coordinates) {
        this.a.a(coordinates.a());
    }

    public DisplaySettings getDisplaySettings() {
        return new DisplaySettings(this.a.e());
    }

    public void setDisplaySettings(DisplaySettings displaySettings) {
        this.a.a(displaySettings.a());
    }

    public boolean hasValidCoordinates() {
        Serializable serializable = ((Message)serializable).a.b();
        return ((CoordinatesDto)serializable).a() != null && ((CoordinatesDto)serializable).b() != null;
    }

    @Override
    public int compareTo(@NonNull Message comparable) {
        Comparable<Message> comparable2 = ((Message)comparable2).a;
        if (comparable2 == null && comparable.a == null) {
            return 0;
        }
        if (comparable2 == null) {
            return -1;
        }
        comparable = comparable.a;
        if (comparable == null) {
            return 1;
        }
        return ((MessageDto)comparable2).a((MessageDto)comparable);
    }
}

