/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.features.common;

import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import androidx.annotation.Nullable;
import com.avaya.core.Config;
import com.avaya.core.Conversation;
import com.avaya.core.Message;
import com.avaya.core.MessageType;
import com.avaya.core.utils.StringUtils;
import com.avaya.features.common.AvatarData;
import com.avaya.ui.R;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.RequestManager;
import com.bumptech.glide.TransitionOptions;
import com.bumptech.glide.load.resource.drawable.DrawableTransitionOptions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public final class ConversationUtils {
    private ConversationUtils() {
    }

    public static String getTitle(@Nullable Conversation conversation, @Nullable Config object) {
        object = ConversationUtils.getAppName(object);
        if (conversation == null) {
            return object;
        }
        if (conversation.getDisplayName() != null) {
            object = conversation.getDisplayName();
        }
        return object;
    }

    private static String getAppName(@Nullable Config config) {
        return config != null ? config.getAppName() : StringUtils.emptyIfNull(null);
    }

    public static String getSubTitle(Conversation conversation) {
        if (conversation.getDescription() != null) {
            return conversation.getDescription();
        }
        return null;
    }

    public static RequestBuilder<Drawable> addAvatarDataToGlide(AvatarData avatarData, RequestManager requestManager) {
        if (avatarData.conversationUrl != null) {
            return ((RequestBuilder)((RequestBuilder)((RequestBuilder)requestManager.asDrawable().load(avatarData.conversationUrl).placeholder(avatarData.fallbackResource)).error(avatarData.fallbackResource)).circleCrop()).transition((TransitionOptions)DrawableTransitionOptions.withCrossFade());
        }
        if (avatarData.brandUrl != null) {
            return ((RequestBuilder)((RequestBuilder)((RequestBuilder)requestManager.asDrawable().load(avatarData.brandUrl).placeholder(avatarData.fallbackResource)).error(avatarData.fallbackResource)).circleCrop()).transition((TransitionOptions)DrawableTransitionOptions.withCrossFade());
        }
        return ((RequestBuilder)((RequestBuilder)requestManager.asDrawable().load(Integer.valueOf(avatarData.fallbackResource)).placeholder(avatarData.fallbackResource)).circleCrop()).transition((TransitionOptions)DrawableTransitionOptions.withCrossFade());
    }

    public static String getLastMessage(Conversation conversation, Resources objectArray) {
        String string2;
        MessageType messageType;
        String string3 = "";
        MessageType messageType2 = messageType;
        Collections.sort(new ArrayList(conversation.getMessages()), new Comparator<Message>(){

            public int a(Message message, Message message2) {
                if (message == null) {
                    return -1;
                }
                return message.compareTo(message2) * -1;
            }
        });
        if (messageType2.isEmpty()) {
            return objectArray.getString(R.string.AvMessagingSdk_conversationListLastNoMessages);
        }
        conversation = (Message)messageType2.get(0);
        if (conversation.isFromCurrentUser()) {
            string3 = objectArray.getString(R.string.AvMessagingSdk_conversationListLastSentByCurrentUser);
        } else if (conversation.getName() != null && !StringUtils.isEmpty((String)conversation.getName())) {
            string3 = conversation.getName();
        }
        messageType2 = MessageType.findByValue((String)conversation.getType());
        if (messageType2 == null) {
            Object[] objectArray2 = objectArray;
            int n2 = R.string.AvMessagingSdk_conversationListLastMessageDefault;
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = string3;
            string2 = objectArray2.getString(n2, objectArray);
        } else {
            switch (b.a[messageType2.ordinal()]) {
                default: {
                    Object[] objectArray4 = objectArray;
                    int n3 = R.string.AvMessagingSdk_conversationListLastMessageDefault;
                    Object[] objectArray5 = new Object[1];
                    objectArray = objectArray5;
                    objectArray5[0] = string3;
                    string2 = objectArray4.getString(n3, objectArray);
                    break;
                }
                case 4: {
                    Object[] objectArray6 = objectArray;
                    int n4 = R.string.AvMessagingSdk_conversationListLastMessageForm;
                    Object[] objectArray7 = new Object[1];
                    objectArray = objectArray7;
                    objectArray7[0] = string3;
                    string2 = objectArray6.getString(n4, objectArray);
                    break;
                }
                case 3: {
                    Object[] objectArray8 = objectArray;
                    int n5 = R.string.AvMessagingSdk_conversationListLastMessageFile;
                    Object[] objectArray9 = new Object[1];
                    objectArray = objectArray9;
                    objectArray9[0] = string3;
                    string2 = objectArray8.getString(n5, objectArray);
                    break;
                }
                case 2: {
                    Object[] objectArray10 = objectArray;
                    int n6 = R.string.AvMessagingSdk_conversationListLastMessageImage;
                    Object[] objectArray11 = new Object[1];
                    objectArray = objectArray11;
                    objectArray11[0] = string3;
                    string2 = objectArray10.getString(n6, objectArray);
                    break;
                }
                case 1: {
                    if (!StringUtils.isEmpty((String)string3)) {
                        string3 = string3 + ": ";
                    }
                    string2 = string3 + conversation.getText();
                }
            }
        }
        return string2;
    }
}

