/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.features.conversationlist;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import androidx.annotation.Nullable;
import androidx.appcompat.widget.AppCompatTextView;
import com.avaya.ui.utils.DateTimeUtils;
import java.util.concurrent.TimeUnit;

public class ConversationListDateView
extends AppCompatTextView {
    private static long MINUTE_IN_MILLIS = TimeUnit.MINUTES.toMillis(1L);
    private static long NO_VALUE = -1L;
    private long date = NO_VALUE;
    private Handler handler = new Handler(Looper.getMainLooper());
    private Runnable runnable = new Runnable(){

        @Override
        public void run() {
            a a2 = this;
            ConversationListDateView conversationListDateView = a2.ConversationListDateView.this;
            conversationListDateView.setText(DateTimeUtils.getRelativeTimestampLongText(conversationListDateView.date, ConversationListDateView.this.getResources()));
            a2.ConversationListDateView.this.handler.postDelayed((Runnable)this, MINUTE_IN_MILLIS);
        }
    };

    public ConversationListDateView(Context context) {
        super(context);
    }

    public ConversationListDateView(Context context, @Nullable AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public ConversationListDateView(Context context, @Nullable AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
    }

    private void startTimer() {
        this.handler.postDelayed(this.runnable, MINUTE_IN_MILLIS);
    }

    private void stopTimer() {
        this.handler.removeCallbacks(this.runnable);
    }

    protected void onAttachedToWindow() {
        ConversationListDateView conversationListDateView = this;
        super.onAttachedToWindow();
        if (conversationListDateView.date != NO_VALUE) {
            this.startTimer();
        }
    }

    protected void onDetachedFromWindow() {
        ConversationListDateView conversationListDateView = this;
        super.onDetachedFromWindow();
        conversationListDateView.stopTimer();
    }

    public void setDate(Long l2) {
        if (l2 != null && l2 != NO_VALUE) {
            this.date = l2;
            this.startTimer();
            this.setText(DateTimeUtils.getRelativeTimestampLongText(l2, this.getResources()));
        } else {
            this.date = NO_VALUE;
            this.stopTimer();
        }
    }
}

