/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ui;

import android.app.Activity;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.text.TextUtils;
import android.util.Log;
import androidx.core.app.NotificationCompat;
import androidx.core.content.ContextCompat;
import com.avaya.core.Message;
import com.avaya.core.MessageAction;
import com.avaya.ui.NotificationActivity;
import com.avaya.ui.R;
import com.avaya.ui.fragment.ConversationFragment;
import com.avaya.ui.utils.ApplicationInfo;
import com.avaya.ui.utils.BitmapVisitor;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestOptions;

public class NotificationController {
    private static String TAG = "NotificationController";
    private static final Handler handler;
    private static final HandlerThread handlerThread;

    static Intent loadActivityIntent(Context object, String string2, String string3, Class objectArray) {
        Intent intent;
        Object[] objectArray2;
        try {
            objectArray2 = Class.forName(string3);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Object[] objectArray3 = new Object[2];
            objectArray2 = objectArray3;
            objectArray3[0] = string3;
            objectArray3[1] = objectArray;
            Log.e((String)TAG, (String)String.format("Unable to find specified intent: %s\nDefaulting to %s", objectArray2));
            objectArray2 = objectArray;
        }
        if (!Activity.class.isAssignableFrom((Class<?>)objectArray2)) {
            Object[] objectArray4 = new Object[2];
            objectArray2 = objectArray4;
            objectArray4[0] = string3;
            objectArray4[1] = objectArray;
            Log.e((String)TAG, (String)String.format("Specified intent is not an activity: %s\nDefaulting to %s", objectArray2));
        } else {
            objectArray = objectArray2;
        }
        string3 = intent;
        Context context = object;
        Context context2 = object;
        string3(object, (Class)objectArray);
        object = context2.getString(R.string.AvMessagingSdk_settings_notificationTriggerKey);
        string3.putExtra((String)object, context2.getString(R.string.AvMessagingSdk_settings_notificationTrigger));
        intent.putExtra(context.getString(R.string.AvMessagingSdk_settings_conversationIdKey), string2);
        intent.setFlags(0x10000000);
        return intent;
    }

    public static void triggerNotification(final Context context, final String string2, final Message message) {
        if (context != null && message != null) {
            handler.post(new Runnable(){

                @Override
                public void run() {
                    NotificationCompat.Builder builder;
                    a a2 = a5;
                    Message message3 = a2.message.copy();
                    Resources resources = a2.context.getResources();
                    int n2 = resources.getDimensionPixelSize(R.dimen.AvMessagingSdk_messageAvatar);
                    Bitmap bitmap = BitmapVisitor.createRoundedBitmap(BitmapFactory.decodeResource((Resources)resources, (int)R.drawable.avmessagingsdk_img_avatar), n2);
                    try {
                        int n3 = n2;
                        bitmap = (Bitmap)Glide.with((Context)a2.context.getApplicationContext()).asBitmap().apply((BaseRequestOptions)RequestOptions.circleCropTransform()).load(a5.message.getAvatarUrl()).submit(n3, n3).get();
                    }
                    catch (Exception exception) {
                        Log.e((String)TAG, (String)("Failed to load avatar for push notification.\nAvatar URL: " + a5.message.getAvatarUrl() + "\nError: " + exception.getMessage()));
                    }
                    a a3 = a5;
                    NotificationManager notificationManager = (NotificationManager)a3.context.getSystemService("notification");
                    String string22 = a3.context.getString(R.string.AvMessagingSdk_settings_notificationChannelId);
                    String string3 = a3.context.getString(R.string.AvMessagingSdk_settings_notificationChannelName);
                    if (Build.VERSION.SDK_INT >= 26) {
                        NotificationChannel notificationChannel;
                        NotificationChannel notificationChannel2 = notificationChannel;
                        notificationChannel = new NotificationChannel(string22, (CharSequence)string3, 4);
                        notificationManager.createNotificationChannel(notificationChannel2);
                    }
                    Message message2 = message3;
                    a a4 = a5;
                    string3 = builder;
                    builder = new NotificationCompat.Builder(a5.context, string22);
                    string22 = a4.context.getString(R.string.AvMessagingSdk_settings_beforeNotificationIntent);
                    string22 = NotificationController.loadActivityIntent(a4.context, a5.string2, string22, NotificationActivity.class);
                    int n4 = a4.context.getResources().getInteger(R.integer.AvMessagingSdk_settings_notificationId);
                    String string4 = a5.context.getString(R.string.AvMessagingSdk_settings_notificationTag) + "." + a5.string2;
                    int n5 = ConversationFragment.incrementPendingNotifications();
                    String string5 = message2.getText();
                    if (message2.getText().trim().isEmpty() && message3.getMessageActions().size() > 0) {
                        string5 = ((MessageAction)message3.getMessageActions().get(0)).getText();
                    }
                    if (TextUtils.isEmpty((CharSequence)string5)) {
                        string5 = a5.context.getString(R.string.AvMessagingSdk_notificationFallbackText);
                    }
                    string3.setAutoCancel(true);
                    string3.setContentIntent(PendingIntent.getActivity((Context)a5.context, (int)0, (Intent)string22, (int)0xC000000));
                    string22 = message3.getName() != null && !message3.getName().isEmpty() ? message3.getName() : ApplicationInfo.getName(a5.context);
                    String string6 = string3;
                    String string7 = string3;
                    String string8 = string3;
                    string3.setContentTitle((CharSequence)string22);
                    string8.setContentText((CharSequence)string5);
                    string8.setDefaults(-1);
                    string7.setLargeIcon(bitmap);
                    string7.setSmallIcon(R.drawable.avmessagingsdk_ic_notification);
                    string6.setColor(ContextCompat.getColor((Context)a5.context, (int)R.color.AvMessagingSdk_notificationColor));
                    string6.setStyle((NotificationCompat.Style)new NotificationCompat.BigTextStyle().bigText((CharSequence)string5));
                    if (n5 > 1) {
                        string3.setNumber(n5);
                    }
                    string3.setPriority(1);
                    if (message3.getDate() != null) {
                        string3.setWhen(message3.getDate().getTime());
                    }
                    a a5 = string3.build();
                    notificationManager.notify(string4, n4, (Notification)a5);
                }
            });
            return;
        }
        Log.e((String)TAG, (String)"Tried to trigger notification with null context or message. Ignoring.");
    }

    static {
        HandlerThread handlerThread;
        HandlerThread handlerThread2 = handlerThread;
        NotificationController.handlerThread = new HandlerThread("NotificationControllerThread");
        handlerThread2.start();
        handler = new Handler(handlerThread2.getLooper());
    }
}

