/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ui.widget;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.RectF;
import android.os.Build;
import android.util.AttributeSet;
import androidx.appcompat.widget.AppCompatImageView;
import com.avaya.ui.R;

public class AvMessagingSdkImageView
extends AppCompatImageView {
    public static final int ROUNDED_CORNER_NONE = 1;
    public static final int ROUNDED_CORNER_TOP_RIGHT = 2;
    public static final int ROUNDED_CORNER_TOP_LEFT = 4;
    public static final int ROUNDED_CORNER_BOTTOM_RIGHT = 8;
    public static final int ROUNDED_CORNER_BOTTOM_LEFT = 16;
    private final Resources resources;
    private final float messageRadius;
    private final float messageCornerRadius;
    private final Path clipPath;
    private final RectF rect;
    private boolean doClip;
    private int roundedCorners;
    private float[] radii;

    public AvMessagingSdkImageView(Context context) {
        AvMessagingSdkImageView avMessagingSdkImageView = this;
        super(context);
        context = avMessagingSdkImageView.getContext().getResources();
        this.resources = context;
        this.messageRadius = context.getDimensionPixelSize(R.dimen.AvMessagingSdk_messageRadius);
        avMessagingSdkImageView.messageCornerRadius = context.getDimensionPixelSize(R.dimen.AvMessagingSdk_messageCornerRadius);
        avMessagingSdkImageView.clipPath = new Path();
        avMessagingSdkImageView.rect = new RectF();
        avMessagingSdkImageView.doClip = true;
        avMessagingSdkImageView.roundedCorners = 1;
        if (Build.VERSION.SDK_INT < 18) {
            this.setLayerType(1, null);
        }
        this.setId(R.id.avmessagingsdk_image_view_id);
    }

    public AvMessagingSdkImageView(Context context, AttributeSet attributeSet) {
        AvMessagingSdkImageView avMessagingSdkImageView = this;
        super(context, attributeSet);
        context = avMessagingSdkImageView.getContext().getResources();
        this.resources = context;
        this.messageRadius = context.getDimensionPixelSize(R.dimen.AvMessagingSdk_messageRadius);
        avMessagingSdkImageView.messageCornerRadius = context.getDimensionPixelSize(R.dimen.AvMessagingSdk_messageCornerRadius);
        avMessagingSdkImageView.clipPath = new Path();
        avMessagingSdkImageView.rect = new RectF();
        avMessagingSdkImageView.doClip = true;
        avMessagingSdkImageView.roundedCorners = 1;
    }

    public AvMessagingSdkImageView(Context context, AttributeSet attributeSet, int n2) {
        AvMessagingSdkImageView avMessagingSdkImageView = this;
        super(context, attributeSet, n2);
        context = avMessagingSdkImageView.getContext().getResources();
        this.resources = context;
        this.messageRadius = context.getDimensionPixelSize(R.dimen.AvMessagingSdk_messageRadius);
        avMessagingSdkImageView.messageCornerRadius = context.getDimensionPixelSize(R.dimen.AvMessagingSdk_messageCornerRadius);
        avMessagingSdkImageView.clipPath = new Path();
        avMessagingSdkImageView.rect = new RectF();
        avMessagingSdkImageView.doClip = true;
        avMessagingSdkImageView.roundedCorners = 1;
    }

    private void updateRadii() {
        int n2 = object.roundedCorners;
        float f2 = (n2 & 4) > 0 ? object.messageRadius : object.messageCornerRadius;
        float f3 = (n2 & 2) > 0 ? object.messageRadius : object.messageCornerRadius;
        float f4 = (n2 & 8) > 0 ? object.messageRadius : object.messageCornerRadius;
        float f5 = (n2 & 0x10) > 0 ? object.messageRadius : object.messageCornerRadius;
        AvMessagingSdkImageView avMessagingSdkImageView = object;
        float[] fArray = new float[8];
        Object object = fArray;
        fArray[0] = f2;
        fArray[1] = f2;
        fArray[2] = f3;
        fArray[3] = f3;
        fArray[4] = f4;
        fArray[5] = f4;
        fArray[6] = f5;
        fArray[7] = f5;
        avMessagingSdkImageView.radii = (float[])object;
    }

    public void setRoundedCorners(int n2) {
        this.roundedCorners = n2;
        this.updateRadii();
    }

    protected void onDraw(Canvas canvas) {
        if (this.radii == null) {
            this.updateRadii();
        }
        AvMessagingSdkImageView avMessagingSdkImageView = this;
        AvMessagingSdkImageView avMessagingSdkImageView2 = this;
        float f2 = avMessagingSdkImageView2.getWidth();
        float f3 = avMessagingSdkImageView2.getHeight();
        avMessagingSdkImageView.rect.set(0.0f, 0.0f, f2, f3);
        avMessagingSdkImageView.clipPath.reset();
        AvMessagingSdkImageView avMessagingSdkImageView3 = this;
        RectF rectF = avMessagingSdkImageView3.rect;
        float[] fArray = avMessagingSdkImageView3.radii;
        avMessagingSdkImageView.clipPath.addRoundRect(rectF, fArray, Path.Direction.CW);
        if (avMessagingSdkImageView.doClip) {
            try {
                canvas.clipPath(this.clipPath);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                this.doClip = false;
            }
        }
        super.onDraw(canvas);
    }
}

