/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ui.widget;

import android.graphics.Bitmap;
import android.graphics.PorterDuff;
import android.os.Bundle;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.FragmentActivity;
import com.avaya.ui.R;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.davemorrissey.labs.subscaleview.ImageSource;
import com.davemorrissey.labs.subscaleview.SubsamplingScaleImageView;
import java.io.File;

public class ImageActivity
extends AppCompatActivity
implements SubsamplingScaleImageView.OnImageEventListener {
    public static final String MEDIA_URL = "MEDIA_URL";
    private static final String IMAGE_FORMAT_NOT_SUPPORTED = "Image format not supported";
    private static final String GIF_FAILED_TO_LOAD = "Image failed to decode using GIF decoder";
    private String mediaUrl;
    private TextView errorView;
    private ProgressBar loadingSpinner;
    private SubsamplingScaleImageView imageView;

    protected void onCreate(Bundle bundle) {
        ImageActivity imageActivity = this;
        super.onCreate(bundle);
        imageActivity.setContentView(R.layout.avmessagingsdk_activity_image);
        bundle = (SubsamplingScaleImageView)imageActivity.findViewById(R.id.imageView);
        this.imageView = bundle;
        bundle.setOnImageEventListener((SubsamplingScaleImageView.OnImageEventListener)this);
        bundle = (ProgressBar)imageActivity.findViewById(R.id.imageLoadingSpinner);
        imageActivity.loadingSpinner = bundle;
        bundle.getIndeterminateDrawable().setColorFilter(-1, PorterDuff.Mode.SRC_IN);
        imageActivity.errorView = (TextView)imageActivity.findViewById(R.id.imageDisplayError);
        imageActivity.mediaUrl = imageActivity.getIntent().getExtras().getString(MEDIA_URL);
        Glide.with((FragmentActivity)imageActivity).downloadOnly().load(this.mediaUrl).into((Target)new SimpleTarget<File>(){

            public void a(@NonNull File file, @Nullable Transition<? super File> transition) {
                ImageActivity.this.imageView.setImage(ImageSource.uri((String)file.getAbsolutePath()));
            }
        });
    }

    public void onReady() {
    }

    public void onImageLoaded() {
        this.loadingSpinner.setVisibility(8);
    }

    public void onPreviewLoadError(Exception exception) {
    }

    public void onImageLoadError(Exception exception) {
        int n2 = this.getResources().getDimensionPixelSize(R.dimen.AvMessagingSdk_imageMaxSize);
        if (!IMAGE_FORMAT_NOT_SUPPORTED.equals(exception.getMessage()) && !GIF_FAILED_TO_LOAD.equals(exception.getMessage())) {
            ImageActivity imageActivity = this;
            imageActivity.errorView.setVisibility(0);
            imageActivity.loadingSpinner.setVisibility(8);
        } else {
            int n3 = n2;
            Glide.with((FragmentActivity)this).asBitmap().load(this.mediaUrl).into((Target)new SimpleTarget<Bitmap>(n3, n3){

                public void a(@NonNull Bitmap bitmap, @Nullable Transition<? super Bitmap> transition) {
                    ImageActivity.this.imageView.setImage(ImageSource.bitmap((Bitmap)bitmap));
                }
            });
        }
    }

    public void onTileLoadError(Exception exception) {
    }

    public void onPreviewReleased() {
    }
}

