/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ui.fragment;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Point;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Looper;
import android.text.SpannableString;
import android.text.style.ForegroundColorSpan;
import android.text.style.RelativeSizeSpan;
import android.view.Display;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.appcompat.widget.AppCompatButton;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import com.avaya.com.devmarvel.creditcardentry.library.CreditCardForm;
import com.avaya.com.devmarvel.creditcardentry.library.b;
import com.avaya.com.devmarvel.creditcardentry.library.c;
import com.avaya.core.ActionState;
import com.avaya.core.AvMessagingSdk;
import com.avaya.core.CardSummary;
import com.avaya.core.Conversation;
import com.avaya.core.CreditCard;
import com.avaya.core.MessageAction;
import com.avaya.core.PaymentStatus;
import com.avaya.core.User;
import com.avaya.ui.R;
import com.avaya.ui.drawable.CheckMarkDrawable;
import com.avaya.ui.drawable.CloseButtonDrawable;
import com.avaya.ui.utils.ResizeAnimation;
import com.avaya.ui.utils.SuperscriptSpanAdjuster;
import java.util.Timer;
import java.util.TimerTask;

public class StripeFragment
extends Fragment
implements b,
View.OnClickListener {
    private final Conversation conversation = AvMessagingSdk.getConversation();
    private long cents;
    private long dollars;
    private boolean waitingForCardLoad = false;
    private boolean changeCardClicked = false;
    private boolean paymentRequestTimedOut = false;
    private String currency;
    private Bundle arguments;
    private Button buyButton;
    private Button closeButton;
    private ProgressBar payNowSpinner;
    private ProgressBar loadingSpinner;
    private TextView dollarAmount;
    private TextView errorMessage;
    private TextView savedFormText;
    private TextView creditMessage;
    private TextView savedCreditMessage;
    private Button changeCardButton;
    private ImageView savedFormImage;
    private MessageAction messageAction;
    private LinearLayout savedCardForm;
    private CreditCardForm creditCardForm;
    private StripeFragmentListener fragmentListener;
    private CardSummary savedCard;
    private Timer processPaymentTimeout;

    private void setup() {
        ColorStateList colorStateList;
        String string2 = this.cents < 10L ? "0" + this.cents : "" + this.cents;
        Object object = new StringBuilder().append("$").append(this.dollars);
        CharSequence charSequence = this.cents == 0L ? "" : string2;
        object = ((StringBuilder)object).append((String)charSequence).toString();
        charSequence = new StringBuilder().append("$").append(this.dollars);
        string2 = this.cents == 0L ? "" : "." + string2;
        StripeFragment stripeFragment = this;
        StripeFragment stripeFragment2 = this;
        string2 = ((StringBuilder)charSequence).append(string2).append(" ").append(this.currency).toString();
        stripeFragment2.fragmentListener.onStripeFragmentShown();
        stripeFragment2.setupSpinner();
        stripeFragment2.setupCloseButton();
        stripeFragment.setupPriceDisplay((String)object);
        stripeFragment.setupCreditMessage(string2);
        stripeFragment.buyButton.setOnClickListener((View.OnClickListener)this);
        stripeFragment.changeCardButton.setOnClickListener((View.OnClickListener)this);
        string2 = colorStateList;
        int[] nArray = new int[1];
        object = nArray;
        nArray[0] = this.getResources().getColor(R.color.AvMessagingSdk_accent);
        colorStateList = new ColorStateList((int[][])new int[][]{new int[0]}, (int[])object);
        ((AppCompatButton)stripeFragment.buyButton).setSupportBackgroundTintList((ColorStateList)string2);
        stripeFragment.creditCardForm.setOnCardValidCallback(this);
    }

    private void showSavedCreditCardView(View view, CardSummary cardSummary) {
        Drawable drawable2 = objectArray3.getBrandDrawableFromString(cardSummary.getBrand());
        objectArray3.clearUI();
        objectArray3.buyButton.setVisibility(0);
        objectArray3.dollarAmount.setVisibility(0);
        objectArray3.savedCardForm.setVisibility(0);
        objectArray3.changeCardButton.setVisibility(0);
        objectArray3.savedCreditMessage.setVisibility(0);
        if (Build.VERSION.SDK_INT >= 16) {
            objectArray3.savedFormImage.setBackground(drawable2);
        } else {
            objectArray3.savedFormImage.setBackgroundDrawable(drawable2);
        }
        Object[] objectArray = objectArray3;
        Object[] objectArray2 = new Object[1];
        Object[] objectArray3 = objectArray2;
        objectArray2[0] = cardSummary.getLast4();
        objectArray3.savedFormText.setText((CharSequence)String.format("\u2022 \u2022 \u2022 \u2022  \u2022 \u2022 \u2022 \u2022  \u2022 \u2022 \u2022 \u2022  %s", objectArray3));
        super.resizeView(view);
    }

    private void showEnterCreditCardView(View view, boolean bl) {
        this.clearUI();
        if (bl) {
            StripeFragment stripeFragment = this;
            Display display = this.getActivity().getWindowManager().getDefaultDisplay();
            Point point = new Point();
            display.getSize(point);
            int n2 = point.y;
            ResizeAnimation resizeAnimation = new ResizeAnimation(view, n2, this.getResources().getDimensionPixelSize(R.dimen.AvMessagingSdk_stripeSavedCardHeight));
            resizeAnimation.setDuration(700L);
            resizeAnimation.setInterpolator((Context)this.getActivity(), 17432582);
            view.startAnimation((Animation)resizeAnimation);
            stripeFragment.buyButton.setVisibility(0);
            stripeFragment.buyButton.setTranslationY(0.0f);
            stripeFragment.buyButton.animate().translationY((float)this.buyButton.getHeight());
        }
        StripeFragment stripeFragment = this;
        stripeFragment.creditCardForm.setVisibility(0);
        stripeFragment.creditMessage.setVisibility(0);
        stripeFragment.dollarAmount.setVisibility(0);
        stripeFragment.focusCard();
    }

    private void showLoadingView(View view) {
        StripeFragment stripeFragment = this;
        stripeFragment.clearUI();
        stripeFragment.loadingSpinner.setVisibility(0);
        stripeFragment.changeCardButton.setVisibility(0);
        this.resizeView(view);
        this.waitingForCardLoad = true;
    }

    private void showCorrectView(View view) {
        if (this.changeCardClicked) {
            this.showEnterCreditCardView(view, false);
            return;
        }
        CardSummary cardSummary = this.savedCard;
        if (cardSummary != null) {
            this.showSavedCreditCardView(view, cardSummary);
        } else if (User.getCurrentUser().hasPaymentInfo() && (cardSummary = this.conversation) != null) {
            cardSummary.loadCardSummary();
            this.showLoadingView(view);
        } else {
            this.showEnterCreditCardView(view, false);
        }
    }

    private void setupCloseButton() {
        CloseButtonDrawable closeButtonDrawable;
        CloseButtonDrawable closeButtonDrawable2 = closeButtonDrawable;
        closeButtonDrawable = new CloseButtonDrawable((Context)this.getActivity());
        if (Build.VERSION.SDK_INT >= 16) {
            this.closeButton.setBackground((Drawable)closeButtonDrawable2);
        } else {
            this.closeButton.setBackgroundDrawable((Drawable)closeButtonDrawable2);
        }
        this.closeButton.setOnClickListener((View.OnClickListener)this);
    }

    private void setupSpinner() {
        StripeFragment stripeFragment = this;
        stripeFragment.payNowSpinner.getIndeterminateDrawable().setColorFilter(-1, PorterDuff.Mode.SRC_IN);
        stripeFragment.loadingSpinner.getIndeterminateDrawable().setColorFilter(this.getResources().getColor(R.color.AvMessagingSdk_accent), PorterDuff.Mode.SRC_IN);
    }

    private void setupCreditMessage(String string2) {
        ForegroundColorSpan foregroundColorSpan;
        ForegroundColorSpan foregroundColorSpan2;
        SpannableString spannableString;
        SpannableString spannableString2;
        StripeFragment stripeFragment = object;
        Object object = stripeFragment.getActivity().getApplicationContext();
        object = object.getPackageManager().getApplicationLabel(object.getApplicationInfo());
        String string3 = stripeFragment.getResources().getString(R.string.AvMessagingSdk_creditMessage, new Object[]{string2, object});
        object = stripeFragment.getResources().getString(R.string.AvMessagingSdk_savedCreditMessage, new Object[]{string2, object});
        SpannableString spannableString3 = spannableString2;
        spannableString2 = new SpannableString((CharSequence)string3);
        SpannableString spannableString4 = spannableString;
        Object object2 = object;
        Object object3 = object;
        spannableString4((CharSequence)object);
        object = foregroundColorSpan2;
        foregroundColorSpan2 = new ForegroundColorSpan(-16777216);
        int n2 = string3.indexOf(string2);
        int n3 = string3.indexOf(string2) + string2.length();
        spannableString3.setSpan(object, n2, n3, 33);
        object = foregroundColorSpan;
        foregroundColorSpan = new ForegroundColorSpan(-16777216);
        n2 = ((String)object3).indexOf(string2);
        int n4 = ((String)object2).indexOf(string2) + string2.length();
        spannableString.setSpan(object, n2, n4, 33);
        stripeFragment.creditMessage.setText((CharSequence)spannableString3);
        stripeFragment.savedCreditMessage.setText((CharSequence)spannableString4);
    }

    private void resizeView(View view) {
        view.getLayoutParams().height = this.getResources().getDimensionPixelSize(R.dimen.AvMessagingSdk_stripeSavedCardHeight);
    }

    private void showErrorMessage() {
        StripeFragment stripeFragment = this;
        stripeFragment.creditMessage.setVisibility(8);
        stripeFragment.errorMessage.setVisibility(0);
    }

    private void hideErrorMessage() {
        if (this.errorMessage.getVisibility() == 0) {
            StripeFragment stripeFragment = this;
            stripeFragment.creditMessage.setVisibility(0);
            stripeFragment.errorMessage.setVisibility(8);
        }
    }

    private void setupPriceDisplay(String object) {
        SpannableString spannableString;
        SpannableString spannableString2 = spannableString;
        new SpannableString((CharSequence)object).setSpan((Object)new RelativeSizeSpan(0.45f), 0, 1, 33);
        spannableString2.setSpan((Object)new SuperscriptSpanAdjuster(0.82f), 0, 1, 33);
        if (this.cents > 0L) {
            SuperscriptSpanAdjuster superscriptSpanAdjuster;
            RelativeSizeSpan relativeSizeSpan;
            String string2 = object;
            String string3 = object;
            object = relativeSizeSpan;
            relativeSizeSpan = new RelativeSizeSpan(0.6f);
            int n2 = string3.length() - 2;
            int n3 = string3.length();
            spannableString2.setSpan(object, n2, n3, 33);
            object = superscriptSpanAdjuster;
            superscriptSpanAdjuster = new SuperscriptSpanAdjuster(0.48f);
            n2 = string2.length() - 2;
            n3 = string2.length();
            spannableString2.setSpan(object, n2, n3, 33);
        }
        this.dollarAmount.setText((CharSequence)spannableString2);
    }

    private void clearUI() {
        StripeFragment stripeFragment = this;
        stripeFragment.creditCardForm.setVisibility(8);
        stripeFragment.creditMessage.setVisibility(8);
        stripeFragment.savedCardForm.setVisibility(8);
        stripeFragment.savedCreditMessage.setVisibility(8);
        stripeFragment.dollarAmount.setVisibility(8);
        stripeFragment.changeCardButton.setVisibility(8);
        stripeFragment.loadingSpinner.setVisibility(8);
        stripeFragment.buyButton.setVisibility(8);
    }

    private Drawable getBrandDrawableFromString(String string2) {
        return (string2 = string2.toLowerCase()).equals("visa") ? ContextCompat.getDrawable((Context)this.getActivity(), (int)R.drawable.visa) : (string2.equals("american express") ? ContextCompat.getDrawable((Context)this.getActivity(), (int)R.drawable.amex) : (string2.equals("mastercard") ? ContextCompat.getDrawable((Context)this.getActivity(), (int)R.drawable.master_card) : (string2.equals("discover") ? ContextCompat.getDrawable((Context)this.getActivity(), (int)R.drawable.discover) : (string2.equals("diners club") ? ContextCompat.getDrawable((Context)this.getActivity(), (int)R.drawable.diners_club) : ContextCompat.getDrawable((Context)this.getActivity(), (int)R.drawable.unknown_cc)))));
    }

    private void focusCard() {
        InputMethodManager inputMethodManager = (InputMethodManager)this.getActivity().getSystemService("input_method");
        this.creditCardForm.a();
        inputMethodManager.toggleSoftInput(1, 1);
    }

    private void startProcessPaymentTimeout() {
        TimerTask timerTask;
        Timer timer;
        Object object = timer;
        ((Timer)object)();
        this.processPaymentTimeout = object;
        object = timerTask;
        timerTask = new TimerTask(){

            @Override
            public void run() {
                if (Looper.getMainLooper().getThread() == Thread.currentThread()) {
                    StripeFragment.this.onPaymentProcessed(PaymentStatus.ERROR);
                } else {
                    StripeFragment.access$002(StripeFragment.this, true);
                }
            }
        };
        timer.schedule((TimerTask)object, 10000L);
    }

    static /* synthetic */ boolean access$002(StripeFragment stripeFragment, boolean bl) {
        stripeFragment.paymentRequestTimedOut = bl;
        return bl;
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup object, Bundle bundle) {
        StripeFragment stripeFragment = this;
        layoutInflater = layoutInflater.inflate(R.layout.avmessagingsdk_fragment_stripe, object, false);
        StripeFragment stripeFragment2 = this;
        super.onCreate(bundle);
        try {
            stripeFragment2.fragmentListener = (StripeFragmentListener)stripeFragment2.getActivity();
        }
        catch (ClassCastException classCastException) {
            throw new ClassCastException(this.getActivity().toString() + " must implement StripeFragmentListener");
        }
        stripeFragment2.arguments = stripeFragment2.getArguments();
        this.buyButton = (Button)layoutInflater.findViewById(R.id.creditCardBuy);
        this.closeButton = (Button)layoutInflater.findViewById(R.id.closeButton);
        this.loadingSpinner = (ProgressBar)layoutInflater.findViewById(R.id.loadingSpinner);
        this.payNowSpinner = (ProgressBar)layoutInflater.findViewById(R.id.payNowSpinner);
        this.dollarAmount = (TextView)layoutInflater.findViewById(R.id.dollarAmount);
        this.errorMessage = (TextView)layoutInflater.findViewById(R.id.errorMessage);
        this.creditMessage = (TextView)layoutInflater.findViewById(R.id.creditMessage);
        this.savedCreditMessage = (TextView)layoutInflater.findViewById(R.id.savedCreditMessage);
        this.savedFormText = (TextView)layoutInflater.findViewById(R.id.savedFormText);
        this.savedFormImage = (ImageView)layoutInflater.findViewById(R.id.savedFormImage);
        this.messageAction = (MessageAction)this.arguments.getSerializable("action");
        this.changeCardButton = (Button)layoutInflater.findViewById(R.id.changeCardButton);
        this.creditCardForm = (CreditCardForm)layoutInflater.findViewById(R.id.creditCardForm);
        stripeFragment.savedCardForm = (LinearLayout)layoutInflater.findViewById(R.id.savedCreditCardForm);
        stripeFragment.cents = stripeFragment.messageAction.getAmount() % 100L;
        stripeFragment.dollars = stripeFragment.messageAction.getAmount() / 100L;
        object = stripeFragment.messageAction.getCurrency() != null ? this.messageAction.getCurrency().toUpperCase() : "USD";
        StripeFragment stripeFragment3 = this;
        stripeFragment3.currency = object;
        stripeFragment3.setup();
        stripeFragment3.showCorrectView((View)layoutInflater);
        stripeFragment3.setRetainInstance(true);
        return layoutInflater;
    }

    public Animation onCreateAnimation(int n2, boolean bl, int n3) {
        if (bl) {
            return AnimationUtils.loadAnimation((Context)this.getActivity(), (int)R.anim.stripe_slide_in);
        }
        return AnimationUtils.loadAnimation((Context)this.getActivity(), (int)R.anim.stripe_slide_out);
    }

    public void onResume() {
        StripeFragment stripeFragment = this;
        super.onResume();
        MessageAction messageAction = stripeFragment.messageAction;
        if (messageAction != null && messageAction.getState().equals(ActionState.PAID.getValue())) {
            this.onPaymentProcessed(PaymentStatus.SUCCESS);
        } else if (this.paymentRequestTimedOut) {
            this.onPaymentProcessed(PaymentStatus.ERROR);
            this.paymentRequestTimedOut = false;
        }
    }

    @Override
    public void cardValid(c c2) {
        if (this.buyButton.getVisibility() != 0) {
            StripeFragment stripeFragment = this;
            stripeFragment.buyButton.setVisibility(0);
            Button button = stripeFragment.buyButton;
            button.setTranslationY((float)button.getHeight());
            stripeFragment.buyButton.animate().translationY(0.0f);
        }
    }

    @Override
    public void cardInvalid(c c2) {
        StripeFragment stripeFragment = this;
        stripeFragment.buyButton.setVisibility(8);
        stripeFragment.hideErrorMessage();
    }

    public void onClick(View view) {
        CreditCard creditCard = null;
        if (view.getId() == this.buyButton.getId()) {
            Object object = this.creditCardForm.getCreditCard();
            if (((c)object).a().length() != 0) {
                CreditCard creditCard2;
                creditCard = creditCard2;
                c c2 = object;
                object = c2.a();
                int n2 = c2.c();
                int n3 = c2.b();
                String string2 = c2.d();
                creditCard2 = new CreditCard((String)object, n2, n3, string2);
            }
            StripeFragment stripeFragment = this;
            stripeFragment.buyButton.setText((CharSequence)"");
            stripeFragment.buyButton.setEnabled(false);
            stripeFragment.payNowSpinner.setVisibility(0);
            stripeFragment.changeCardButton.setVisibility(8);
            object = stripeFragment.conversation;
            if (object != null) {
                object.processPayment(creditCard, this.messageAction);
                this.startProcessPaymentTimeout();
            }
        }
        if (view.getId() == this.closeButton.getId()) {
            this.fragmentListener.onStripeFragmentClose();
        }
        if (view.getId() == this.changeCardButton.getId()) {
            StripeFragment stripeFragment = this;
            stripeFragment.changeCardClicked = true;
            stripeFragment.showEnterCreditCardView(stripeFragment.getView(), true);
        }
    }

    public void onPaymentProcessed(PaymentStatus object) {
        StripeFragment stripeFragment = this;
        stripeFragment.processPaymentTimeout.cancel();
        stripeFragment.processPaymentTimeout.purge();
        if (object == PaymentStatus.SUCCESS) {
            CheckMarkDrawable checkMarkDrawable;
            object = checkMarkDrawable;
            checkMarkDrawable = new CheckMarkDrawable((Context)this.getActivity());
            if (Build.VERSION.SDK_INT >= 16) {
                this.buyButton.setBackground((Drawable)object);
            } else {
                this.buyButton.setBackgroundDrawable((Drawable)object);
            }
            StripeFragment stripeFragment2 = this;
            stripeFragment2.payNowSpinner.setVisibility(8);
            stripeFragment2.fragmentListener.onPurchaseComplete();
        } else if (object == PaymentStatus.ERROR) {
            StripeFragment stripeFragment3 = this;
            stripeFragment3.buyButton.setEnabled(true);
            stripeFragment3.buyButton.setText(R.string.AvMessagingSdk_btnPayNow);
            stripeFragment3.payNowSpinner.setVisibility(8);
            stripeFragment3.showErrorMessage();
        }
    }

    public void onCardSummaryLoaded(CardSummary cardSummary) {
        if (!this.waitingForCardLoad) {
            return;
        }
        StripeFragment stripeFragment = this;
        stripeFragment.waitingForCardLoad = false;
        stripeFragment.savedCard = cardSummary;
        if (cardSummary != null) {
            StripeFragment stripeFragment2 = this;
            stripeFragment2.showSavedCreditCardView(stripeFragment2.getView(), cardSummary);
        } else {
            StripeFragment stripeFragment3 = this;
            stripeFragment3.showEnterCreditCardView(stripeFragment3.getView(), true);
        }
    }

    public static interface StripeFragmentListener {
        public void onStripeFragmentShown();

        public void onStripeFragmentClose();

        public void onPurchaseComplete();
    }
}

