/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ui.widget;

import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Build;
import android.text.SpannableString;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.SnapHelper;
import com.avaya.core.Coordinates;
import com.avaya.core.MessageAction;
import com.avaya.ui.R;
import com.avaya.ui.adapter.CarouselAdapter;
import com.avaya.ui.utils.CarouselSnapHelper;
import com.avaya.ui.utils.FileSize;
import com.avaya.ui.widget.AvMessagingSdkButton;
import com.avaya.ui.widget.AvMessagingSdkImageView;
import com.avaya.ui.widget.ImageActivity;
import com.avaya.ui.widget.TypingActivityView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.target.Target;
import java.io.File;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;

public class MessageView
extends RelativeLayout {
    private Path path;
    private Paint paint;
    private RecyclerView carouselContainer;
    private LinearLayout messageContainer;
    private LinearLayout buttonContainer;
    private FrameLayout messageSeparator;
    private RelativeLayout imageContainer;
    private LinearLayout fileContainer;
    private LinearLayout fileContents;
    public Delegate delegate;
    private ImageView paperClip;
    private ImageSize imageSize;
    private TextView subTextView;
    private TextView mainTextView;
    private SnapHelper snapHelper;
    private RelativeLayout overlay;
    private LayoutStyle layoutStyle;
    private TextView fileNameTextView;
    private TextView fileSizeTextView;
    private AvMessagingSdkImageView imageView;
    private ProgressBar loadingSpinner;
    private LinearLayout loadImageContainer;
    private TypingActivityView typingActivityView;
    private Map<MessageAction, AvMessagingSdkButton> avMessagingSdkButtons = new HashMap<MessageAction, AvMessagingSdkButton>();

    public MessageView(Context context, Delegate delegate) {
        super(context);
        this.delegate = delegate;
        this.paint = new Paint();
        this.path = new Path();
        this.imageSize = ImageSize.SMALL;
        this.createContainers();
    }

    private void createContainers() {
        MessageView messageView = this;
        messageView.createCarouselView();
        messageView.createImageContainer();
        messageView.createMessageContainer();
        messageView.createFileContainer();
        messageView.createButtonContainer();
        messageView.createTypingActivityView();
    }

    private void createImageView() {
        MessageView messageView = this;
        this.imageView = new AvMessagingSdkImageView(this.getContext());
        this.imageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
        messageView.imageView.setLayoutParams((ViewGroup.LayoutParams)this.getImageParams());
        messageView.imageContainer.addView((View)this.imageView);
    }

    private void createPaperClip() {
        LinearLayout.LayoutParams layoutParams;
        MessageView messageView = this;
        int n2 = messageView.getResources().getDimensionPixelSize(R.dimen.AvMessagingSdk_fileIconWidth);
        int n3 = messageView.getResources().getDimensionPixelSize(R.dimen.AvMessagingSdk_fileIconHeight);
        this.paperClip = new ImageView(this.getContext());
        this.paperClip.setTag((Object)R.drawable.avmessagingsdk_btn_paperclip);
        messageView.paperClip.setImageResource(R.drawable.avmessagingsdk_btn_paperclip);
        LinearLayout.LayoutParams layoutParams2 = layoutParams;
        new LinearLayout.LayoutParams((int)n2, (int)n3).gravity = 17;
        messageView.paperClip.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
        messageView.fileContainer.addView((View)this.paperClip);
    }

    private void createFileNameTextView() {
        MessageView messageView = this;
        int n2 = messageView.getResources().getDimensionPixelSize(R.dimen.AvMessagingSdk_fileNameMaxWidth);
        this.fileNameTextView = new TextView(this.getContext());
        this.fileNameTextView.setSingleLine();
        messageView.fileNameTextView.setMaxWidth(n2);
        messageView.fileNameTextView.setTypeface(null, 1);
        messageView.fileNameTextView.setEllipsize(TextUtils.TruncateAt.MIDDLE);
        messageView.fileNameTextView.setTextSize(0, this.getResources().getDimension(R.dimen.AvMessagingSdk_messageText));
        messageView.fileContents.addView((View)this.fileNameTextView);
    }

    private void createFileSizeTextView() {
        TextView textView;
        TextView textView2;
        TextView textView3 = textView2 = textView;
        textView3(this.getContext());
        this.fileSizeTextView = textView3;
        textView.setTextSize(0, this.getResources().getDimension(R.dimen.AvMessagingSdk_descriptionText));
        this.fileContents.addView((View)this.fileSizeTextView);
    }

    private void createFileContainer() {
        int n2;
        MessageView messageView = this;
        this.fileContainer = new LinearLayout(this.getContext());
        this.fileContainer.setOrientation(0);
        messageView.fileContainer.setId(R.id.avmessagingsdk_file_container_view_id);
        messageView.fileContainer.setLayoutParams((ViewGroup.LayoutParams)this.createFileContainerLayoutParams());
        int n3 = n2 = messageView.getResources().getDimensionPixelSize(R.dimen.AvMessagingSdk_fileContainerMargin);
        messageView.fileContainer.setPadding(n3, n3, n3, n3);
        messageView.addView((View)messageView.fileContainer);
    }

    private void createFileContents() {
        LinearLayout.LayoutParams layoutParams;
        MessageView messageView = this;
        this.fileContents = new LinearLayout(this.getContext());
        this.fileContents.setOrientation(1);
        LinearLayout.LayoutParams layoutParams2 = layoutParams;
        layoutParams2(-2, -2);
        layoutParams2.gravity = 17;
        layoutParams.leftMargin = this.getResources().getDimensionPixelSize(R.dimen.AvMessagingSdk_fileNameMargin);
        messageView.fileContents.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
        messageView.fileContainer.addView((View)this.fileContents);
        messageView.createFileNameTextView();
        messageView.createFileSizeTextView();
    }

    private void createImageContainer() {
        MessageView messageView = this;
        this.imageContainer = new RelativeLayout(this.getContext());
        this.imageContainer.setId(R.id.avmessagingsdk_image_container_view_id);
        messageView.addView((View)messageView.imageContainer);
    }

    private void createMessageContainer() {
        MessageView messageView = this;
        this.messageContainer = new LinearLayout(this.getContext());
        this.messageContainer.setOrientation(1);
        messageView.messageContainer.setId(R.id.avmessagingsdk_message_container_view_id);
        messageView.messageContainer.setLayoutParams((ViewGroup.LayoutParams)this.createMessageContainerLayoutParams());
        messageView.addView((View)messageView.messageContainer);
    }

    private void createButtonContainer() {
        MessageView messageView = this;
        this.buttonContainer = new LinearLayout(this.getContext());
        this.buttonContainer.setOrientation(1);
        messageView.buttonContainer.setId(R.id.avmessagingsdk_button_container_view_id);
        messageView.buttonContainer.setLayoutParams((ViewGroup.LayoutParams)this.createButtonContainerLayoutParams());
        messageView.addView((View)messageView.buttonContainer);
    }

    private void createCarouselView() {
        CarouselSnapHelper carouselSnapHelper;
        CarouselSnapHelper carouselSnapHelper2;
        MessageView messageView = this;
        this.carouselContainer = new RecyclerView(this.getContext());
        this.carouselContainer.setId(R.id.avmessagingsdk_carousel_container_view_id);
        CarouselSnapHelper carouselSnapHelper3 = carouselSnapHelper2 = carouselSnapHelper;
        carouselSnapHelper3();
        this.snapHelper = carouselSnapHelper3;
        carouselSnapHelper.attachToRecyclerView(this.carouselContainer);
        messageView.addView((View)messageView.carouselContainer);
    }

    private RelativeLayout.LayoutParams getImageParams() {
        RelativeLayout.LayoutParams layoutParams;
        MessageView messageView = this;
        int n2 = messageView.getResources().getDimensionPixelSize(R.dimen.AvMessagingSdk_imageDisplayWidth);
        int n3 = messageView.getResources().getDimensionPixelSize(R.dimen.AvMessagingSdk_imageDisplayHeight);
        if (messageView.imageSize == ImageSize.SMALL) {
            RelativeLayout.LayoutParams layoutParams2;
            layoutParams = layoutParams2;
            layoutParams2 = new RelativeLayout.LayoutParams(n2, n3);
        } else {
            RelativeLayout.LayoutParams layoutParams3;
            layoutParams = layoutParams3;
            int n4 = n2;
            layoutParams3 = new RelativeLayout.LayoutParams(n4, n4);
        }
        return layoutParams;
    }

    @NonNull
    private RelativeLayout.LayoutParams createMessageContainerLayoutParams() {
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams.addRule(5);
        layoutParams.addRule(3, this.imageContainer.getId());
        return layoutParams;
    }

    @NonNull
    private RelativeLayout.LayoutParams createFileContainerLayoutParams() {
        RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams.addRule(3, this.messageContainer.getId());
        return layoutParams;
    }

    @NonNull
    private RelativeLayout.LayoutParams createButtonContainerLayoutParams() {
        RelativeLayout.LayoutParams layoutParams;
        RelativeLayout.LayoutParams layoutParams2 = layoutParams;
        new RelativeLayout.LayoutParams(-2, -2).addRule(14);
        if (this.layoutStyle == LayoutStyle.RELATIVE) {
            layoutParams2.addRule(3, this.messageContainer.getId());
        } else {
            layoutParams2.addRule(12);
        }
        return layoutParams2;
    }

    private void createMessageTextView() {
        RelativeLayout.LayoutParams layoutParams;
        TextView textView;
        TextView textView2;
        MessageView messageView = this;
        TextView textView3 = textView2 = textView;
        textView3(this.getContext());
        this.mainTextView = textView3;
        textView.setMaxWidth(this.getResources().getDimensionPixelSize(R.dimen.AvMessagingSdk_messageMaxSize));
        messageView.mainTextView.setTextIsSelectable(true);
        TextView textView4 = messageView.mainTextView;
        textView4.setHighlightColor(textView4.getResources().getColor(R.color.AvMessagingSdk_accentDark));
        textView2 = layoutParams;
        new RelativeLayout.LayoutParams(-2, -2).addRule(9);
        messageView.messageContainer.addView((View)this.mainTextView, (ViewGroup.LayoutParams)textView2);
    }

    private void createDescriptionTextView() {
        TextView textView;
        TextView textView2;
        MessageView messageView = this;
        TextView textView3 = textView2 = textView;
        textView3(this.getContext());
        this.subTextView = textView3;
        textView.setMaxWidth(this.getResources().getDimensionPixelSize(R.dimen.AvMessagingSdk_messageMaxSize));
        messageView.messageContainer.addView((View)this.subTextView, (ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-2, -2));
        messageView.subTextView.setVisibility(8);
    }

    private void createTypingActivityView() {
        RelativeLayout.LayoutParams layoutParams;
        MessageView messageView = messageView2;
        messageView.typingActivityView = new TypingActivityView(messageView2.getContext());
        MessageView messageView2 = layoutParams;
        new RelativeLayout.LayoutParams(-2, -2).addRule(13);
        messageView.addView((View)messageView.typingActivityView, (ViewGroup.LayoutParams)messageView2);
        messageView.typingActivityView.setVisibility(8);
    }

    private void showSpinner(boolean bl) {
        this.showSpinner(bl, this.getResources().getDimensionPixelSize(R.dimen.AvMessagingSdk_imageSpinner));
    }

    private void hideSpinner() {
        ProgressBar progressBar = this.loadingSpinner;
        if (progressBar != null) {
            this.imageContainer.removeView((View)progressBar);
            this.loadingSpinner = null;
        }
    }

    private void showImageOverlay() {
        if (this.overlay == null) {
            this.overlay = new RelativeLayout(this.getContext());
            this.overlay.setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-1, -1));
            this.imageContainer.addView((View)this.overlay);
            if (Build.VERSION.SDK_INT >= 16) {
                this.overlay.setBackground(this.getResources().getDrawable(R.drawable.avmessagingsdk_bg_list));
            } else {
                this.overlay.setBackgroundColor(-1);
            }
        }
        this.overlay.getBackground().setAlpha(175);
    }

    private void hideImageOverlay() {
        RelativeLayout relativeLayout = this.overlay;
        if (relativeLayout != null) {
            this.imageContainer.removeView((View)relativeLayout);
            this.overlay = null;
        }
    }

    private void showLoadImageMessage(final String string2, final long l2, boolean bl, final boolean bl2, final View.OnClickListener onClickListener) {
        MessageView messageView = this;
        messageView.showLoadImageContainer(bl2, l2, bl);
        messageView.loadImageContainer.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                e e2 = string22;
                e2.MessageView.this.hideLoadImageMessage();
                e e3 = string22;
                String string22 = e3.string2;
                long l22 = e3.l2;
                boolean bl = e3.bl2;
                View.OnClickListener onClickListener2 = e3.onClickListener;
                e2.MessageView.this.setImage(string22, l22, false, bl, null, onClickListener2);
                e2.MessageView.this.setOnClickListener(null);
            }
        });
    }

    private void hideLoadImageMessage() {
        LinearLayout linearLayout = this.loadImageContainer;
        if (linearLayout != null) {
            this.imageContainer.removeView((View)linearLayout);
            this.loadImageContainer = null;
        }
    }

    private void hideSeparator() {
        FrameLayout frameLayout = this.messageSeparator;
        if (frameLayout != null) {
            this.removeView((View)frameLayout);
            this.messageSeparator = null;
        }
    }

    private void showMessageSeparator(boolean bl) {
        if (this.messageSeparator == null) {
            RelativeLayout.LayoutParams layoutParams;
            FrameLayout frameLayout;
            FrameLayout frameLayout2 = frameLayout;
            this.messageSeparator = new FrameLayout(this.getContext());
            if (bl) {
                frameLayout2.setBackgroundResource(R.drawable.avmessagingsdk_message_separator_remote);
            } else {
                frameLayout2.setBackgroundResource(R.drawable.avmessagingsdk_message_separator_user);
            }
            MessageView messageView = this;
            messageView.messageSeparator.setAlpha(0.3f);
            messageView.fileContainer.measure(-2, -2);
            messageView.messageContainer.measure(-2, -2);
            int n2 = messageView.getResources().getDimensionPixelSize(R.dimen.AvMessagingSdk_messagePaddingHorizontal);
            int n3 = Math.max(messageView.messageContainer.getMeasuredWidth(), this.fileContainer.getMeasuredWidth()) - n2 * 2;
            RelativeLayout.LayoutParams layoutParams2 = layoutParams;
            layoutParams2(n3, -2);
            layoutParams2.setMargins(n2, 0, n2, 0);
            layoutParams.addRule(3, this.messageContainer.getId());
            messageView.messageSeparator.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
            messageView.addView((View)messageView.messageSeparator);
        }
    }

    public void reset() {
        this.reset(ImageSize.SMALL, LayoutStyle.RELATIVE);
    }

    public void reset(ImageSize imageSize, LayoutStyle layoutStyle) {
        MessageView messageView = this;
        this.imageSize = imageSize;
        messageView.layoutStyle = layoutStyle;
        messageView.fileContainer.removeAllViews();
        messageView.imageContainer.removeAllViews();
        messageView.buttonContainer.removeAllViews();
        messageView.messageContainer.removeAllViews();
        messageView.carouselContainer.removeAllViews();
        messageView.createImageView();
        messageView.createPaperClip();
        messageView.createFileContents();
        messageView.createMessageTextView();
        messageView.createDescriptionTextView();
        messageView.hideSpinner();
        messageView.hideImageOverlay();
        messageView.hideLoadImageMessage();
        messageView.hideSeparator();
        messageView.avMessagingSdkButtons.clear();
        messageView.fileContainer.setVisibility(8);
        messageView.imageContainer.setVisibility(8);
        messageView.buttonContainer.setVisibility(8);
        messageView.messageContainer.setVisibility(8);
        messageView.carouselContainer.setVisibility(8);
        messageView.typingActivityView.setVisibility(8);
        messageView.imageContainer.setLayoutParams((ViewGroup.LayoutParams)this.getImageParams());
        messageView.buttonContainer.setLayoutParams((ViewGroup.LayoutParams)this.createButtonContainerLayoutParams());
        messageView.setOnClickListener(null);
    }

    public TextView getMainTextView() {
        return this.mainTextView;
    }

    public TextView getSubTextView() {
        return this.subTextView;
    }

    protected void onDraw(Canvas canvas) {
        MessageView messageView = this;
        super.onDraw(canvas);
        int n2 = canvas.getHeight();
        messageView.path.reset();
        messageView.path.setFillType(Path.FillType.EVEN_ODD);
        messageView.path.moveTo(0.0f, (float)n2);
        messageView.path.close();
        messageView.paint.setAntiAlias(true);
        messageView.paint.setDither(true);
        messageView.paint.setStyle(Paint.Style.FILL);
        Path path = messageView.path;
        canvas.drawPath(path, messageView.paint);
    }

    public void setOnClickListener(View.OnClickListener onClickListener) {
        MessageView messageView = this;
        super.setOnClickListener(onClickListener);
        LinearLayout linearLayout = messageView.messageContainer;
        if (linearLayout != null) {
            linearLayout.setOnClickListener(onClickListener);
        }
        if ((linearLayout = this.buttonContainer) != null) {
            linearLayout.setOnClickListener(onClickListener);
        }
        if ((linearLayout = this.mainTextView) != null) {
            linearLayout.setOnClickListener(onClickListener);
        }
        if ((linearLayout = this.subTextView) != null) {
            linearLayout.setOnClickListener(onClickListener);
        }
        if ((linearLayout = this.imageContainer) != null) {
            linearLayout.setOnClickListener(onClickListener);
        }
        if ((linearLayout = this.loadImageContainer) != null) {
            linearLayout.setOnClickListener(onClickListener);
        }
        if ((this = this.fileContainer) != null) {
            this.setOnClickListener(onClickListener);
        }
    }

    public void setMainText(SpannableString spannableString) {
        MessageView messageView = this;
        messageView.mainTextView.setText((CharSequence)spannableString);
        messageView.mainTextView.setVisibility(0);
        messageView.messageContainer.setVisibility(0);
    }

    public void setSubText(SpannableString spannableString) {
        MessageView messageView = this;
        messageView.subTextView.setText((CharSequence)spannableString);
        messageView.subTextView.setVisibility(0);
        messageView.messageContainer.setVisibility(0);
    }

    public void setImage(final String string2, final long l2, final boolean bl, final boolean bl2, final Runnable runnable, final View.OnClickListener onClickListener) {
        if (this.imageContainer.getVisibility() == 0 && runnable != null) {
            runnable.run();
            return;
        }
        MessageView messageView = this;
        messageView.showSpinner(bl2);
        RequestBuilder requestBuilder = Glide.with((View)messageView).load(string2);
        if (bl) {
            requestBuilder.onlyRetrieveFromCache(true);
        }
        MessageView messageView2 = this;
        requestBuilder.listener((RequestListener)new RequestListener<Drawable>(){

            public boolean onLoadFailed(@Nullable GlideException glideException, Object object, Target<Drawable> target, boolean bl3) {
                a a2 = object2;
                a a3 = object2;
                Object object2 = a3.string2;
                long l22 = a3.l2;
                boolean bl22 = a3.bl;
                bl3 = a3.bl2;
                View.OnClickListener onClickListener2 = a3.onClickListener;
                a2.MessageView.this.loadOnTap((String)object2, l22, bl22, bl3, onClickListener2);
                object2 = a2.runnable;
                if (object2 != null) {
                    object2.run();
                }
                return true;
            }

            public boolean a(Drawable drawable2, Object object, Target<Drawable> target, DataSource dataSource, boolean bl3) {
                if (runnable2.onClickListener != null) {
                    runnable2.MessageView.this.imageContainer.setOnClickListener(runnable2.onClickListener);
                } else if (!runnable2.MessageView.this.hasOnClickListeners()) {
                    runnable2.MessageView.this.prepareImagePreview(runnable2.string2);
                }
                a a2 = runnable2;
                a2.MessageView.this.hideSpinner();
                Runnable runnable2 = a2.runnable;
                if (runnable2 != null) {
                    runnable2.run();
                }
                return false;
            }
        }).into((ImageView)this.imageView);
        messageView2.imageView.setVisibility(0);
        messageView2.imageView.setTag(R.id.avmessagingsdk_image_view_id, string2);
        messageView2.imageContainer.setVisibility(0);
    }

    public void setImage(Bitmap bitmap) {
        MessageView messageView = this;
        messageView.imageView.setImageBitmap(bitmap);
        messageView.imageContainer.setVisibility(0);
    }

    public void setFile(File file, long l2, boolean bl) {
        this.fileNameTextView.setText((CharSequence)file.getName());
        this.showFile(l2, bl);
    }

    public void setFileByUrl(final String string2, long l2, boolean bl) {
        int n2;
        String string3 = string2;
        String string4 = null;
        try {
            n2 = string3.lastIndexOf(47);
        }
        catch (Exception exception) {}
        string4 = string3.substring(n2 + 1);
        string4 = URLDecoder.decode(string4, "UTF-8");
        MessageView messageView = this;
        this.fileNameTextView.setText((CharSequence)string4);
        messageView.showFile(l2, bl);
        messageView.fileContainer.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                MessageView.this.delegate.onFileClick(string2);
            }
        });
    }

    public void showFile(long l2, boolean bl) {
        Resources resources = this.getResources();
        this.fileContainer.setVisibility(0);
        int n2 = resources.getColor(R.color.AvMessagingSdk_userMessageText);
        int n3 = resources.getColor(R.color.AvMessagingSdk_remoteMessageText);
        int n4 = resources.getColor(R.color.AvMessagingSdk_inputTextColorHint);
        if (!bl) {
            MessageView messageView = this;
            messageView.paperClip.setColorFilter(n2, PorterDuff.Mode.SRC_IN);
            messageView.fileNameTextView.setTextColor(n2);
            messageView.fileSizeTextView.setTextColor(n2);
        } else {
            MessageView messageView = this;
            messageView.paperClip.setColorFilter(n3, PorterDuff.Mode.SRC_IN);
            messageView.fileNameTextView.setTextColor(n3);
            messageView.fileSizeTextView.setTextColor(n4);
        }
        if (l2 == 0L) {
            this.fileSizeTextView.setVisibility(8);
        } else {
            MessageView messageView = this;
            messageView.fileSizeTextView.setVisibility(0);
            messageView.fileSizeTextView.setText((CharSequence)FileSize.getReadableSize(l2));
        }
        if (this.hasText()) {
            this.showMessageSeparator(bl);
        }
    }

    public AvMessagingSdkImageView getImage() {
        return this.imageView;
    }

    public boolean hasText() {
        MessageView messageView = messageView.mainTextView;
        return messageView != null && messageView.getText().length() > 0;
    }

    public void showInProgressImageState() {
        MessageView messageView = this;
        messageView.showImageOverlay();
        messageView.showSpinner(false);
    }

    public void showFailedImageState() {
        MessageView messageView = this;
        messageView.showImageOverlay();
        messageView.hideSpinner();
    }

    public void setFileUploadInProgress() {
        this.showSpinner(false);
    }

    public void setFileUploadFailed() {
        this.hideSpinner();
    }

    public void loadOnTap(String string2, long l2, boolean bl, boolean bl2, View.OnClickListener onClickListener) {
        MessageView messageView = this;
        messageView.hideSpinner();
        messageView.imageView.setVisibility(8);
        this.showLoadImageMessage(string2, l2, bl, bl2, onClickListener);
    }

    public AvMessagingSdkButton addAvMessagingSdkButton(final MessageAction messageAction) {
        if (!this.avMessagingSdkButtons.containsKey(messageAction)) {
            AvMessagingSdkButton avMessagingSdkButton;
            MessageView messageView = this;
            AvMessagingSdkButton avMessagingSdkButton2 = avMessagingSdkButton;
            avMessagingSdkButton2(this.getContext());
            avMessagingSdkButton.setText(messageAction.getText());
            avMessagingSdkButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    MessageView.this.delegate.onActionClick(messageAction);
                }
            });
            messageView.buttonContainer.addView((View)avMessagingSdkButton2);
            messageView.buttonContainer.setVisibility(0);
            messageView.avMessagingSdkButtons.put(messageAction, avMessagingSdkButton2);
        }
        return this.avMessagingSdkButtons.get(messageAction);
    }

    public void prepareImagePreview(final String string2) {
        this.imageContainer.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Intent intent;
                view = intent;
                view(MessageView.this.getContext(), ImageActivity.class);
                intent.putExtra("MEDIA_URL", string2);
                MessageView.this.getContext().startActivity((Intent)view);
            }
        });
    }

    public void showSpinner(boolean bl, int n2) {
        MessageView messageView = this;
        int n3 = messageView.getResources().getDimensionPixelSize(R.dimen.AvMessagingSdk_messagePaddingTop);
        int n4 = messageView.getResources().getDimensionPixelSize(R.dimen.AvMessagingSdk_messagePaddingBottom);
        int n5 = messageView.getResources().getDimensionPixelSize(R.dimen.AvMessagingSdk_messagePaddingHorizontal);
        if (messageView.loadingSpinner == null) {
            ProgressBar progressBar;
            RelativeLayout.LayoutParams layoutParams;
            RelativeLayout.LayoutParams layoutParams2;
            MessageView messageView2 = this;
            RelativeLayout.LayoutParams layoutParams3 = layoutParams2 = layoutParams;
            int n6 = n2;
            layoutParams3(n6, n6);
            layoutParams3.addRule(14);
            layoutParams3.addRule(15);
            layoutParams.setMargins(n5, n3, n5, n4);
            ProgressBar progressBar2 = progressBar;
            messageView2.loadingSpinner = new ProgressBar(this.getContext());
            messageView2.imageContainer.addView((View)progressBar2);
            messageView2.loadingSpinner.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
            if (!bl) {
                this.loadingSpinner.getIndeterminateDrawable().setColorFilter(-1, PorterDuff.Mode.SRC_IN);
            }
        }
    }

    public CarouselAdapter showCarousel(String object) {
        LinearLayoutManager linearLayoutManager;
        CarouselAdapter carouselAdapter;
        String string2 = object;
        MessageView messageView = messageView3;
        object = carouselAdapter;
        MessageView messageView2 = messageView3;
        Context context = messageView2.getContext();
        carouselAdapter = new CarouselAdapter(context, messageView2.delegate);
        context = linearLayoutManager;
        linearLayoutManager = new LinearLayoutManager(messageView3.getContext(), 0, false);
        messageView.carouselContainer.setVisibility(0);
        messageView.carouselContainer.setAdapter((RecyclerView.Adapter)object);
        messageView.carouselContainer.setLayoutManager((RecyclerView.LayoutManager)context);
        MessageView messageView3 = CarouselSnapHelper.getRecyclerViewInstanceState(string2);
        if (messageView3 != null) {
            context.onRestoreInstanceState(messageView3.getParcelable("recycler_state"));
        }
        return object;
    }

    public void showLoadImageContainer(boolean bl, long l2, boolean bl2) {
        if (this.loadImageContainer == null) {
            ImageView imageView;
            ImageView imageView2;
            TextView textView;
            TextView textView2;
            LinearLayout linearLayout;
            LinearLayout linearLayout2;
            RelativeLayout.LayoutParams layoutParams;
            MessageView messageView = this;
            RelativeLayout.LayoutParams layoutParams2 = layoutParams;
            layoutParams = new RelativeLayout.LayoutParams(-2, -2);
            LinearLayout linearLayout3 = linearLayout2 = linearLayout;
            linearLayout3(this.getContext());
            this.loadImageContainer = linearLayout3;
            linearLayout.setLayoutParams((ViewGroup.LayoutParams)this.getImageParams());
            messageView.loadImageContainer.setId(R.id.avmessagingsdk_load_image_container_view_id);
            messageView.loadImageContainer.setOrientation(1);
            messageView.loadImageContainer.setAnimationCacheEnabled(true);
            messageView.loadImageContainer.setAlpha(0.0f);
            LinearLayout linearLayout4 = linearLayout2 = textView2;
            linearLayout4(this.getContext());
            linearLayout4.setText(R.string.AvMessagingSdk_imageUploadPreviewNotAvailable);
            textView2.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
            TextView textView3 = textView;
            textView = new TextView(this.getContext());
            if (bl2) {
                Resources resources = this.getResources();
                int n2 = R.string.AvMessagingSdk_imageUploadTapToView;
                Object[] objectArray = new Object[1];
                int n3 = 0;
                String string2 = l2 == 0L ? "" : " " + FileSize.getReadableSize(l2);
                objectArray[n3] = string2;
                textView3.setText((CharSequence)resources.getString(n2, objectArray));
            } else {
                textView3.setText((CharSequence)this.getResources().getString(R.string.AvMessagingSdk_imageUploadRetry));
            }
            MessageView messageView2 = this;
            textView3.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
            ImageView imageView3 = imageView2 = imageView;
            imageView3(this.getContext());
            imageView3.setImageResource(17301559);
            imageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
            messageView2.loadImageContainer.addView((View)imageView2);
            messageView2.loadImageContainer.addView((View)linearLayout2);
            messageView2.loadImageContainer.addView((View)textView3);
            messageView2.loadImageContainer.setGravity(17);
            if (bl) {
                linearLayout2.setTextColor(this.getResources().getColor(R.color.AvMessagingSdk_accent));
                textView3.setTextColor(this.getResources().getColor(R.color.AvMessagingSdk_accent));
                imageView2.setColorFilter(this.getResources().getColor(R.color.AvMessagingSdk_accent), PorterDuff.Mode.SRC_IN);
            } else {
                linearLayout2.setTextColor(-1);
                textView3.setTextColor(-1);
                imageView2.setColorFilter(-1);
            }
            MessageView messageView3 = this;
            messageView3.imageContainer.addView((View)this.loadImageContainer);
            messageView3.loadImageContainer.animate().alpha(1.0f).setDuration(200L);
        }
        this.imageContainer.setVisibility(0);
    }

    public void showTypingActivity() {
        MessageView messageView = this;
        messageView.typingActivityView.setVisibility(0);
        messageView.typingActivityView.animateCircles();
    }

    public void mutateDrawable(Map<ViewCorner, Boolean> map, boolean bl, boolean bl2) {
        Resources resources = messageView.getResources();
        MessageView messageView = messageView.getBackground();
        float f2 = resources.getDimension(R.dimen.AvMessagingSdk_messageRadius);
        float f3 = resources.getDimension(R.dimen.AvMessagingSdk_messageCornerRadius);
        int n2 = bl ? resources.getColor(R.color.AvMessagingSdk_remoteMessageBackground) : (bl2 ? resources.getColor(R.color.AvMessagingSdk_userMessageUnsentBackground) : resources.getColor(R.color.AvMessagingSdk_userMessageBackground));
        messageView.mutate();
        float f4 = map.get((Object)ViewCorner.TOP_LEFT) != false ? f2 : f3;
        float f5 = map.get((Object)ViewCorner.TOP_RIGHT) != false ? f2 : f3;
        float f6 = map.get((Object)ViewCorner.BOTTOM_LEFT) != false ? f2 : f3;
        if (!map.get((Object)ViewCorner.BOTTOM_RIGHT).booleanValue()) {
            f2 = f3;
        }
        if (messageView instanceof LayerDrawable) {
            messageView = (LayerDrawable)messageView;
            for (int i2 = 0; i2 < messageView.getNumberOfLayers(); ++i2) {
                if (!(messageView.getDrawable(i2) instanceof GradientDrawable)) continue;
                GradientDrawable gradientDrawable = (GradientDrawable)messageView.getDrawable(0);
                gradientDrawable.setCornerRadii(new float[]{f4, f4, f5, f5, f2, f2, f6, f6});
                gradientDrawable.setColor(n2);
                break;
            }
        }
    }

    public void updateImageCorners(Map<ViewCorner, Boolean> map) {
        Map<MessageAction, AvMessagingSdkButton> map2;
        int n2 = 1;
        if (map.get((Object)ViewCorner.TOP_LEFT).booleanValue()) {
            n2 = 5;
        }
        if (map.get((Object)ViewCorner.TOP_RIGHT).booleanValue()) {
            n2 |= 2;
        }
        if (!(this.messageContainer.getVisibility() == 0 || (map2 = this.avMessagingSdkButtons) != null && map2.size() > 0)) {
            if (map.get((Object)ViewCorner.BOTTOM_LEFT).booleanValue()) {
                n2 |= 0x10;
            }
            if (map.get((Object)ViewCorner.BOTTOM_RIGHT).booleanValue()) {
                n2 |= 8;
            }
        }
        this.imageView.setRoundedCorners(n2);
    }

    public static final class LayoutStyle
    extends Enum<LayoutStyle> {
        public static final /* enum */ LayoutStyle RELATIVE;
        public static final /* enum */ LayoutStyle FIXED;
        private static final /* synthetic */ LayoutStyle[] $VALUES;

        public static LayoutStyle[] values() {
            return (LayoutStyle[])$VALUES.clone();
        }

        public static LayoutStyle valueOf(String string2) {
            return Enum.valueOf(LayoutStyle.class, string2);
        }

        static {
            LayoutStyle layoutStyle;
            LayoutStyle layoutStyle2;
            LayoutStyle layoutStyle3 = layoutStyle2;
            RELATIVE = new LayoutStyle();
            LayoutStyle layoutStyle4 = layoutStyle;
            FIXED = new LayoutStyle();
            $VALUES = new LayoutStyle[]{layoutStyle3, layoutStyle4};
        }
    }

    public static final class ImageSize
    extends Enum<ImageSize> {
        public static final /* enum */ ImageSize SMALL;
        public static final /* enum */ ImageSize LARGE;
        private static final /* synthetic */ ImageSize[] $VALUES;

        public static ImageSize[] values() {
            return (ImageSize[])$VALUES.clone();
        }

        public static ImageSize valueOf(String string2) {
            return Enum.valueOf(ImageSize.class, string2);
        }

        static {
            ImageSize imageSize;
            ImageSize imageSize2;
            ImageSize imageSize3 = imageSize2;
            SMALL = new ImageSize();
            ImageSize imageSize4 = imageSize;
            LARGE = new ImageSize();
            $VALUES = new ImageSize[]{imageSize3, imageSize4};
        }
    }

    public static final class ViewCorner
    extends Enum<ViewCorner> {
        public static final /* enum */ ViewCorner TOP_LEFT;
        public static final /* enum */ ViewCorner TOP_RIGHT;
        public static final /* enum */ ViewCorner BOTTOM_LEFT;
        public static final /* enum */ ViewCorner BOTTOM_RIGHT;
        private static final /* synthetic */ ViewCorner[] $VALUES;

        public static ViewCorner[] values() {
            return (ViewCorner[])$VALUES.clone();
        }

        public static ViewCorner valueOf(String string2) {
            return Enum.valueOf(ViewCorner.class, string2);
        }

        static {
            ViewCorner viewCorner;
            ViewCorner viewCorner2;
            ViewCorner viewCorner3;
            ViewCorner viewCorner4;
            ViewCorner viewCorner5 = viewCorner4;
            TOP_LEFT = new ViewCorner();
            ViewCorner viewCorner6 = viewCorner3;
            TOP_RIGHT = new ViewCorner();
            ViewCorner viewCorner7 = viewCorner2;
            BOTTOM_LEFT = new ViewCorner();
            ViewCorner viewCorner8 = viewCorner;
            BOTTOM_RIGHT = new ViewCorner();
            $VALUES = new ViewCorner[]{viewCorner5, viewCorner6, viewCorner7, viewCorner8};
        }
    }

    public static interface Delegate {
        public void onActionClick(MessageAction var1);

        public void onMapClick(Coordinates var1);

        public void onFileClick(String var1);
    }
}

