/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ui.adapter;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Typeface;
import android.os.Build;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.StyleSpan;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.avaya.core.ActionState;
import com.avaya.core.AvMessagingSdkCallback;
import com.avaya.core.ConversationEvent;
import com.avaya.core.Coordinates;
import com.avaya.core.Message;
import com.avaya.core.MessageAction;
import com.avaya.core.MessageType;
import com.avaya.core.MessageUploadStatus;
import com.avaya.core.utils.StringUtils;
import com.avaya.ui.R;
import com.avaya.ui.builder.MessageViewBuilder;
import com.avaya.ui.builder.MessageViewModel;
import com.avaya.ui.utils.DateTimeUtils;
import com.avaya.ui.utils.DpVisitor;
import com.avaya.ui.widget.AvatarImageView;
import com.avaya.ui.widget.MessageView;
import com.avaya.ui.widget.RepliesView;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;

public class MessageListAdapter
extends RecyclerView.Adapter
implements MessageView.Delegate,
RepliesView.Delegate {
    private static final String TAG = "MessageListAdapter";
    private static final int ANIMATION_DURATION = 500;
    private static final int SHORT_ANIMATION_DURATION = 200;
    private static final int VIEW_TYPE_HEADER = 0;
    private static final int VIEW_TYPE_MESSAGE = 1;
    private static final int VIEW_TYPE_FOOTER = 2;
    private boolean creditCardLoaded = false;
    private ArrayList<j> messageGroupList;
    private List<MessageAction> replies;
    private j typingActivityItem;
    private int headerViewResourceId;
    private int hoursBetweenTimestamps;
    private Delegate delegate;
    private String mapsApiKey;
    private int unreadCount;
    private Message firstUnreadMessage;

    public MessageListAdapter(Delegate delegate) {
        ArrayList arrayList;
        ArrayList arrayList2;
        Object object = arrayList2;
        arrayList2 = new ArrayList();
        v1.messageGroupList = object;
        object = arrayList;
        arrayList = new ArrayList();
        v1.replies = object;
        v1.headerViewResourceId = 0;
        v1.hoursBetweenTimestamps = 0;
        v1.unreadCount = 0;
        v1.firstUnreadMessage = null;
        v1.delegate = delegate;
    }

    private void setFirstUnreadMessage() {
        if (this.unreadCount == 0) {
            this.firstUnreadMessage = null;
            return;
        }
        if (this.firstUnreadMessage != null) {
            return;
        }
        int n2 = 0;
        for (int i2 = this.messageGroupList.size() - 1; i2 >= 0; --i2) {
            Message message = this.messageGroupList.get((int)i2).c;
            if (!message.isFromCurrentUser()) {
                ++n2;
            }
            if (n2 != this.unreadCount) continue;
            this.firstUnreadMessage = message;
            break;
        }
    }

    private j createTypingActivityItem(ConversationEvent conversationEvent) {
        j j2;
        j j3 = j2;
        j3();
        j3.k = true;
        j3.l = true;
        j3.j = true;
        j3.e = conversationEvent.getAvatarUrl();
        j3.f = conversationEvent.getName();
        j3.g = conversationEvent.getUserId();
        j2.h = conversationEvent.getRole();
        j2.d = false;
        j2.m = true;
        j2.c = null;
        j2.o = true;
        j2.p = true;
        return j2;
    }

    private void notifyRemoteMessageChanged(int n2) {
        j j2 = this.getItem(n2);
        if (j2 != null && !j2.d) {
            this.notifyItemChanged(n2);
        }
    }

    private View createRepliesView(@NonNull Context context) {
        LinearLayout.LayoutParams layoutParams;
        RepliesView repliesView = new RepliesView(context);
        context = layoutParams;
        layoutParams = new LinearLayout.LayoutParams(-1, -2);
        repliesView.setLayoutParams((ViewGroup.LayoutParams)context);
        repliesView.setDelegate(this);
        return repliesView;
    }

    private void notifyMessageAdded() {
        this.notifyMessagesAdded(1);
    }

    private void notifyMessagesAdded(int n2) {
        int n3;
        j j2;
        MessageListAdapter messageListAdapter = this;
        int n4 = messageListAdapter.getItemCount() - n2;
        if (messageListAdapter.hasTypingActivity()) {
            --n4;
        }
        if (n4 > 0 && (j2 = this.getItem(n3 = n4 - 1)) != null) {
            if (this.getItem(n4) != null) {
                this.notifyItemChanged(n3);
            } else if (this.hasTypingActivity() && !j2.c.isFromCurrentUser()) {
                this.typingActivityItem.k = true;
                j2.l = true;
                this.notifyItemChanged(n3);
            }
        }
        MessageListAdapter messageListAdapter2 = this;
        messageListAdapter2.notifyItemRangeInserted(n4, n2);
        if (messageListAdapter2.hasTypingActivity()) {
            MessageListAdapter messageListAdapter3 = this;
            n2 = messageListAdapter3.getItemCount();
            n4 = messageListAdapter3.shouldDisplayFooter() ? 2 : 1;
            this.notifyItemChanged(n2 - n4);
        }
    }

    private void addMessages(List<Message> list) {
        if (list != null) {
            Iterator<Message> iterator = list.iterator();
            while (iterator.hasNext()) {
                this.addMessageInternal(iterator.next(), g.a);
            }
            this.notifyMessagesAdded(list.size());
        }
    }

    private boolean shouldDisplayHeader() {
        return this.headerViewResourceId != 0;
    }

    private j getItem(int n2) {
        if (this.shouldDisplayHeader()) {
            --n2;
        }
        if (n2 >= 0 && n2 < this.messageGroupList.size()) {
            return this.messageGroupList.get(n2);
        }
        if (n2 == this.messageGroupList.size() && this.hasTypingActivity()) {
            return this.typingActivityItem;
        }
        return null;
    }

    private boolean hasTypingActivity() {
        return this.typingActivityItem != null;
    }

    private boolean shouldDisplayFooter() {
        List<MessageAction> list = ((MessageListAdapter)((Object)list)).replies;
        return list != null && !list.isEmpty();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void getItemView(int var1_3, k var2_12) {
        block18: {
            block17: {
                v0 = var2_12;
                var3_13 = v0.itemView.getResources();
                var4_16 /* !! */  = v0.h;
                if (var4_16 /* !! */  == null) {
                    var2_12.h = this.createMessageView((ViewGroup)var2_12.g);
                } else if (var2_12.i.c == null) {
                    var4_16 /* !! */ .reset();
                }
                var4_16 /* !! */  = this.getItem(var1_3);
                var2_12.i = var4_16 /* !! */ ;
                if (var4_16 /* !! */  == null) {
                    Log.e((String)"MessageListAdapter", (String)"Got back null item");
                    return;
                }
                v1 = var2_12;
                var4_16 /* !! */ .a = var2_12.h;
                var4_16 /* !! */ .b = var2_12.f;
                var4_17 = var4_16 /* !! */ .d ^ true;
                v1.a.setVisibility(8);
                if (this.shouldPrintDate(v1.i)) {
                    v2 = var2_12.i;
                    v2.k = true;
                    v2.p = true;
                    var1_4 = this.getItem(var1_3 - 1);
                    if (var1_4 != null) {
                        v3 = var1_4;
                        v3.l = true;
                        v3.o = true;
                    }
                    var1_4 = new SimpleDateFormat(var3_13.getString(R.string.AvMessagingSdk_settings_timestampFormat), Locale.getDefault()).format(var2_12.i.i);
                    var2_12.e.setText((CharSequence)var1_4);
                    if (Build.VERSION.SDK_INT >= 21) {
                        var2_12.e.setTypeface(Typeface.create((String)"sans-serif-medium", (int)0));
                    }
                    var2_12.e.setVisibility(0);
                } else {
                    var2_12.e.setVisibility(8);
                }
                v4 = var3_13;
                v5 = var2_12;
                v6 = var2_12;
                var1_5 = v6.i;
                var5_19 = v6.f;
                var6_21 = v6.g;
                this.updateStatusAlignment(var1_5, var5_19, var6_21);
                v5.f.setVisibility(8);
                var1_5 = v5.i;
                var5_19 = v5.g;
                v7 = var1_5;
                var1_5 = (ViewGroup)var2_12.itemView;
                this.updateMessageContent(v7, (LinearLayout)var5_19, var3_13, (ViewGroup)var1_5);
                var2_12.i.j = false;
                var1_6 = v4.getDimensionPixelSize(R.dimen.AvMessagingSdk_messageAvatar);
                var3_14 = v4.getDimensionPixelSize(R.dimen.AvMessagingSdk_messageAvatarMargin);
                var5_20 = v4.getDimensionPixelSize(R.dimen.AvMessagingSdk_conversationMargin);
                var6_21 = var2_12.i.c;
                if (var6_21 == null || !var6_21.isCarousel()) break block17;
                var2_12.b.setPadding(var1_6 + var3_14 + var5_20, 0, 0, 0);
                break block18;
            }
            if (!var4_17) ** GOTO lbl-1000
            var1_7 = var2_12.i;
            if (var1_7.o) {
                var2_12.a.show(var1_7.e);
            } else lbl-1000:
            // 2 sources

            {
                var2_12.a.showInvisible();
            }
            var2_12.b.setPadding(0, 0, 0, 0);
        }
        v8 = var2_12;
        var1_8 = v8.itemView;
        var3_14 = var1_8.getPaddingLeft();
        var5_20 = v8.itemView.getPaddingTop();
        var6_22 = v8.itemView.getPaddingRight();
        var7_23 = v8.i.l != false ? (int)DpVisitor.toPixels(var2_12.itemView.getContext(), 8.0f) : 0;
        var1_8.setPadding(var3_14, var5_20, var6_22, var7_23);
        if (!var4_17) ** GOTO lbl-1000
        var1_8 = var2_12.i;
        if (var1_8.p && (var1_8 = var1_8.f) != null && !var1_8.isEmpty()) {
            v9 = var2_12;
            v9.b.setText((CharSequence)var2_12.i.f);
            v9.b.setVisibility(0);
        } else lbl-1000:
        // 2 sources

        {
            var2_12.b.setVisibility(8);
        }
        var1_9 = false;
        var3_15 = var2_12.i.c;
        if (var3_15 != null && var3_15.getMessageActions() != null) {
            for (MessageAction var4_18 : var2_12.i.c.getMessageActions()) {
                if (var4_18.getState() == null || !var4_18.getState().equals(ActionState.OFFERED.getValue())) continue;
                var1_9 = true;
                break;
            }
        }
        if (!this.creditCardLoaded && var1_9) {
            this.creditCardLoaded = true;
            this.delegate.onProductOffered();
        }
        if (this.unreadCount > 0 && (var1_10 = var2_12.i.c) != null && var1_10.equals((Object)this.firstUnreadMessage)) {
            v10 = var2_12;
            var0_1 = R.plurals.AvMessagingSdk_unreadMessagesText;
            var1_11 = this.unreadCount;
            v11 = new Object[1];
            var0_2 = v11;
            v11[0] = var1_11;
            v10.d.setText((CharSequence)var2_12.itemView.getResources().getQuantityString(var0_1, var1_11, var0_2));
            v10.c.setVisibility(0);
        } else {
            var2_12.c.setVisibility(8);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void buildMessageView(final j var1_1) {
        block20: {
            v0 = var1_1;
            var2_2 = v0.c;
            var3_3 = v0.d ^ true;
            var4_4 = v0.l;
            var5_7 = v0.k;
            var6_9 = v0.m;
            var7_11 = v0.o;
            var8_12 = false;
            var9_13 = false;
            var10_14 = false;
            var11_15 = false;
            var12_16 = v0.a;
            if (var12_16 == null || var1_1.b == null) break block20;
            var12_16 = var12_16.getResources();
            if (var2_2 != null) {
                var8_12 = MessageType.FILE.getValue().equals(var2_2.getType());
                var9_13 = MessageType.IMAGE.getValue().equals(var2_2.getType());
                var10_14 = var2_2.getUploadStatus() == MessageUploadStatus.FAILED || MessageType.LOCATION.getValue().equals(var2_2.getType()) && !var2_2.hasValidCoordinates();
                var11_15 = var2_2.getUploadStatus() == MessageUploadStatus.UNSENT;
            }
            var13_17 = var1_1.e;
            var14_18 = this.mapsApiKey;
            MessageViewBuilder.build(new MessageViewModel(var2_2, (Resources)var12_16, var3_3, var5_7, var4_4, var7_11, var10_14, var11_15, var13_17, var14_18), var1_1.a);
            if (this.messageGroupList.size() <= 0) ** GOTO lbl-1000
            v1 = this.messageGroupList;
            if (var1_1.equals(v1.get(v1.size() - 1))) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            if (v2 != false && var10_14 == false && var11_15 == false && (var3_3 == false || this.hasTypingActivity() == false)) {
                var4_5 /* !! */  = var1_1.c;
                var4_5 /* !! */  = var4_5 /* !! */  != null && var4_5 /* !! */ .getDate() != null ? Long.valueOf(var1_1.c.getDate().getTime()) : null;
                v3 = this;
                var4_5 /* !! */  = v3.getRelativeTimestampText((Long)var4_5 /* !! */ , (Resources)var12_16);
                var5_7 = v3.delegate.getLastRead() != null && var1_1.c.getDate() != null && this.delegate.getLastRead() >= var1_1.c.getDate().getTime();
                if (var4_5 /* !! */  != null) {
                    if (var3_3) {
                        var5_8 = v4;
                        v4 = new SpannableStringBuilder((CharSequence)var4_5 /* !! */ );
                    } else if (var5_7) {
                        v5 = this;
                        var4_5 /* !! */  = v5.getSeenStatusText(v5.delegate.getLastRead(), (Resources)var12_16);
                        var5_8 = var4_5 /* !! */ ;
                    } else {
                        var4_5 /* !! */  = this.getDeliveredStatusText((String)var4_5 /* !! */ , (Resources)var12_16);
                        var5_8 = var4_5 /* !! */ ;
                    }
                    var4_5 /* !! */  = this.getShortTimestampText(var2_2, (Resources)var12_16);
                    if (var4_5 /* !! */  != null && !var9_13 && !var8_12) {
                        var1_1.a.setOnClickListener(new View.OnClickListener(this, (String)var4_5 /* !! */ , var5_8){
                            final /* synthetic */ String b;
                            final /* synthetic */ SpannableStringBuilder c;
                            {
                                this.b = string2;
                                this.c = spannableStringBuilder;
                            }

                            public void onClick(View object) {
                                object = var1_1;
                                if (object.n ^= true) {
                                    object.b.setText((CharSequence)this.b);
                                } else {
                                    object.b.setText((CharSequence)this.c);
                                }
                            }
                        });
                    }
                    v6 = var1_1;
                    var6_10 = v6.b;
                    if (v6.n) {
                        var5_8 = var4_5 /* !! */ ;
                    }
                    var6_10.setText((CharSequence)var5_8);
                    var1_1.b.setVisibility(0);
                } else {
                    var1_1.b.setVisibility(8);
                }
            } else if (var11_15) {
                v7 = var1_1;
                v7.b.setText(R.string.AvMessagingSdk_sendingMessage);
                v7.b.setVisibility(0);
            } else if (!(var10_14 || var9_13 || var8_12 || var6_9)) {
                var4_6 = this.getShortTimestampText(var2_2, (Resources)var12_16);
                var1_1.b.setVisibility(8);
                if (var4_6 != null) {
                    var1_1.a.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View object) {
                            object = b3.var1_1;
                            if (object.n ^= true) {
                                b b2 = b3;
                                b b3 = object.b;
                                b3.MessageListAdapter.this.animateTimestampExpand((TextView)b3, b2.var4_6);
                            } else {
                                b3.MessageListAdapter.this.animateTimestampCollapse(object.b);
                            }
                        }
                    });
                } else {
                    var1_1.n = false;
                    var1_1.b.setVisibility(8);
                }
                if (var1_1.n) {
                    v8 = var1_1;
                    v8.b.setText((CharSequence)var4_6);
                    v8.b.setVisibility(0);
                }
            }
            if (!var3_3 && var10_14) {
                v9 = var1_1;
                v9.b.setText(var12_16.getText(R.string.AvMessagingSdk_errorSendingMessage));
                v9.b.setVisibility(0);
                v9.a.setClickable(true);
                v9.a.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View view) {
                        if (MessageListAdapter.this.delegate != null) {
                            MessageListAdapter.this.delegate.onClick(var2_2);
                        }
                        c c2 = this;
                        c2.var1_1.a.setClickable(false);
                        c2.var1_1.a.setOnClickListener(null);
                    }
                });
            }
            return;
        }
    }

    @SuppressLint(value={"RtlHardcoded"})
    private void updateMessageContent(j j2, LinearLayout linearLayout, Resources resources, ViewGroup viewGroup) {
        boolean bl = j2.l;
        boolean bl2 = bl && j2.j;
        boolean bl3 = j2.d ^ true;
        this.buildMessageView(j2);
        LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)j2.a.getLayoutParams();
        int n2 = bl3 ? 3 : 5;
        layoutParams.gravity = n2;
        n2 = 0;
        int n3 = 0;
        int n4 = !bl3 ? resources.getDimensionPixelSize(R.dimen.AvMessagingSdk_conversationMargin) : 0;
        int n5 = !bl ? (int)DpVisitor.toPixels(viewGroup.getContext(), 4.0f) : 0;
        layoutParams.setMargins(n2, n3, n4, n5);
        j2.a.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        if (bl2) {
            this.animate((View)linearLayout, j2.a, bl3);
        }
    }

    private void animateTimestampExpand(final TextView textView, String string2) {
        AnimatorListenerAdapter animatorListenerAdapter;
        TextView textView2 = textView;
        textView2.setText((CharSequence)string2);
        textView2.setVisibility(0);
        textView2.measure(-2, -2);
        int n2 = textView2.getMeasuredHeight();
        textView2.setAlpha(0.0f);
        AnimatorListenerAdapter animatorListenerAdapter2 = animatorListenerAdapter;
        animatorListenerAdapter = new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animator2) {
                MessageListAdapter.this.animateAlpha((View)textView, 1.0f, null);
            }
        };
        this.animateHeight((View)textView, 0, n2, (Animator.AnimatorListener)animatorListenerAdapter2);
    }

    private void animateTimestampCollapse(final TextView textView) {
        AnimatorListenerAdapter animatorListenerAdapter;
        final int n2 = textView.getHeight();
        AnimatorListenerAdapter animatorListenerAdapter2 = animatorListenerAdapter;
        animatorListenerAdapter = new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator object) {
                AnimatorListenerAdapter animatorListenerAdapter;
                e e2 = this;
                object = e2.textView;
                int n22 = e2.n2;
                Animator animator2 = object;
                object = animatorListenerAdapter;
                animatorListenerAdapter = new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animator2) {
                        a a2 = animatorListenerAdapter;
                        super.onAnimationEnd(animator2);
                        a2.textView.setText(null);
                        a2.textView.setVisibility(8);
                        AnimatorListenerAdapter animatorListenerAdapter = animatorListenerAdapter.this;
                        a2.textView.getLayoutParams().height = animatorListenerAdapter.n2;
                        animatorListenerAdapter.textView.setAlpha(1.0f);
                    }
                };
                MessageListAdapter.this.animateHeight((View)animator2, n22, 0, (Animator.AnimatorListener)object);
            }
        };
        this.animateAlpha((View)textView, 0.0f, (Animator.AnimatorListener)animatorListenerAdapter2);
    }

    private void animateAlpha(View view, float f2, Animator.AnimatorListener animatorListener) {
        view.animate().alpha(f2).setInterpolator((TimeInterpolator)new AccelerateDecelerateInterpolator()).setListener(animatorListener).setDuration(200L).start();
    }

    private void animateHeight(final View view, int n2, int n3, Animator.AnimatorListener animatorListener) {
        ValueAnimator.AnimatorUpdateListener animatorUpdateListener;
        AccelerateDecelerateInterpolator accelerateDecelerateInterpolator;
        final int n4 = Math.max(n2, n3);
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{n2, n3});
        valueAnimator.removeAllListeners();
        valueAnimator.removeAllUpdateListeners();
        valueAnimator.setDuration(200L);
        Object object = accelerateDecelerateInterpolator;
        accelerateDecelerateInterpolator = new AccelerateDecelerateInterpolator();
        valueAnimator.setInterpolator((TimeInterpolator)object);
        object = animatorUpdateListener;
        animatorUpdateListener = new ValueAnimator.AnimatorUpdateListener(this){

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                float f2 = ((Float)valueAnimator.getAnimatedValue()).floatValue() / (float)n4;
                view.getLayoutParams().height = (int)((float)n4 * f2);
                view.requestLayout();
            }
        };
        valueAnimator.addUpdateListener((ValueAnimator.AnimatorUpdateListener)object);
        valueAnimator.addListener(animatorListener);
        valueAnimator.start();
    }

    private void updateStatusAlignment(j j2, TextView textView, LinearLayout linearLayout) {
        int n2;
        TextView textView2 = textView;
        MessageListAdapter messageListAdapter = textView2.getResources();
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)textView2.getLayoutParams();
        if (j2 != null && j2.d) {
            RelativeLayout.LayoutParams layoutParams2 = layoutParams;
            layoutParams2.addRule(11);
            layoutParams2.addRule(5, 0);
            if (Build.VERSION.SDK_INT >= 17) {
                RelativeLayout.LayoutParams layoutParams3 = layoutParams;
                layoutParams3.addRule(21);
                layoutParams3.removeRule(18);
            }
        } else {
            RelativeLayout.LayoutParams layoutParams4 = layoutParams;
            layoutParams4.addRule(5, linearLayout.getId());
            layoutParams4.addRule(11, 0);
            if (Build.VERSION.SDK_INT >= 17) {
                RelativeLayout.LayoutParams layoutParams5 = layoutParams;
                layoutParams5.addRule(18, linearLayout.getId());
                layoutParams5.removeRule(21);
            }
        }
        boolean bl = j2 != null && j2.l;
        int n3 = (int)DpVisitor.toPixels(textView.getContext(), 4.0f);
        MessageListAdapter messageListAdapter2 = messageListAdapter;
        int n4 = messageListAdapter2.getDimensionPixelSize(R.dimen.AvMessagingSdk_messageAvatarMargin);
        layoutParams.rightMargin = n2 = messageListAdapter2.getDimensionPixelSize(R.dimen.AvMessagingSdk_conversationMargin);
        layoutParams.leftMargin = messageListAdapter.getDimensionPixelSize(R.dimen.AvMessagingSdk_messageAvatar) + n4 + n2;
        n4 = bl ? 0 : n3;
        layoutParams.bottomMargin = n4;
        n4 = bl ? 0 : n3 * -1;
        layoutParams.topMargin = n4;
        textView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    private String getRelativeTimestampText(Long l2, Resources resources) {
        if (l2 == null) {
            return null;
        }
        long l3 = System.currentTimeMillis() - l2;
        if (l3 < 60000L) {
            return resources.getString(R.string.AvMessagingSdk_relativeTimeJustNow);
        }
        if (l3 < 3600000L) {
            return resources.getString(R.string.AvMessagingSdk_relativeTimeMinute, new Object[]{Math.round(l3 / 60000L)});
        }
        if (l3 < 86400000L) {
            return resources.getString(R.string.AvMessagingSdk_relativeTimeHour, new Object[]{Math.round(l3 / 3600000L)});
        }
        if (l3 <= 604800000L) {
            return resources.getString(R.string.AvMessagingSdk_relativeTimeDay, new Object[]{Math.round(l3 / 86400000L)});
        }
        return null;
    }

    private String getShortTimestampText(Message message, Resources resources) {
        if (message != null && message.getDate() != null) {
            return new SimpleDateFormat(resources.getString(R.string.AvMessagingSdk_settings_shortTimestampFormat), Locale.getDefault()).format(message.getDate());
        }
        return null;
    }

    private SpannableStringBuilder getDeliveredStatusText(String string2, Resources resources) {
        StyleSpan styleSpan;
        SpannableString spannableString;
        Object object = resources.getString(R.string.AvMessagingSdk_messageStatusDelivered);
        resources = spannableString;
        Object object2 = object;
        resources((CharSequence)object);
        object = styleSpan;
        styleSpan = new StyleSpan(1);
        int n2 = ((String)object2).length();
        spannableString.setSpan(object, 0, n2, 33);
        return new SpannableStringBuilder().append((CharSequence)string2).append((CharSequence)". ").append((CharSequence)resources);
    }

    private SpannableStringBuilder getSeenStatusText(Long object, Resources resources) {
        StyleSpan styleSpan;
        SpannableString spannableString;
        String string2 = ((MessageListAdapter)((Object)string2)).getRelativeTimestampText((Long)object, resources);
        object = resources.getString(R.string.AvMessagingSdk_messageStatusSeen);
        resources = spannableString;
        Object object2 = object;
        resources((CharSequence)object);
        object = styleSpan;
        styleSpan = new StyleSpan(1);
        int n2 = ((String)object2).length();
        spannableString.setSpan(object, 0, n2, 33);
        return new SpannableStringBuilder().append((CharSequence)resources).append((CharSequence)" ").append((CharSequence)string2.toLowerCase());
    }

    private void animate(View view, MessageView messageView, boolean bl) {
        MessageView messageView2 = messageView;
        messageView2.measure(View.MeasureSpec.makeMeasureSpec((int)view.getMeasuredWidth(), (int)Integer.MIN_VALUE), 0);
        int n2 = messageView2.getMeasuredWidth();
        int n3 = messageView2.getMeasuredHeight();
        float f2 = bl ? 0.0f : (float)n2;
        MessageView messageView3 = messageView;
        messageView.setPivotX(f2);
        messageView3.setPivotY(n3);
        messageView3.setScaleX(0.0f);
        messageView3.setScaleY(0.0f);
        messageView3.animate().scaleX(1.0f).scaleY(1.0f).setDuration(500L).start();
    }

    private void addMessageInternal(Message message, g object) {
        j j2;
        g g2 = object;
        object = j2;
        ((j)object)();
        this.messageGroupList.add((j)object);
        ((j)object).c = message;
        ((j)object).d = message.isFromCurrentUser();
        ((j)object).e = message.getAvatarUrl();
        ((j)object).f = message.getName();
        ((j)object).g = message.getUserId();
        ((j)object).h = message.getUserRole();
        j2.i = message.getDate();
        boolean bl = g2 == g.b;
        Object object2 = object;
        ((j)object2).j = bl;
        ((j)object2).p = true;
        this.updateItemPositioning((j)object, this.messageGroupList.size() - 1, message);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateItemPositioning(j j2, int n2, Message message) {
        block7: {
            block8: {
                j j3;
                boolean bl;
                block9: {
                    if (this.messageGroupList.size() <= 1) break block8;
                    bl = true;
                    j3 = this.messageGroupList.get(n2 - 1);
                    if (j3 == null) {
                        return;
                    }
                    if (j3.d == j2.d) {
                        j3.o = bl = j2.a(j3);
                        j2.p = bl;
                    }
                    if (!j3.c.isCarousel()) break block9;
                    j j4 = j2;
                    j4.k = true;
                    j4.l = true;
                    break block7;
                }
                if (j3.d != j2.d) break block8;
                if (message.isCarousel()) {
                    j2.k = true;
                    j3.l = true;
                    break block7;
                } else if (!j2.d) {
                    j2.k = bl;
                    j3.l = bl;
                    break block7;
                } else {
                    j3.l = false;
                }
                break block7;
            }
            j2.k = true;
        }
        if (n2 == this.messageGroupList.size() - 1) {
            j j5 = j2;
            j5.l = true;
            j5.o = true;
        }
    }

    private boolean shouldPrintDate(j j2) {
        if (j2.m) {
            return false;
        }
        ListIterator<j> listIterator = this.messageGroupList.listIterator();
        j j3 = null;
        while (listIterator.hasNext()) {
            j j4 = listIterator.next();
            if (j3 == null || DateTimeUtils.getDeltaHours(j3.i, j4.i) > (long)this.hoursBetweenTimestamps) {
                j3 = j4;
            }
            if (j2 != j3) continue;
            return true;
        }
        return false;
    }

    private MessageView createMessageView(ViewGroup viewGroup) {
        RelativeLayout.LayoutParams layoutParams;
        RelativeLayout.LayoutParams layoutParams2 = layoutParams;
        layoutParams = new RelativeLayout.LayoutParams(-2, -2);
        MessageView messageView = new MessageView(viewGroup.getContext(), this);
        viewGroup.addView((View)messageView, (ViewGroup.LayoutParams)layoutParams2);
        return messageView;
    }

    private View inflate(View view, ViewGroup viewGroup, int n2) {
        Object object = viewGroup.getContext().getApplicationContext();
        if (view == null || view.getTag(n2) == null) {
            view = ((LayoutInflater)viewGroup.getContext().getSystemService("layout_inflater")).inflate(n2, viewGroup, false);
            if (n2 == R.layout.avmessagingsdk_list_message_header) {
                object = object.getPackageManager().getApplicationLabel(object.getApplicationInfo());
                object = viewGroup.getResources().getString(R.string.AvMessagingSdk_startOfConversation, new Object[]{object});
                viewGroup = (TextView)view.findViewById(R.id.avmessagingsdk_welcome_message);
                if (viewGroup != null) {
                    viewGroup.setText((CharSequence)object);
                }
            }
        }
        return view;
    }

    public void setMapsApiKey(String string2) {
        this.mapsApiKey = string2;
    }

    public void setHoursBetweenTimestamps(int n2) {
        this.hoursBetweenTimestamps = n2;
    }

    public void setHeaderViewResourceId(int n2) {
        this.headerViewResourceId = n2;
        this.notifyItemInserted(0);
    }

    public void setReplies(@NonNull List<MessageAction> list) {
        MessageListAdapter messageListAdapter = this;
        messageListAdapter.replies = list;
        messageListAdapter.notifyItemChanged(messageListAdapter.getItemCount() - 1);
        messageListAdapter.notifyRemoteMessageChanged(messageListAdapter.getItemCount() - 2);
        messageListAdapter.notifyRemoteMessageChanged(messageListAdapter.getItemCount() - 3);
    }

    public void setTypingActivity(@NonNull ConversationEvent conversationEvent) {
        MessageListAdapter messageListAdapter = this;
        boolean bl = this.hasTypingActivity();
        messageListAdapter.typingActivityItem = messageListAdapter.createTypingActivityItem(conversationEvent);
        if (messageListAdapter.messageGroupList.size() > 0) {
            ArrayList<j> arrayList = this.messageGroupList;
            j j2 = arrayList.get(arrayList.size() - 1);
            if (!j2.d) {
                String string2;
                String string3 = j2.f;
                if (string3 == null) {
                    string3 = "";
                }
                if ((string2 = this.typingActivityItem.f) == null) {
                    string2 = "";
                }
                boolean bl2 = !string2.isEmpty() && !string2.equals(string3);
                MessageListAdapter messageListAdapter2 = this;
                j2.l = bl2;
                j j3 = messageListAdapter2.typingActivityItem;
                j3.k = bl2;
                j3.p = bl2;
                messageListAdapter2.notifyItemChanged(messageListAdapter2.getItemCount() - 2);
            }
        }
        if (bl) {
            MessageListAdapter messageListAdapter3 = this;
            messageListAdapter3.notifyItemChanged(messageListAdapter3.getItemCount() - 1);
        } else {
            MessageListAdapter messageListAdapter4 = this;
            messageListAdapter4.notifyItemInserted(messageListAdapter4.getItemCount() - 1);
        }
    }

    public int getUnreadCount() {
        return this.unreadCount;
    }

    public void setUnreadCount(int n2) {
        this.unreadCount = n2;
        this.setFirstUnreadMessage();
    }

    public void removeTypingActivity() {
        if (this.hasTypingActivity()) {
            MessageListAdapter messageListAdapter = this;
            int n2 = messageListAdapter.getItemCount() - 1;
            if (messageListAdapter.shouldDisplayFooter()) {
                --n2;
            }
            this.notifyItemRemoved(n2);
            this.typingActivityItem = null;
            for (n2 = (v16032).messageGroupList.size() - 1; n2 >= 0; --n2) {
                j j2 = this.messageGroupList.get(n2);
                if (j2.d) continue;
                if (j2.l) break;
                j2.l = true;
                if (this.shouldDisplayHeader()) {
                    ++n2;
                }
                this.notifyRemoteMessageChanged(n2);
                break;
            }
        }
    }

    public void removeReplies() {
        if (this.replies != null) {
            MessageListAdapter messageListAdapter = this;
            messageListAdapter.replies = null;
            messageListAdapter.notifyItemRemoved(messageListAdapter.getItemCount() - 1);
        }
    }

    public void addMessage(Message message) {
        if (message != null) {
            MessageListAdapter messageListAdapter = this;
            messageListAdapter.addMessageInternal(message, g.a);
            messageListAdapter.notifyMessageAdded();
        }
    }

    public void addMessageWithAnimation(Message message) {
        if (message != null) {
            MessageListAdapter messageListAdapter = this;
            messageListAdapter.addMessageInternal(message, g.b);
            messageListAdapter.notifyMessageAdded();
        }
    }

    public void refreshLastMessage() {
        MessageListAdapter messageListAdapter = this;
        int n2 = messageListAdapter.messageGroupList.size() - 1;
        if (messageListAdapter.shouldDisplayHeader()) {
            ++n2;
        }
        this.notifyItemChanged(n2);
    }

    public void addMessagesWithAnimation(List<Message> list) {
        if (list != null && !list.isEmpty()) {
            int n2 = 0;
            while (n2 < list.size()) {
                Message message = list.get(n2);
                int n3 = n2 + 1;
                g g2 = n3 == list.size() ? g.b : g.a;
                this.addMessageInternal(message, g2);
                n2 = n3;
            }
            this.notifyMessagesAdded(list.size());
        }
    }

    public void setMessages(List<Message> list) {
        MessageListAdapter messageListAdapter = this;
        messageListAdapter.messageGroupList.clear();
        messageListAdapter.notifyDataSetChanged();
        if (list != null) {
            this.addMessages(list);
        }
    }

    public void removeMessage(Message message) {
        if (message != null) {
            for (int i2 = this.messageGroupList.size() - 1; i2 >= 0; --i2) {
                if (!this.messageGroupList.get((int)i2).c.equals((Object)message)) continue;
                MessageListAdapter messageListAdapter = this;
                messageListAdapter.messageGroupList.remove(i2);
                messageListAdapter.notifyDataSetChanged();
                return;
            }
        }
    }

    public void uploadStart(Message message) {
        this.addMessageWithAnimation(message);
    }

    public void uploadRetry(Message message) {
        this.updateMessage(message);
    }

    public void uploadEnd(Message message, AvMessagingSdkCallback.Response<Message> response) {
        int n2 = response.getStatus();
        if (n2 >= 200 && n2 < 300) {
            if (message.getImage() != null) {
                Message message2 = message;
                String string2 = message2.getMediaUrl();
                MessageViewBuilder.bitmapCache.put((Object)string2, (Object)message2.getImage());
                message.setImage(null);
            }
            if (message.getFile() != null) {
                message.setFile(null);
            }
        }
        this.updateMessage(message);
    }

    public void actionPostbackStart(MessageAction messageAction) {
        if (!MessageViewBuilder.postbacksInProgress.contains(messageAction)) {
            MessageViewBuilder.postbacksInProgress.add(messageAction);
            this.notifyDataSetChanged();
        }
    }

    public void actionPostbackEnd(MessageAction messageAction) {
        if (MessageViewBuilder.postbacksInProgress.contains(messageAction)) {
            MessageViewBuilder.postbacksInProgress.remove(messageAction);
            this.notifyDataSetChanged();
        }
    }

    public int getItemCount() {
        MessageListAdapter messageListAdapter = this;
        int n2 = messageListAdapter.messageGroupList.size();
        if (messageListAdapter.shouldDisplayHeader()) {
            ++n2;
        }
        if (this.shouldDisplayFooter()) {
            ++n2;
        }
        if (this.hasTypingActivity()) {
            ++n2;
        }
        return n2;
    }

    public long getItemId(int n2) {
        return n2;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup viewGroup, int n2) {
        if (n2 == 0) {
            MessageListAdapter messageListAdapter = messageListAdapter;
            int n3 = messageListAdapter.headerViewResourceId;
            View view = messageListAdapter.inflate(null, viewGroup, n3);
            return new i(view);
        }
        if (n2 == 2) {
            MessageListAdapter messageListAdapter = messageListAdapter.createRepliesView(viewGroup.getContext());
            return new h((View)messageListAdapter);
        }
        if (n2 == 1) {
            int n4 = R.layout.avmessagingsdk_list_message_item;
            View view = messageListAdapter.inflate(null, viewGroup, n4);
            return new k(view);
        }
        return null;
    }

    public void onBindViewHolder(RecyclerView.ViewHolder viewHolder, int n2) {
        if (viewHolder.getItemViewType() == 0) {
            ((i)viewHolder).a();
        } else if (viewHolder.getItemViewType() == 1) {
            this.getItemView(n2, (k)viewHolder);
        } else if (viewHolder.getItemViewType() == 2) {
            ((h)viewHolder).a.setReplies(this.replies);
        }
    }

    public void onViewAttachedToWindow(RecyclerView.ViewHolder object) {
        if (object instanceof k) {
            Object object2 = (k)((Object)object);
            object = ((k)((Object)object2)).i;
            if (object != null && object.m) {
                ((k)((Object)object2)).h.showTypingActivity();
            }
        }
    }

    public void updateMessage(Message message) {
        int n2 = -1;
        for (int i2 = this.messageGroupList.size() - 1; i2 >= 0; --i2) {
            if (!this.messageGroupList.get((int)i2).c.equals((Object)message)) continue;
            j j2 = this.messageGroupList.get(i2);
            this.messageGroupList.get(i2).c = message;
            if (n2 > -1) {
                MessageListAdapter messageListAdapter = this;
                messageListAdapter.removeMessage(messageListAdapter.messageGroupList.get((int)n2).c);
                return;
            }
            this.buildMessageView(j2);
            n2 = i2;
        }
    }

    public int getItemViewType(int n2) {
        if (n2 == 0 && this.headerViewResourceId != 0) {
            return 0;
        }
        if (n2 == this.getItemCount() - 1 && this.shouldDisplayFooter()) {
            return 2;
        }
        return 1;
    }

    @Override
    public void onActionClick(MessageAction messageAction) {
        this.delegate.onActionClick(messageAction);
    }

    @Override
    public void onMapClick(Coordinates coordinates) {
        this.delegate.onMapClick(coordinates);
    }

    @Override
    public void onFileClick(String string2) {
        this.delegate.onFileClick(string2);
    }

    @Override
    public void onReplySelected(MessageAction messageAction) {
        this.delegate.onActionClick(messageAction);
    }

    private static final class g
    extends Enum<g> {
        public static final /* enum */ g a;
        public static final /* enum */ g b;
        private static final /* synthetic */ g[] c;

        public static g[] values() {
            return (g[])c.clone();
        }

        public static g valueOf(String string2) {
            return Enum.valueOf(g.class, string2);
        }

        static {
            g g2;
            g g3;
            g g4 = g3;
            a = new g();
            g g5 = g2;
            b = new g();
            c = new g[]{g4, g5};
        }
    }

    private static class j {
        MessageView a;
        TextView b;
        Message c;
        boolean d = false;
        String e;
        String f;
        String g;
        String h;
        Date i;
        boolean j = false;
        boolean k = false;
        boolean l = false;
        boolean m = false;
        boolean n = false;
        boolean o = false;
        boolean p = false;

        private j() {
        }

        boolean a(j j2) {
            if (j2 == null) {
                return true;
            }
            return !(StringUtils.isEqual((String)j2.f, (String)this.f) && StringUtils.isEqual((String)j2.e, (String)this.e) && StringUtils.isEqual((String)j2.h, (String)this.h) && StringUtils.isEqual((String)j2.g, (String)this.g));
        }
    }

    private static class h
    extends RecyclerView.ViewHolder {
        RepliesView a;

        h(View view) {
            super(view);
            this.a = (RepliesView)view;
        }
    }

    private static class k
    extends RecyclerView.ViewHolder {
        AvatarImageView a;
        TextView b;
        RelativeLayout c;
        TextView d;
        TextView e;
        TextView f;
        LinearLayout g;
        MessageView h;
        j i;

        k(View view) {
            super(view);
            this.e = (TextView)view.findViewById(R.id.time);
            this.c = (RelativeLayout)view.findViewById(R.id.unreadCountContainer);
            this.d = (TextView)view.findViewById(R.id.unreadCount);
            this.b = (TextView)view.findViewById(R.id.text);
            this.a = (AvatarImageView)view.findViewById(R.id.avatar);
            this.f = (TextView)view.findViewById(R.id.status);
            this.g = (LinearLayout)view.findViewById(R.id.contentPanel);
        }
    }

    private static class i
    extends RecyclerView.ViewHolder {
        private final TextView a;
        private final TextView b;

        i(View view) {
            super(view);
            this.a = (TextView)view.findViewById(R.id.avmessagingsdk_welcome_message);
            this.b = (TextView)view.findViewById(R.id.avmessagingsdk_welcome_sub_message);
        }

        private void a() {
            boolean bl = TextUtils.isEmpty((CharSequence)this.a.getText()) && TextUtils.isEmpty((CharSequence)this.b.getText());
            View view = this.itemView;
            int n2 = bl ? 8 : 0;
            view.setVisibility(n2);
            view = this.a;
            n2 = bl ? 8 : 0;
            view.setVisibility(n2);
            view = this.b;
            n2 = bl ? 8 : 0;
            view.setVisibility(n2);
            ViewGroup.LayoutParams layoutParams = this.itemView.getLayoutParams();
            int n3 = bl ? 0 : -2;
            layoutParams.height = n3;
            this.itemView.setLayoutParams(layoutParams);
        }
    }

    public static interface Delegate {
        public void onClick(Message var1);

        public void onActionClick(MessageAction var1);

        public void onMapClick(Coordinates var1);

        public void onProductOffered();

        public Long getLastRead();

        public void onFileClick(String var1);
    }
}

