/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.ui.adapter;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.RelativeLayout;
import androidx.recyclerview.widget.RecyclerView;
import com.avaya.core.MessageItem;
import com.avaya.ui.R;
import com.avaya.ui.builder.MessageViewBuilder;
import com.avaya.ui.builder.MessageViewModel;
import com.avaya.ui.widget.AvatarImageView;
import com.avaya.ui.widget.MessageView;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class CarouselAdapter
extends RecyclerView.Adapter {
    private static final int VIEW_TYPE_AVATAR = 0;
    private static final int VIEW_TYPE_MESSAGE_ITEM = 1;
    private final Context context;
    private final MessageView.Delegate delegate;
    private final ArrayList<Item> messageItemGroupList = new ArrayList();
    private boolean shouldShowAvatar;
    private MessageViewModel.ImageStyle imageStyle = MessageViewModel.ImageStyle.HORIZONTAL;
    private String avatarUrl;

    public CarouselAdapter(Context context, MessageView.Delegate delegate) {
        this.context = context;
        this.delegate = delegate;
    }

    private Item getItem(int n2) {
        if ((n2 += -1) >= 0 && n2 < this.messageItemGroupList.size()) {
            return this.messageItemGroupList.get(n2);
        }
        return null;
    }

    private MessageView createMessageView(ViewGroup viewGroup) {
        MessageView messageView;
        MessageView messageView2 = messageView;
        CarouselAdapter carouselAdapter = carouselAdapter2;
        CarouselAdapter carouselAdapter2 = viewGroup.getContext();
        messageView2((Context)carouselAdapter2, carouselAdapter.delegate);
        viewGroup.addView((View)messageView2);
        return messageView;
    }

    private AvatarImageView createAvatarView(ViewGroup viewGroup) {
        AvatarImageView avatarImageView = new AvatarImageView(viewGroup.getContext());
        viewGroup.addView((View)avatarImageView);
        return avatarImageView;
    }

    private void addMessageItems(String string2, List<MessageItem> list) {
        if (list != null) {
            Iterator<MessageItem> iterator = list.iterator();
            while (iterator.hasNext()) {
                this.addMessageItemInternal(iterator.next(), string2);
            }
            MessageViewBuilder.precalculateCarouselHeight(this.context, string2, this.imageStyle, list);
            this.notifyItemRangeInserted(0, list.size());
        }
    }

    private void addMessageItemInternal(MessageItem messageItem, String string2) {
        Item item;
        Item item2 = item;
        item2();
        this.messageItemGroupList.add(item2);
        item2.messageItem = messageItem;
        item.messageId = string2;
        if (this.messageItemGroupList.size() > 1) {
            ArrayList<Item> arrayList = this.messageItemGroupList;
            arrayList.get((int)(arrayList.size() - 2)).isLastInList = false;
        } else {
            item2.isFirstInList = true;
        }
        item2.isLastInList = true;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup viewGroup, int n2) {
        CarouselAdapter carouselAdapter;
        if (n2 == 0) {
            RelativeLayout relativeLayout;
            carouselAdapter = relativeLayout;
            new RelativeLayout(viewGroup.getContext()).setLayoutParams((ViewGroup.LayoutParams)new RelativeLayout.LayoutParams(-2, -1));
            return new a((RelativeLayout)carouselAdapter);
        }
        if (n2 == 1) {
            FrameLayout frameLayout;
            carouselAdapter = frameLayout;
            frameLayout = new FrameLayout(viewGroup.getContext());
            return new MessageItemViewHolder((FrameLayout)carouselAdapter);
        }
        return null;
    }

    public void onBindViewHolder(RecyclerView.ViewHolder object, int n2) {
        CarouselAdapter carouselAdapter;
        if (object.getItemViewType() == 0) {
            object = (a)((Object)object);
            if (object.b == null) {
                object.b = carouselAdapter.createAvatarView((ViewGroup)object.a);
            }
            if (carouselAdapter.shouldShowAvatar) {
                object.b.show(carouselAdapter.avatarUrl);
            } else {
                object.b.showInvisible();
            }
        } else if (object.getItemViewType() == 1) {
            int n3;
            FrameLayout.LayoutParams layoutParams;
            object = (MessageItemViewHolder)((Object)object);
            object.item = carouselAdapter.getItem(n2);
            if (object.messageView == null) {
                object.messageView = carouselAdapter.createMessageView((ViewGroup)object.messageItemContainer);
            }
            Object object2 = object;
            int imageStyle = object2.messageView.getResources().getDimensionPixelSize(R.dimen.AvMessagingSdk_messageItemMargin);
            int n4 = object2.messageView.getResources().getDimensionPixelSize(R.dimen.AvMessagingSdk_conversationMargin);
            FrameLayout.LayoutParams layoutParams2 = layoutParams;
            layoutParams = new FrameLayout.LayoutParams(-2, -2);
            Item item = object2.item;
            int n5 = item.isFirstInList ? 0 : imageStyle;
            int n6 = 0;
            if (item.isLastInList) {
                n3 = n4;
            }
            layoutParams2.setMargins(n5, n6, n3, 0);
            object.messageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
            Item item2 = object.item;
            carouselAdapter = item2.messageItem;
            object = item2.messageId;
            MessageViewModel.ImageStyle imageStyle2 = carouselAdapter.imageStyle;
            boolean bl = item2.isFirstInList;
            boolean bl2 = item2.isLastInList;
            MessageViewBuilder.build(new MessageViewModel((MessageItem)carouselAdapter, (String)object, imageStyle2, bl, bl2), object.messageView);
        }
    }

    public int getItemCount() {
        return this.messageItemGroupList.size() + 1;
    }

    public int getItemViewType(int n2) {
        if (n2 == 0) {
            return 0;
        }
        return 1;
    }

    public void setImageStyle(MessageViewModel.ImageStyle imageStyle) {
        this.imageStyle = imageStyle;
    }

    public void setShouldShowAvatar(boolean bl) {
        this.shouldShowAvatar = bl;
    }

    public void setAvatarUrl(String string2) {
        this.avatarUrl = string2;
    }

    public void setMessageItems(String string2, List<MessageItem> list) {
        this.messageItemGroupList.clear();
        if (list != null) {
            this.addMessageItems(string2, list);
        } else {
            this.notifyDataSetChanged();
        }
    }

    private static class a
    extends RecyclerView.ViewHolder {
        RelativeLayout a;
        AvatarImageView b;

        a(RelativeLayout relativeLayout) {
            super((View)relativeLayout);
            this.a = relativeLayout;
        }
    }

    public static class MessageItemViewHolder
    extends RecyclerView.ViewHolder {
        public Item item;
        MessageView messageView;
        FrameLayout messageItemContainer;

        MessageItemViewHolder(FrameLayout frameLayout) {
            super((View)frameLayout);
            this.messageItemContainer = frameLayout;
        }
    }

    public static class Item {
        MessageItem messageItem;
        boolean isFirstInList = false;
        boolean isLastInList = false;
        public String messageId;
    }
}

