/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.core.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public final class StringUtils {
    public static final String EMPTY = "";

    private StringUtils() {
    }

    public static boolean isNotNullAndEqual(String string, String string2) {
        if (string != null && string2 != null) {
            return StringUtils.isEqual(string, string2);
        }
        return false;
    }

    public static boolean isNotNullAndNotEqual(String string, String string2) {
        if (string != null && string2 != null) {
            return StringUtils.isEqual(string, string2) ^ true;
        }
        return false;
    }

    public static boolean isEqual(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string != null && string2 != null) {
            return string.equals(string2);
        }
        return false;
    }

    public static boolean isEmpty(String string) {
        if (string == null) {
            return true;
        }
        return string.isEmpty();
    }

    public static boolean isEmptyOrBlank(String object) {
        if (object == null) {
            return true;
        }
        if (((String)object).isEmpty()) {
            return true;
        }
        char[] cArray = ((String)object).toCharArray();
        object = cArray;
        int n2 = cArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isWhitespace((char)object[i2])) continue;
            return false;
        }
        return true;
    }

    public static boolean anyEmpty(String ... stringArray) {
        if (stringArray == null) {
            return true;
        }
        boolean bl = false;
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            bl |= StringUtils.isEmpty(stringArray[i2]);
        }
        return bl;
    }

    public static String emptyIfNull(String string) {
        if (string == null) {
            return EMPTY;
        }
        return string;
    }

    public static String emptyIfNull(CharSequence charSequence) {
        if (charSequence == null) {
            return EMPTY;
        }
        return charSequence.toString();
    }

    public static String encode(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("UTF-8 is an unknown encoding!?");
        }
    }
}

