//
//  AVAConversationActivity.h
//  AvMessagingSdk
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

/**
 *  @abstract An activity type indicating that a participant of the converation started typing a response
 */
extern NSString *const AVAConversationActivityTypeTypingStart;

/**
 *  @abstract An activity type indicating that a participant of the converation stopped typing a response
 */
extern NSString *const AVAConversationActivityTypeTypingStop;

/**
 *  @abstract An activity type indicating that a participant of the converation recently read the user message
 *
 *  This event type is triggered for the current user when the conversation is read on a different device. 
 */
extern NSString *const AVAConversationActivityTypeConversationRead;

/**
 *  @abstract An activity type indicating that the current user was added to a conversation
 */
extern NSString *const AVAConversationActivityTypeConversationAdded;

/**
 *  @abstract An activity type indicating that the current user was removed from a conversation
 */
extern NSString *const AVAConversationActivityTypeConversationRemoved;

/**
 *  @abstract An activity type indicating that another user was added to a conversation that the current user is part of
 */
extern NSString *const AVAConversationActivityTypeParticipantAdded;

/**
 *  @abstract An activity type indicating that another user was removed from a conversation that the current user is part of
 */
extern NSString *const AVAConversationActivityTypeParticipantRemoved;

/**
 *  @abstract A key whose value is an NSString representing the appMaker name.
 *
 *  @discussion This key is used in the AVAConversationActivity data object.
 */
extern NSString *const AVAConversationActivityDataNameKey;

/**
 *  @abstract A key whose value is an NSString representing the URL of the appMaker avatar.
 *
 *  @discussion This key is used in the AVAConversationActivity data object.
 */
extern NSString *const AVAConversationActivityDataAvatarUrlKey;

@interface AVAConversationActivity : NSObject

/**
 *  @abstract the role of who is performing the typing activity
 */
@property(readonly, nullable) NSString *role;

/**
 *  @abstract the type of activity that is being triggered. Could be either
 *   - AVAConversationActivityTypeTypingStart
 *   - AVAConversationActivityTypeTypingStop
 *   - AVAConversationActivityTypeConversationRead
 *   - AVAConversationActivityTypeConversationAdded
 *   - AVAConversationActivityTypeConversationRemoved
 *   - AVAConversationActivityTypeParticipantAdded
 *   - AVAConversationActivityTypeParticipantRemoved
 */
@property(readonly) NSString *type;

/**
 *  @abstract additional data for this activity. Posible values are the appMaker's 'name' and/or 'avatarUrl'
 */
@property(readonly, nullable) NSDictionary *data;

/**
 *  @abstract conversationId for activity. Can be nil
 */
@property(readonly, nullable) NSString *conversationId;

/**
 *  @abstract date when the appMaker last read user messages for activities of type AVAConversationActivityTypeConversationRead
 */
@property(readonly, nullable) NSDate *appMakerLastRead;

/**
 * @abstract The appUserId if available, null otherwise
 *
 * available for AVAConversationActivityTypeParticipantAdded, AVAConversationActivityTypeParticipantRemoved
 */
@property(readonly, nullable) NSString *appUserId;

@end
NS_ASSUME_NONNULL_END
