//
//  AppDelegate.m
//  DemoApp
//
//  Copyright 2020 Avaya Inc
//  All rights reserved. Usage of this source is bound to the terms described the file
//  Avaya SDK EULA.txt, included in this SDK.
//  Avaya – Confidential & Proprietary. Use pursuant to your signed agreement or Avaya Policy.
//
//

#import "AppDelegate.h"
#import <AvMessagingSdk/AvMessagingSdk.h>
#import "MainViewController.h"

@implementation AppDelegate

- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions
{
    self.window = [[UIWindow alloc] initWithFrame:[[UIScreen mainScreen] bounds]];
    MainViewController* mainController = [[MainViewController alloc] init];

    self.window.rootViewController = mainController;
    [self.window makeKeyAndVisible];
    
    //Step1: Init App and User Settings
    [self initSettings];
    
    //Step2: Initialize SDK
    [self initSdkWithSettings];
    
    //Step3: Login as Guest or Authenticated User
    [self userSignIn];
    
    return YES;
}

-(void) initSettings {
    
    NSLog(@"Init Settings.");
    
    //Configure Integration ID (Contact Avaya DevOps Team to know your INTEGRATION_ID)
    self.integrationId = @"YOUR_INTEGRATION_ID";
    
    //YES if you wish to test with User Authentication
    [self setUserAuthEnabled:NO];
    
    //Configure AppUser details for Authenticated User
    self.firstName = @"";
    self.lastName = @"";
    self.userId = @"";
    self.authToken = @"";
    
    //Note: authtoken(JWT) and userId is required only for authenticated users.
    //Read development guide for more details on user authenticating.
}

-(void) initSdkWithSettings {
    
    NSLog(@"Init SDK with Settings.");
    
    //Contact Avaya Support to get your AppId
    AVASettings* settings = [AVASettings settingsWithIntegrationId: self.integrationId];
    
    //Set the color for chat bubble.
    settings.conversationAccentColor = [UIColor colorWithRed:39.0/255 green:149.0/255 blue:249.0/255 alpha:1.0];

    //Initialize SDK with settings.
    [AvMessagingSdk initWithSettings:settings completionHandler:nil];
}

-(void) userSignIn {
    
    if([self isUserAuthEnabled]){
        
        NSLog(@"userSignIn:: Authenticated User: SignIn");
        
        //You must login for Authenticate User.
        [AvMessagingSdk login:self.userId jwt: self.authToken completionHandler:^(NSError * _Nullable error, NSDictionary * _Nullable userInfo) {
            if (error == nil) {
                // Your code after login is complete
                NSLog(@"Login complete");
                //Set User's first name and last name.
                [AvMessagingSdk setUserFirstName:self.firstName lastName:self.lastName];
                [self addCustomUserProperties];
            } else {
                // Something went wrong during login. Your JWT might be invalid
                NSLog(@"Something went wrong during login. Your JWT might be invalid");
            }
        }];
        
    } else {
        NSLog(@"userSignIn:: Guest User: SignIn");
        //Set Guest User's first name and last name here.
        [AvMessagingSdk setUserFirstName:@"Guest" lastName:@"User"];
        [self addCustomUserProperties];
    }
    
    
}


-(void) addCustomUserProperties {
    //Set custom properties for appUser (optional)
    NSLog(@"userSignIn:: Setting Custom properties for AppUser");
    [[AVAUser currentUser] addProperties:@{
                                            @"premiumUser": @YES,
                                            @"numberOfPurchases": @20,
                                            @"itemsInCart": @3,
                                            @"couponCode": @"PREM_USR"
                                            }];
    
}

-(void) userLogout {
    //Refer SDK Development Guide to know more about logout.
    [AvMessagingSdk logoutWithCompletionHandler:^(NSError * _Nullable error, NSDictionary * _Nullable userInfo) {
        if (error == nil) {
            // Your code after login is complete
            NSLog(@"Logout complete");
        } else {
            // Something went wrong during login.
            NSLog(@"Something went wrong during logout.");
        }
    }];
}

- (void)applicationDidEnterBackground:(UIApplication *)application {
    NSLog(@"applicationDidEnterBackground");
}

- (void)applicationWillTerminate:(UIApplication *)application {
    NSLog(@"ApplicationWillTerminate");
}

@end
