/**
 * Copyright 2020 Avaya Inc. <br>
 * All rights reserved. Usage of this source is bound to the terms described the file
 * AVAYA SDK EULA.pdf, included in this SDK.<br>
 * Avaya – Confidential & Proprietary. Use pursuant to your signed agreement or Avaya Policy.
 */
package com.avaya.messaging;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;

import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;

import android.util.Log;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import com.avaya.core.AvMessagingSdk;
import com.avaya.core.AvMessagingSdkCallback;
import com.avaya.core.InitializationStatus;
import com.avaya.core.Message;
import com.avaya.core.User;
import com.avaya.ui.ConversationActivity;

import java.util.HashMap;
import java.util.Map;

public class IntroductionFragment extends Fragment {

    public IntroductionFragment() {
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        View rootView = inflater.inflate(R.layout.fragment_main, container, false);

        Button helpBtn = rootView.findViewById(R.id.button_start);
        helpBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                // Showing Start on the button click
                InitializationStatus status = AvMessagingSdk.getInitializationStatus();
                if(status == InitializationStatus.SUCCESS)
                {
                    ConversationActivity.builder()
                            .withFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
                            .show(getActivity());
                    addSomeCustomProperties();
                } else {
                    Toast toast = Toast.makeText(getActivity(),
                            "Avaya SDK are not initialized. Please setup settings ' ", Toast.LENGTH_LONG);
                    toast.show();
                }
            }
        });

        return rootView;
    }

    private void addSomeCustomProperties() {
        InitializationStatus status = AvMessagingSdk.getInitializationStatus();
        final DemoApplication application = (DemoApplication)getActivity().getApplication();
        AppSettings appSettings = application.getAppSettings();
        try {
            if (status == InitializationStatus.SUCCESS) {
                Map metadata = new HashMap<String, Object>();
                metadata.put("oceana_intrinsic_name", appSettings.getFirstName()+"test2");
                metadata.put(AvayaAttributes.CUSTOMER_TRIGGER, "CUSTOMER_Data22" + appSettings.getFirstName() + appSettings.getLastName());
                String convID = AvMessagingSdk.getConversation().getId();
                Log.i("init", "conversation ID after start is - " + convID);
                String header = "Conversation header 2-1_1";
                String iconUrl = "https://disk.yandex.ru/i/4RclbmlCFdq-NQ";
                if(convID != null) {
                    try {
                        ConversationActivity.close();
                        AvMessagingSdk.updateConversationById(AvMessagingSdk.getConversation().getId(), header,
                                "", iconUrl, metadata, new AvMessagingSdkCallback() {
                                    @Override
                                    public void run(@NonNull Response response) {
                                        Log.i("update conversation", "update result is - " + response.toString());
                                    }
                                });
                        ConversationActivity.builder()
                                .withFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
                                .show(getActivity());
                    } catch (Exception e) {
                        Log.i("Exception", e.getMessage() + "  " + e.getStackTrace());
                    }
                    Log.i("init", "Header is updated for - " + convID + " Header is - " + header +
                            " Icon is - " + iconUrl);
                    Log.i("logs", "meta data - " + metadata.toString());
                }
             }
        } catch (Exception e) {
            Log.i("logs - ", "Exception during update metadata result - " + e.getMessage());
        }
    }
//https://web-assets.zendesk.com/images/p-sunshine-conversations/img-sunco-footer@2x.jpg
    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        ((MainActivity) context).onSectionAttached(1);
    }
//https://web-assets.zendesk.com/images/p-sunshine-conversations/img-sunco-footer@2x.jpg
    //                AvMessagingSdk.getConversation().sendMessage(new Message("Hi","text",metadata));
//                    metadata.put("oceana_intrinsic_lastname", appSettings.getLastName());
//                metadata.put(("oceana_intrinsic_customfield_Gender2"), "test2 Gender update 32356");
    //                metadata.put(AvayaAttributes.CUSTOMER_LAST_NAME, "CUSTOMER_23456" + appSettings.getLastName()+"2");
}
