/**
 * Copyright 2020 Avaya Inc. <br>
 * All rights reserved. Usage of this source is bound to the terms described the file
 * AVAYA SDK EULA.pdf, included in this SDK.<br>
 * Avaya – Confidential & Proprietary. Use pursuant to your signed agreement or Avaya Policy.
 */
package com.avaya.messaging;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;

import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;

import android.util.Log;
import android.view.Gravity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

import com.avaya.core.AvMessagingSdk;
import com.avaya.core.AvMessagingSdkCallback;
import com.avaya.core.Conversation;
import com.avaya.core.InitializationStatus;
import com.avaya.core.Message;
import com.avaya.core.User;
import com.avaya.ui.ConversationActivity;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class IntroductionFragment extends Fragment {

    public IntroductionFragment() {
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {
        View rootView = inflater.inflate(R.layout.fragment_main, container, false);

        Button helpBtn = rootView.findViewById(R.id.button_start);
        helpBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                // Showing Start on the button click
                InitializationStatus status = AvMessagingSdk.getInitializationStatus();
                if(status == InitializationStatus.SUCCESS)
                {
                    ConversationActivity.builder()
                            .withFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
                            .show(getActivity());
                    loadConvo();
                } else {
                    Toast toast = Toast.makeText(getActivity(),
                            "Avaya SDK are not initialized. Please setup settings ' ", Toast.LENGTH_LONG);
                    toast.show();
                }
            }
        });

        return rootView;
    }

    private void loadConvo() {
        Log.d("titleTest", "Grabbing user's conversations");
        AvMessagingSdk.getConversationsList(new AvMessagingSdkCallback<List<Conversation>>() {
            @Override
            public void run(@NonNull Response<List<Conversation>> response) {
                List<Conversation> conversations = response.getData();
                if(conversations != null) {
                    Conversation firstConvo = conversations.get(0);
                    //for new conversation immedietly after creation this instance will null.
                    //update is possible after first messages
                    if (firstConvo != null) {
                        AvMessagingSdk.loadConversation(firstConvo.getId(), new AvMessagingSdkCallback<Conversation>() {
                            @Override
                            public void run(@NonNull Response<Conversation> response) {
                                Log.d("titleTest", "Loaded conversation, attempting to update title and icon.");
                                updateConvo();
                            }
                        });
                    }
                }
            }
        });
    }

    private void updateConvo() {
        final DemoApplication application = (DemoApplication)getActivity().getApplication();
        AppSettings appSettings = application.getAppSettings();
        if (AvMessagingSdk.getConversation().getId() != null) {
            Map metadata = new HashMap<String, Object>();
            metadata.put("oceana_intrinsic_name", "any name");
            metadata.put(AvayaAttributes.CUSTOMER_TRIGGER, "CUSTOMER_Data22" + appSettings.getFirstName() + appSettings.getLastName());
            metadata.put(AvayaAttributes.CUSTOMER_LAST_NAME, "CUSTOMER_23456" + appSettings.getLastName()+"2");
//          metadata.put("oceana_intrinsic_lastname", appSettings.getLastName());
//          metadata.put(("oceana_intrinsic_customfield_Gender2"), "test2 Gender update 32356");
            String convId = AvMessagingSdk.getConversation().getId();
            String title = "Updated conversation title";
            ConversationActivity.close();
            AvMessagingSdk.updateConversationById(convId, title, null, "https://web-assets.zendesk.com/images/p-sunshine-conversations/img-sunco-footer@2x.jpg", metadata, new AvMessagingSdkCallback(){
                @Override
                public void run(@NonNull Response response) {
                    Log.i("response", "responce is - " + response);
                    ConversationActivity.builder()
                            .withFlags(Intent.FLAG_ACTIVITY_NEW_TASK)
                            .show(getActivity());
                }
            });
            Log.d("titleTest", "Conversation title updated.");
        }
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        ((MainActivity) context).onSectionAttached(1);
    }

}
