//
//  ViewController.swift
//  DemoAppSwift
//
//  Created by Developer on 25.07.2020.
//  Copyright © 2020 Developer. All rights reserved.
//

import Foundation
import AvMessagingSdk

class ViewController: UIViewController, UITextFieldDelegate {
    
    var isInitSDK = false
    var isLoggedIn = false
    var integrationID = ""
    var firstName = ""
    var lastName = ""
    var userID = ""
    var jwt = ""
    var isAuthUser = false
    var customKey = ""
    var customValue = ""
    let defaults = UserDefaults.standard
    
    @IBOutlet var customKeyField: UITextField!
    @IBOutlet var customValueField: UITextField!
    
    @IBOutlet var InitButton: UIButton!
    @IBOutlet var StartButton: UIButton!
    @IBOutlet var interactionIDField: UITextField!
    @IBOutlet var firstNameTextField: UITextField!
    @IBOutlet var lastNameTextField: UITextField!
    @IBOutlet var custim: UITextField!
    
    @IBOutlet var AuthSettingsButton: UIButton!
    
    @IBAction func AuthSettingsButPress(_ sender: UIButton) {
        requestChatAlert()
        
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()
        interactionIDField.delegate = self
        firstNameTextField.delegate = self
        lastNameTextField.delegate = self
        
        InitButton.isHidden = true
        StartButton.isHidden = true
        AuthSettingsButton.isHidden = true
        let savedIntegrationID = defaults.object(forKey: "integrationID") as? String ?? ""
        if (savedIntegrationID != "") {
            interactionIDField.text = savedIntegrationID
            self.integrationID = savedIntegrationID
            InitButton.isHidden = false
        }
        let savedfirstName = defaults.object(forKey: "firstName") as? String ?? ""
        if (savedIntegrationID != "") {
            firstNameTextField.text = savedfirstName
            self.firstName = savedfirstName
        }
        let savedlastName = defaults.object(forKey: "lastName") as? String ?? ""
        if (savedlastName != "") {
            lastNameTextField.text = savedlastName
            self.lastName = savedlastName
        }
        let saveduserid = defaults.object(forKey: "userid") as? String ?? ""
        if (saveduserid != "") {
            self.userID = saveduserid
        }
        let savedJwt = defaults.object(forKey: "jwt") as? String ?? ""
        if (savedJwt != "") {
            self.jwt = savedJwt
        }
        
        let savedkey = defaults.object(forKey: "customKey") as? String ?? ""
        if (savedkey != "") {
            customKeyField.text = savedkey
            self.customKey = savedkey
        }
        let savedValue = defaults.object(forKey: "customValue") as? String ?? ""
        if (savedValue != "") {
            customValueField.text = savedValue
            self.customValue = savedValue
        }
    }
   
    
    @IBAction func onButton(_ sender: Any) {
        self.logout()
    }
    
    @IBAction func initButtonPressed(_ sender: UIButton) {
        initSDK()
    }
    
    @IBAction func AuthUserSwitch(_ sender: Any) {
        let switchAuthUser = sender as! UISwitch
        isAuthUser = switchAuthUser.isOn
        AuthSettingsButton.isHidden = !switchAuthUser.isOn
        if (switchAuthUser.isOn) {
            requestChatAlert()
        }
    }
    
    @IBAction func handleCustomKey(_ sender: UITextField) {
        self.customKey = sender.text!
        defaults.set(customKey, forKey: "customKey")
    }
    
    @IBAction func handleCustomValue(_ sender: UITextField) {
        self.customValue = sender.text!
        defaults.set(customValue, forKey: "customValue")
    }
    
    
    @IBAction func handleInteractionID(_ sender: UITextField) {
        let newValue : String! = sender.text
        if (!newValue.elementsEqual(integrationID)) {
            InitButton.isEnabled = true
            integrationID = newValue
            InitButton.isHidden = false
            defaults.set(newValue, forKey: "integrationID")
        }
    }
    
    func textFieldShouldReturn(_ textField: UITextField) -> Bool {
        textField.resignFirstResponder()
        return true
    }
    
    @IBAction func handleFirstName(_ sender: UITextField) {
        firstName = sender.text!
        defaults.set(firstName, forKey: "firstName")
    }
    
    @IBAction func handleLastName(_ sender: UITextField) {
        lastName = sender.text!
        defaults.set(lastName, forKey: "lastName")
    }
    
    @IBAction func handleUserID(_ sender: UITextField) {
        userID = sender.text!
    }
    
    @IBAction func handleJWT(_ sender: UITextField) {
        jwt = sender.text!
    }
    
    private func initSDK() {
        let settings = AVASettings(integrationId: integrationID)
        settings.conversationAccentColor = UIColor(red: 39.0/255, green: 149.0/255, blue: 249.0/255, alpha: 1)
        AvMessagingSdk.initWith(settings) { (error: Error?, userInfo: [AnyHashable : Any]?) in
            if (error == nil) {
                self.isInitSDK = true
                self.StartButton.isEnabled = true
                self.StartButton.isHidden = false
            }else{
                self.isInitSDK = false
            }
                    
        }

    }
    
    private func logout() {
        AvMessagingSdk.logout(){ ( error:Error? , userInfo:[AnyHashable : Any]?) in
            if (error == nil) {
                // Your code after login is complete
                self.login()
            }else{
                // Something went wrong during login. Your JWT might be invalid
                self.login()
            }
            
        }
    }
    
    private func login() {
        if(self.userID != "" && isAuthUser) {
            AvMessagingSdk.login(self.userID, jwt: self.jwt)
            { ( error:Error? , userInfo:[AnyHashable : Any]?) in
                if (error == nil) {
                    // Your code after login is complete
                    self.addMetadata()
                    AvMessagingSdk.show()
                }else{
                    // Something went wrong during login. Your JWT might be invalid
                }
                
            }
        } else {
            self.addMetadata()
            AvMessagingSdk.show ()
            
        }
    }
    
    private func addMetadata() {
        let customMetadata: [AnyHashable: Any] = [
            AnyHashable("oceana_intrinsic_customfield_" + self.customKey): self.customValue,
            AnyHashable("oceana_intrinsic_name"): self.firstName,
            AnyHashable("oceana_intrinsic_lastname"): self.lastName
        ]
        let customMessage = AVAMessage(text: "welcome text",payload: "text", metadata: customMetadata)
        AvMessagingSdk.conversation()?.sendMessage(customMessage)
    }
    
    private func setExtendedParameters() {
        AvMessagingSdk.setUserFirstName(self.firstName, lastName: self.lastName)
    }
    
    func requestChatAlert(){
        print("requestChatAlert()")
        
        //declaring the alert dialog for the chat request
        let alert: UIAlertController = UIAlertController(title: "", message: "Request a Chat", preferredStyle: .alert)
        alert.view.autoresizesSubviews = true
//        alert.view.addSubview(self.addSwitch())
        
        //alert.view.addSubview(self.addLabel())
        //textfields to request the name and email of the customer
        
        alert.addTextField( configurationHandler: { (textField) -> Void in
            textField.placeholder = "Enter the UserID"
            textField.text = self.userID
        })
        alert.addTextField (configurationHandler: { (textField) -> Void in
            textField.placeholder = "Enter the correct JWT"
            textField.text = self.jwt
        })
        
        //extract the text from the alert text fields on "OK"
        alert.addAction(UIAlertAction(title: "OK", style: .default, handler: { (action)-> Void in
            
            
            let userID_tf = alert.textFields![0] as UITextField
            let jwt_tf = alert.textFields![1] as UITextField
            let userid = userID_tf.text
            let jwt = jwt_tf.text
            self.userID = userid!
            self.jwt = jwt!
            self.defaults.set(userid, forKey: "userid")
            self.defaults.set(jwt, forKey: "jwt")
            
        }))
        
        alert.addAction(UIAlertAction(title: "Close", style: .cancel, handler: { (action) -> Void in
            print("Dialog Canceled")
        }))
        
        self.present(alert, animated: true, completion: nil)
        
    }
    
    
}
