package com.avaya.messaging;

import android.app.Activity;
import android.app.Application;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;

public class AppSettings {

    private SharedPreferences myPreferences;
    private SharedPreferences.Editor myEditor;
    private final String[] mapKeys = {"IntegrationId", "AppId", "Jwt", "AppUserId", "isUserAuthEnabled",
    "FirstName","LastName"};

    public AppSettings(Activity activity) {
        myPreferences = PreferenceManager.getDefaultSharedPreferences(activity);
        myEditor = myPreferences.edit();
    }

    public String getIntegrationId() {
        return myPreferences.getString(mapKeys[0], "");
    }

    public void setIntegrationId(String integrationId) {
        myEditor.putString(mapKeys[0], integrationId);
        myEditor.commit();
    }

//    private String integrationId = "";

    public String getAppId() {
        return myPreferences.getString(mapKeys[1], "");
    }

    public void setAppId(String appId){
        myEditor.putString(mapKeys[1], appId);
        myEditor.commit();
    }

//    private String appId = "";

    public String getJwt() {
        return myPreferences.getString(mapKeys[2], "");
    }

    public void setJwt(String jwt){
        myEditor.putString(mapKeys[2], jwt);
        myEditor.commit();
    }

//    private String jwt = "";

    public String getAppUserId() {
        return myPreferences.getString(mapKeys[3], "");
    }

    public void setAppUserId(String appUserId){
        myEditor.putString(mapKeys[3], appUserId);
        myEditor.commit();
    }

//    private String appUserId = "";

    public boolean isUserAuthEnabled() {
        return myPreferences.getBoolean(mapKeys[4], false);
    }

    public void setUserAuthEnabled(boolean userAuthEnabled) {
        myEditor.putBoolean(mapKeys[4], userAuthEnabled);
        myEditor.commit();
    }

//    private boolean userAuthEnabled = false;

    public String getFirstName() {
        return myPreferences.getString(mapKeys[5],"");
    }

    public void setFirstName(String firstName) {

        myEditor.putString(mapKeys[5],firstName);
        myEditor.commit();
    }

//    private String firstName = "";

    public String getLastName() {
        return myPreferences.getString(mapKeys[6], "");
    }

    public void setLastName(String lastName) {

        myEditor.putString(mapKeys[6], lastName);
        myEditor.commit();
    }

//    private String lastName = "";
}
