//
//  MainViewController.m
//  DemoApp
//
//  Copyright 2020 Avaya Inc
//  All rights reserved. Usage of this source is bound to the terms described the file
//  Avaya SDK EULA.txt, included in this SDK.
//  Avaya – Confidential & Proprietary. Use pursuant to your signed agreement or Avaya Policy.
//
//

#import "MainViewController.h"
#import "MainContentView.h"
#import <AvMessagingSdk/AvMessagingSdk.h>

@interface MainViewController ()

@property NSString* initialURL;
@property MainContentView* contentView;

@end

@implementation MainViewController

-(void)viewDidLoad
{
    [super viewDidLoad];

    self.view.backgroundColor = [UIColor whiteColor];

    [self initContentView];
}

-(void)initContentView
{
    self.contentView = [[MainContentView alloc] initWithFrame:self.view.bounds];
    [self.contentView.button addTarget:self action:@selector(launch) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:self.contentView];
}

-(void)viewDidLayoutSubviews
{
    [super viewDidLayoutSubviews];
    self.contentView.frame = self.view.bounds;
}

-(void)launch
{
    [AvMessagingSdk show];
}


@end
