/**
 * Copyright 2020 Avaya Inc. <br>
 * All rights reserved. Usage of this source is bound to the terms described the file
 * AVAYA SDK EULA.pdf, included in this SDK.<br>
 * Avaya – Confidential & Proprietary. Use pursuant to your signed agreement or Avaya Policy.
 */
package com.avaya.messaging;

import android.content.Context;
import android.os.Bundle;
import androidx.fragment.app.Fragment;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.EditText;
import android.util.Log;


public class SettingsFragment extends Fragment {
    private EditText integrationIdField;
    private EditText jwtField;
    private EditText userIdField;
    private EditText firstNameField;
    private EditText lastNameField;
    private CheckBox userAuthEnabled;

    public SettingsFragment() {

    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {

        View settingsView = inflater.inflate(
                R.layout.fragment_settings, container, false);
        ((DemoApplication)getActivity().getApplication()).createAppSettings(getActivity());
        final DemoApplication application = (DemoApplication)getActivity().getApplication();
        AppSettings appSettings = application.getAppSettings();
        integrationIdField = settingsView.findViewById(R.id.editText_integration_id);
        integrationIdField.setText(appSettings.getIntegrationId());
        jwtField = settingsView.findViewById(R.id.editText_jwt);
        jwtField.setText(appSettings.getJwt());
        userIdField = settingsView.findViewById(R.id.editText_user_id);
        userIdField.setText(appSettings.getAppUserId());
        userAuthEnabled = settingsView.findViewById(R.id.UserAuthEnabled);
        userAuthEnabled.setChecked(appSettings.isUserAuthEnabled());
        firstNameField = settingsView.findViewById(R.id.editText_first_name);
        firstNameField.setText(appSettings.getFirstName());
        lastNameField = settingsView.findViewById(R.id.editText_last_name);
        lastNameField.setText(appSettings.getLastName());
        ;
        final Button buttonInit = settingsView.findViewById(R.id.button_init);
        buttonInit.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                boolean isIntegrationIdChanged = false;
                AppSettings appSettings = application.getAppSettings();
                Log.e("SettingsLog", "IntegrationID in settings. -"+ appSettings.getIntegrationId());
                Log.e("SettingsLog", "IntegrationID on screen. -" + integrationIdField.getText().toString());
                isIntegrationIdChanged = appSettings.getIntegrationId().equalsIgnoreCase(integrationIdField.getText().toString());
                appSettings.setIntegrationId(integrationIdField.getText().toString());
                appSettings.
                        setJwt(jwtField.getText().toString());
                appSettings.setAppUserId(userIdField.getText().toString());
                appSettings.setFirstName(firstNameField.getText().toString());
                appSettings.setLastName(lastNameField.getText().toString());
                boolean result = userAuthEnabled.isChecked();
                appSettings.setUserAuthEnabled(result);

                if(!isIntegrationIdChanged) {
                    Log.e("SettingsLog", "IntegrationID changed. New Initialisation");
                    application.intSDK();
                } else {
                    Log.e("SettingsLog", "IntegrationID not changed. Relogin");
                    application.relogin();
                }
            }
        });

        integrationIdField.setOnFocusChangeListener(new View.OnFocusChangeListener() {

            @Override
            public void onFocusChange(View v, boolean hasFocus) {
                if (!hasFocus) {
                    hideKeyboard();
                }
            }
        });

        settingsView.setOnTouchListener(new View.OnTouchListener() {

            @Override
            public boolean onTouch(final View v, final MotionEvent event) {
                hideKeyboard();
                return false;
            }
        });

        return settingsView;
    }

    @Override
    public void onAttach(Context context) {
        super.onAttach(context);
        ((MainActivity) context).onSectionAttached(3);
    }

    private void hideKeyboard() {
        InputMethodManager imm = (InputMethodManager)getActivity().getSystemService(Context.INPUT_METHOD_SERVICE);
        imm.hideSoftInputFromWindow(integrationIdField.getWindowToken(), 0);
    }
}
