/**
 * Copyright 2020 Avaya Inc. <br>
 * All rights reserved. Usage of this source is bound to the terms described the file
 * AVAYA SDK EULA.pdf, included in this SDK.<br>
 * Avaya – Confidential & Proprietary. Use pursuant to your signed agreement or Avaya Policy.
 */
package com.avaya.messaging;

import static com.avaya.core.InitializationStatus.UNKNOWN;

import android.app.Activity;
import android.app.Application;
import androidx.annotation.NonNull;
import android.util.Log;
import android.widget.Toast;

import com.avaya.core.AuthenticationCallback;
import com.avaya.core.AuthenticationDelegate;
import com.avaya.core.AuthenticationError;
import com.avaya.core.AvMessagingSdk;
import com.avaya.core.AvMessagingSdkCallback;
import com.avaya.core.InitializationStatus;

import com.avaya.core.LogoutResult;

import com.avaya.core.Settings;
import com.avaya.core.User;

import java.util.Date;


public class DemoApplication extends Application {

    public AppSettings appSettings;
    private boolean waitingForLogin = false;

    public  void createAppSettings(Activity activity) {
        if (appSettings == null) {
            appSettings = new AppSettings(activity);
        }
    }

    public AppSettings getAppSettings() {
        return appSettings;
    }

    public void intSDK() {
        //D: callback: called when SDK init is complete.
        Settings settings = new Settings(appSettings.getIntegrationId());
        //C: additional setting for auth user
        if(appSettings.isUserAuthEnabled()){
            //Create Authentication Delegate to handle expiry of JWT Tokens
            settings.setAuthenticationDelegate(new AuthenticationDelegate() {
                @Override
                public void onInvalidAuth(AuthenticationError authenticationError, AuthenticationCallback authenticationCallback) {
                    Log.e("AuthDelegate: ", "onInvalidAuth: Your JWT might be invalid");
                    // retrieve new token and set new token
                    //authenticationCallback.updateToken(updatedToken);
                }
            });
        }

        //E: Init SDK with Settings
        AvMessagingSdk.init(this, settings, new AvMessagingSdkCallback<InitializationStatus>() {
            @Override
            public void run(@NonNull Response<InitializationStatus> response) {
                Toast toast;
                if (response.getData() == InitializationStatus.SUCCESS) {
                    // Smooch is ready to use
                    Log.e("SdkCallback", "SdkCallback during Init. Will Try relogin. Responce - " + response.getData().toString());
                    toast = Toast.makeText(getApplicationContext(),
                            "Avaya SDK re-initialized with new settings ' ", Toast.LENGTH_LONG);
                    relogin();
                } else {
                    toast = Toast.makeText(getApplicationContext(),
                            "Error during Avaya SDK re-initialized with new settings ' ", Toast.LENGTH_LONG);
                    Log.e("SdkCallback", "SdkCallback during Init. Responce - " + response.getData().toString());
                }
                toast.show();
            }
        });
    }

    public void relogin() {
        try {
            InitializationStatus status = AvMessagingSdk.getInitializationStatus();
            if (status == UNKNOWN) {
                intSDK();
            } else {
                logout();
                waitingForLogin = true;
            }
//            login();
        } catch (Exception e) {
            Log.e("relogin", "Exception during Init.  - " + e.getMessage());
        }
    }

    private void login() {
        if(appSettings.isUserAuthEnabled()) {

            String userID = appSettings.getAppUserId();
            String jwt = appSettings.getJwt();
            User.getCurrentUser().setEmail(appSettings.getAppUserId());
            User.getCurrentUser().setFirstName(appSettings.getFirstName());
            User.getCurrentUser().setLastName(appSettings.getLastName());
            AvMessagingSdk.login(userID, jwt, new AvMessagingSdkCallback() {
                @Override
                public void run(Response response) {
                    Toast toast;
                    if (response.getData() == InitializationStatus.SUCCESS) {
                        // Your code after login is complete
                        toast = Toast.makeText(getApplicationContext(),
                                "Login Complete for userId: " + appSettings.getAppUserId(), Toast.LENGTH_LONG);
                        Log.i("Login: ", "Login Complete for userId: " + appSettings.getAppUserId());
                        Log.i("login", "Start pause");
                        try {
                            Thread.sleep(5000);
                            Log.i("login", "End pause");
                            String convID = AvMessagingSdk.getConversation().getId();
                            Log.i("init", "conversation ID is - " + convID);
                            if(convID != null) {
                                AvMessagingSdk.updateConversationById(convID, "Conversation header", "", "https://disk.yandex.ru/i/4RclbmlCFdq-NQ",  null, null);
                                Log.i("init", "Header is updated for - " + convID);
                            }
                        } catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    } else {
                        // Something went wrong during login. Your JWT might be invalid
                        toast = Toast.makeText(getApplicationContext(),
                                "Login Failed. Something went wrong during login. Your JWT might be invalid", Toast.LENGTH_LONG);
                        Log.e("Login: ", "Login Failed. Something went wrong during login. Your JWT might be invalid" + response.getError());
                    }
                    toast.show();
                }
            });
        } else {
            //Guest User flow - set Guest user
            User.getCurrentUser().setFirstName(appSettings.getFirstName());
            User.getCurrentUser().setLastName(appSettings.getLastName());
            User.getCurrentUser().setEmail(appSettings.getAppId());
            User.getCurrentUser().setSignedUpAt(new Date());
        }
    }

    private void logout() {
        AvMessagingSdk.logout(new AvMessagingSdkCallback<LogoutResult>() {
            @Override
            public void run(@NonNull Response<LogoutResult> response) {
                Log.i("logs - ", "logout result - " + response.getStatus());
                if(waitingForLogin) {
                    login();
                    waitingForLogin = false;
                }
            }
        });
    }

    @Override
    public void onCreate() {
        super.onCreate();
        AvMessagingSdk.init(this);
    }


}


