# Installation guide

## Swift Package Manager installation guide

Add the AvMessagingSdk.xcframework library to your Xcode project via Swift Package Manager by following the steps below

1. In Xcode, select File > Swift Packages > Add Package Dependency.

1. Copy the url of the repository where the library is maintained, and paste it into the search bar.

1. Follow Xcode's instructions to add AvMessagingSdk as a dependency.

For more details on how to add the package to your project, see the [Apple documentation](https://developer.apple.com/documentation/swift_packages/adding_package_dependencies_to_your_app).

## CocoaPods installation guide

Add the AvMessagingSdk.xcframework library to your Xcode project via CocoaPods by following the steps below

1. First, install [CocoaPods](https://cocoapods.org/) if it isn't already

```bash
gem install cocoapods
```

2. Copy the `AvMessagingSdk.xcframework` and `AvMessagingSdk.podspec` files somewhere in your project directory, for example in `vendor/AvMessagingSdk`
3. Add the AvMessagingSdk dependency to your [Podfile](https://guides.cocoapods.org/using/the-podfile.html), using a local `path` that points to the directory in step 2

```ruby
target 'YourApp' do
    pod 'AvMessagingSdk', :path => 'vendor/AvMessagingSdk'
end
```

4. Install the pod

```bash
pod install
```

5. Open the generated `.xcworkspace` file and add the following keys to your app's Info.plist file (replacing the values if desired):

```xml
<key>NSPhotoLibraryUsageDescription</key>
<string>${PRODUCT_NAME} will read your photo library to gather additional information</string>
<key>NSPhotoLibraryAddUsageDescription</key>
<string>${PRODUCT_NAME} will write to your photo library to gather additional information</string>
<key>NSCameraUsageDescription</key>
<string>${PRODUCT_NAME} will use your camera to gather additional information</string>
```

6. Start using the framework in your code.

Swift:

```swift
AvMessagingSdk.initWith(AVASettings(integrationId: "YOUR_INTEGRATION_ID")) { (error, userInfo) in
    // Your code after init is complete
}
```

Objective-C:

```objc
#import <AvMessagingSdk/AvMessagingSdk.h>

[AvMessagingSdk initWithSettings:[AVASettings settingsWithIntegrationId:@"YOUR_INTEGRATION_ID"] completionHandler:^(NSError * _Nullable error, NSDictionary * _Nullable userInfo) {
    // Your code after init is complete
}];
```
