/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.generic.channel.testclient;

import com.avaya.collaboration.authorization.AccessToken;
import com.avaya.collaboration.authorization.AuthorizationClientHelper;
import com.avaya.generic.channel.testclient.Configuration;
import com.avaya.generic.channel.testclient.utils.Utils;
import java.io.FileInputStream;
import java.security.KeyStore;

public class Authorization {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static AccessToken getAccessToken(Configuration configuration) throws Exception {
        String authorizationUrl = Utils.buildHttpSecureUrl(configuration.getAuthorizationHost() + ":" + configuration.getAuthPort(), "/services/AuthorizationService/token");
        Utils.println("Loading client certificate from %s ...", configuration.getKeyStore());
        KeyStore clientKeyStore = KeyStore.getInstance("JKS");
        try (FileInputStream fis = new FileInputStream(configuration.getKeyStore());){
            clientKeyStore.load(fis, configuration.getKeyStorePassword().toCharArray());
        }
        Utils.println("Loading server certificate from %s ...", configuration.getTrustStore());
        KeyStore clientTrustStore = KeyStore.getInstance("JKS");
        try (FileInputStream fis = new FileInputStream(configuration.getTrustStore());){
            clientTrustStore.load(fis, configuration.getTrustStorePassword().toCharArray());
        }
        AuthorizationClientHelper authorizationClientHelper = null;
        try {
            Utils.println("Getting access token from %s ...", authorizationUrl);
            authorizationClientHelper = new AuthorizationClientHelper.Builder().tokenEndpoint(authorizationUrl).clientIdentifier(configuration.getClientId()).keyStore(clientKeyStore, configuration.getKeyStorePassword(), configuration.getKeyAlias()).trustStore(clientTrustStore).build();
            AccessToken accessToken = authorizationClientHelper.getAccessToken();
            Utils.println("Token received");
            AccessToken accessToken2 = accessToken;
            return accessToken2;
        }
        finally {
            if (authorizationClientHelper != null) {
                authorizationClientHelper.shutdown();
            }
        }
    }

    private Authorization() {
    }
}

