/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.generic.channel.testclient.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;

public class FileIO {
    private BufferedReader reader = null;
    private BufferedWriter writer = null;

    public String[] open(String[] args) throws IOException {
        return this.openImpl(args, new String[]{"<<", ">", ">>"});
    }

    public String[] openForReading(String[] args) throws IOException {
        return this.openImpl(args, new String[]{"<<"});
    }

    public String[] openForWriting(String[] args) throws IOException {
        return this.openImpl(args, new String[]{">", ">>"});
    }

    public boolean hasFile() {
        return this.hasReader() || this.hasWriter();
    }

    public boolean hasReader() {
        return this.reader != null;
    }

    public boolean hasWriter() {
        return this.writer != null;
    }

    public String readLine() throws IOException {
        String line;
        if (this.reader == null) {
            return null;
        }
        do {
            if ((line = this.reader.readLine()) != null) continue;
            return null;
        } while ((line = line.trim()).isEmpty());
        return line;
    }

    public void writeLine(String line) throws IOException {
        if (this.writer != null) {
            this.writer.write(line);
            this.writer.newLine();
            this.writer.flush();
        }
    }

    public void close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
    }

    private String[] openImpl(String[] args, String[] expectedOperators) throws FileNotFoundException, IOException {
        this.close();
        int length = args.length;
        if (length < 2) {
            return args;
        }
        String operator = args[length - 2];
        if (!Arrays.asList(expectedOperators).contains(operator)) {
            return args;
        }
        String fileName = args[length - 1];
        switch (operator) {
            case "<<": {
                this.reader = new BufferedReader(new FileReader(fileName));
                break;
            }
            case ">": {
                this.writer = new BufferedWriter(new FileWriter(fileName, false));
                break;
            }
            case ">>": {
                this.writer = new BufferedWriter(new FileWriter(fileName, true));
                break;
            }
            default: {
                return args;
            }
        }
        return Arrays.copyOfRange(args, 0, length - 2);
    }
}

