/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.configuration2.BaseHierarchicalConfiguration;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.ConfigurationLogger;
import org.apache.commons.configuration2.tree.ImmutableNode;

public class AbstractYAMLBasedConfiguration
extends BaseHierarchicalConfiguration {
    protected AbstractYAMLBasedConfiguration() {
        this.initLogger(new ConfigurationLogger(this.getClass()));
    }

    protected AbstractYAMLBasedConfiguration(HierarchicalConfiguration<ImmutableNode> c) {
        super(c);
        this.initLogger(new ConfigurationLogger(this.getClass()));
    }

    protected void load(Map<String, Object> map) {
        ImmutableNode.Builder rootBuilder = new ImmutableNode.Builder();
        ImmutableNode top = this.constructHierarchy(rootBuilder, map);
        this.getNodeModel().setRootNode(top);
    }

    protected Map<String, Object> constructMap(ImmutableNode node) {
        HashMap<String, Object> map = new HashMap<String, Object>(node.getChildren().size());
        for (ImmutableNode cNode : node.getChildren()) {
            if (cNode.getChildren().isEmpty()) {
                map.put(cNode.getNodeName(), cNode.getValue());
                continue;
            }
            map.put(cNode.getNodeName(), this.constructMap(cNode));
        }
        return map;
    }

    private ImmutableNode constructHierarchy(ImmutableNode.Builder parent, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Map) {
                ImmutableNode.Builder subtree = new ImmutableNode.Builder().name(key);
                ImmutableNode children = this.constructHierarchy(subtree, (Map)value);
                parent.addChild(children);
                continue;
            }
            ImmutableNode leaf = new ImmutableNode.Builder().name(key).value(value).create();
            parent.addChild(leaf);
        }
        return parent.create();
    }

    static void rethrowException(Exception e) throws ConfigurationException {
        if (e instanceof ClassCastException) {
            throw new ConfigurationException("Error parsing", e);
        }
        throw new ConfigurationException("Unable to load the configuration", e);
    }
}

