/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.remoting.caucho;

import com.caucho.burlap.client.BurlapProxyFactory;
import com.caucho.burlap.client.BurlapRuntimeException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.remoting.RemoteAccessException;
import org.springframework.remoting.RemoteConnectFailureException;
import org.springframework.remoting.RemoteLookupFailureException;
import org.springframework.remoting.RemoteProxyFailureException;
import org.springframework.remoting.support.UrlBasedRemoteAccessor;
import org.springframework.util.Assert;

@Deprecated
public class BurlapClientInterceptor
extends UrlBasedRemoteAccessor
implements MethodInterceptor {
    private BurlapProxyFactory proxyFactory = new BurlapProxyFactory();
    private Object burlapProxy;

    public void setProxyFactory(BurlapProxyFactory proxyFactory) {
        this.proxyFactory = proxyFactory != null ? proxyFactory : new BurlapProxyFactory();
    }

    public void setUsername(String username) {
        this.proxyFactory.setUser(username);
    }

    public void setPassword(String password) {
        this.proxyFactory.setPassword(password);
    }

    public void setOverloadEnabled(boolean overloadEnabled) {
        this.proxyFactory.setOverloadEnabled(overloadEnabled);
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        this.prepare();
    }

    public void prepare() throws RemoteLookupFailureException {
        try {
            this.burlapProxy = this.createBurlapProxy(this.proxyFactory);
        }
        catch (MalformedURLException ex) {
            throw new RemoteLookupFailureException("Service URL [" + this.getServiceUrl() + "] is invalid", (Throwable)ex);
        }
    }

    protected Object createBurlapProxy(BurlapProxyFactory proxyFactory) throws MalformedURLException {
        Assert.notNull((Object)this.getServiceInterface(), (String)"Property 'serviceInterface' is required");
        return proxyFactory.create(this.getServiceInterface(), this.getServiceUrl());
    }

    @Override
    public Object invoke(MethodInvocation invocation) throws Throwable {
        if (this.burlapProxy == null) {
            throw new IllegalStateException("BurlapClientInterceptor is not properly initialized - invoke 'prepare' before attempting any operations");
        }
        ClassLoader originalClassLoader = this.overrideThreadContextClassLoader();
        try {
            Object object = invocation.getMethod().invoke(this.burlapProxy, invocation.getArguments());
            return object;
        }
        catch (InvocationTargetException ex) {
            Throwable targetEx = ex.getTargetException();
            if (targetEx instanceof BurlapRuntimeException) {
                Throwable cause = targetEx.getCause();
                throw this.convertBurlapAccessException(cause != null ? cause : targetEx);
            }
            if (targetEx instanceof UndeclaredThrowableException) {
                UndeclaredThrowableException utex = (UndeclaredThrowableException)targetEx;
                throw this.convertBurlapAccessException(utex.getUndeclaredThrowable());
            }
            throw targetEx;
        }
        catch (Throwable ex) {
            throw new RemoteProxyFailureException("Failed to invoke Burlap proxy for remote service [" + this.getServiceUrl() + "]", ex);
        }
        finally {
            this.resetThreadContextClassLoader(originalClassLoader);
        }
    }

    protected RemoteAccessException convertBurlapAccessException(Throwable ex) {
        if (ex instanceof ConnectException) {
            return new RemoteConnectFailureException("Cannot connect to Burlap remote service at [" + this.getServiceUrl() + "]", ex);
        }
        return new RemoteAccessException("Cannot access Burlap remote service at [" + this.getServiceUrl() + "]", ex);
    }
}

