/*
 * Decompiled with CFR 0.152.
 */
package com.avaya.generic.channel.testclient;

import com.avaya.generic.channel.testclient.CommandProcessor;
import com.avaya.generic.channel.testclient.Configuration;
import com.avaya.generic.channel.testclient.EventListener;
import com.avaya.generic.channel.testclient.utils.Rest;
import com.avaya.generic.channel.testclient.utils.Utils;
import java.io.File;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class TestClient {
    private static final Options options;

    private TestClient() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        ShutdownHook shutdownHook = new ShutdownHook();
        try {
            Utils.println("======= Generic Channel API Test Client v.2 =======");
            File propertiesFile = TestClient.parseArgsAndReturnPropertiesFile(args);
            Configuration configuration = new Configuration(propertiesFile);
            EventListener eventListener = new EventListener();
            CommandProcessor commandProcessor = new CommandProcessor(configuration, eventListener);
            shutdownHook.setEventListener(eventListener);
            Runtime.getRuntime().addShutdownHook(shutdownHook);
            while (true) {
                Utils.printSeparator();
                Utils.print(" > ");
                String line = Utils.readLine();
                if (Utils.isNullOrEmpty(line)) continue;
                if (line.equalsIgnoreCase("exit")) break;
                if (line.equalsIgnoreCase("quit")) {
                    break;
                }
                Utils.printSeparator();
                try {
                    commandProcessor.execute(line);
                }
                catch (Exception e) {
                    Utils.printException(e);
                }
            }
        }
        catch (ParseException pe) {
            Utils.printSeparator();
            Utils.println(pe.getMessage());
            Utils.printSeparator();
            Utils.println("Usage:");
            Utils.println("test-client.bat -p <properties_file>");
            Utils.println("test-client.bat <properties_file>");
        }
        catch (Exception e) {
            Utils.printException(e);
        }
        finally {
            Thread shutdownHookThread = new Thread();
            shutdownHookThread.start();
        }
    }

    private static File parseArgsAndReturnPropertiesFile(String[] args) throws ParseException {
        DefaultParser parser = new DefaultParser();
        CommandLine cmdLine = parser.parse(options, args);
        String pArg = cmdLine.getOptionValue("p");
        List<String> leftOverArgs = cmdLine.getArgList();
        if (pArg != null) {
            if (leftOverArgs.isEmpty()) {
                return new File(pArg);
            }
            throw new ParseException("Illegal arguments");
        }
        if (leftOverArgs.size() == 1) {
            return new File(leftOverArgs.get(0));
        }
        if (leftOverArgs.isEmpty()) {
            throw new ParseException("No arguments");
        }
        throw new ParseException("Illegal arguments");
    }

    static {
        System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.NoOpLog");
        options = new Options().addOption(Option.builder("p").hasArg().argName("file").desc("Properties file").build());
    }

    private static class ShutdownHook
    extends Thread {
        private EventListener eventListener = null;

        private ShutdownHook() {
        }

        void setEventListener(EventListener eventListener) {
            this.eventListener = eventListener;
        }

        @Override
        public void run() {
            try {
                Rest.shutdown();
                if (this.eventListener != null) {
                    this.eventListener.shutdown();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

